/*
 * Decompiled with CFR 0.152.
 */
package controller;

import SteeringProperties.PathFollowingProperties;
import SteeringProperties.SteeringProperties;
import Steerings.SteeringManager;
import Steerings.SteeringType;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public class Bot
extends UT2004BotModuleController {
    private Location startingLocation = SteeringManager.getRandomStartLocation();
    private SteeringManager myManager;
    private HashMap<SteeringType, SteeringProperties> mySteerings;
    private String myName;
    private boolean shouldMove;
    private Vector3d myVelocity;

    public void prepareBot(UT2004Bot bot) {
    }

    public Initialize getInitializeCommand() {
        System.out.println("start " + this.startingLocation);
        return new Initialize().setName(this.myName).setLocation(this.startingLocation);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.myManager = new SteeringManager(this.bot, this.raycasting, this.move);
        this.setSteerings(this.mySteerings);
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        if (this.shouldMove) {
            this.move.moveContinuos();
        }
    }

    public void logic() throws PogamutException {
        if (this.shouldMove) {
            this.myManager.run();
        }
    }

    public void init(String botName, Location startingLocation, HashMap<SteeringType, SteeringProperties> mySteerings) {
        this.startingLocation = startingLocation;
        this.myName = botName;
        this.mySteerings = mySteerings;
        this.shouldMove = true;
    }

    public void setSteerings(HashMap<SteeringType, SteeringProperties> mySteerings) {
        this.mySteerings = mySteerings;
        for (SteeringProperties prop : mySteerings.values()) {
            System.out.println(prop.getType() + " " + prop.toString());
            if (prop.isActive()) {
                if (!this.myManager.hasSteering(prop.getType())) {
                    System.out.println("We add steering " + prop.getType());
                    this.myManager.addSteering(prop.getType());
                }
                if (prop.getType() == SteeringType.PATH_FOLLOWING) {
                    this.managePath((PathFollowingProperties)prop);
                }
                this.myManager.setSteeringProperties(prop.getType(), prop);
                System.out.println("We set new properties. " + prop.getType().toString());
                continue;
            }
            if (!this.myManager.hasSteering(prop.getType())) continue;
            this.myManager.removeSteering(prop.getType());
        }
    }

    private void managePath(PathFollowingProperties prop) {
        if (prop.getPath() == null) {
            IPathFuture<Location> path = this.pathPlanner.computePath(this.startingLocation, prop.getTargetLocation());
            prop.setPath(path);
        }
    }

    public void pause() {
        this.myVelocity = this.bot.getVelocity().getVector3d();
        this.move.stopMovement();
        this.shouldMove = false;
    }

    public void playAgain() {
        System.out.println("New velocity " + this.myVelocity);
        this.myManager.moveTheBot(this.myVelocity, false);
        this.move.moveContinuos();
        this.shouldMove = true;
    }
}

