/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.unreal.bot.impl;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarted;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class NativeUnrealBotAdapter
implements IUnrealBot {
    private IAgentLogger logger = new IAgentLogger(){
        private LogCategory single = new LogCategory("default");
        private ILogCategories categories = new ILogCategories(){

            public boolean hasCategory(String name) {
                if (name == null) {
                    return false;
                }
                return name.equalsIgnoreCase("default");
            }

            public Map<String, LogCategory> getCategories() {
                HashMap<String, LogCategory> categories = new HashMap<String, LogCategory>();
                categories.put("default", single);
                return Collections.unmodifiableMap(categories);
            }

            public String[] getCategoryNames() {
                return new String[]{"default"};
            }

            public String[] getCategoryNamesSorted() {
                return new String[]{"default"};
            }

            public LogCategory getCategory(String name) {
                if (name == null) {
                    throw new UnsupportedOperationException("Not supported for the native bot.");
                }
                if (name.equals("default")) {
                    return single;
                }
                throw new UnsupportedOperationException("Not supported for the native bot.");
            }

            public void setLevel(Level newLevel) {
                single.setLevel(newLevel);
            }

            public void addLogCategory(String name, LogCategory category) {
                throw new UnsupportedOperationException("Not supported for the native bot.");
            }
        };

        public Handler addDefaultConsoleHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public Handler addDefaultFileHandler(File file) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void addDefaultHandler(Handler handler) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public Handler addDefaultPublisher(ILogPublisher publisher) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void addToAllCategories(ILogPublisher logPublisher) {
            this.single.addHandler(logPublisher);
        }

        public void addToAllCategories(Handler handler) {
            this.single.addHandler(handler);
        }

        public IAgentId getAgentId() {
            return NativeUnrealBotAdapter.this.agentId;
        }

        public Map<String, LogCategory> getCategories() {
            return this.categories.getCategories();
        }

        public LogCategory getCategory(IComponent component) {
            return this.categories.getCategory(component.getComponentId().getToken());
        }

        public LogCategory getCategory(String name) {
            return this.categories.getCategory(name);
        }

        public void setLevel(Level newLevel) {
            this.categories.setLevel(newLevel);
        }

        public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public Integer getNetworkLoggerPort() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public Handler addDefaultNetworkHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public boolean isDefaultConsoleHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public boolean isDefaultNetworkHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void removeDefaultConsoleHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void removeDefaultHandler(Handler handler) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void removeDefaultNetworkHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        public void removeFromAllCategories(Handler handler) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }
    };
    protected Player player = null;
    protected IUnrealServer server = null;
    protected IAct act;
    protected IWorldView worldView = null;
    private Flag<IAgentState> state = new Flag((Object)new AgentStateStarted("Native bot is running."));
    private IAgentId agentId;
    private Folder folder = new Folder("empty"){
        private Folder[] subfolders;
        private Property[] properties;
        {
            this.subfolders = new Folder[0];
            this.properties = new Property[0];
        }

        public Folder[] getFolders() throws IntrospectionException {
            return this.subfolders;
        }

        public Property[] getProperties() throws IntrospectionException {
            return this.properties;
        }
    };

    public NativeUnrealBotAdapter(Player player, IUnrealServer server, IAct act, IWorldView worldView) {
        this.player = player;
        this.agentId = new AgentId(player.getName());
        this.server = server;
        this.act = act;
        this.worldView = worldView;
    }

    public IAct getAct() {
        throw new UnsupportedOperationException("Native bots cannot be controled from Java.");
    }

    public IWorldView getWorldView() {
        return this.worldView;
    }

    public IAgentId getComponentId() {
        return this.agentId;
    }

    public String getName() {
        return (String)this.agentId.getName().getFlag();
    }

    public IAgentLogger getLogger() {
        return this.logger;
    }

    public IComponentBus getEventBus() {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    public ImmutableFlag<IAgentState> getState() {
        return this.state.getImmutable();
    }

    public void start() throws AgentException {
        throw new UnsupportedOperationException("Native bot is already started.");
    }

    public void pause() throws AgentException {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    public void resume() throws AgentException {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    public void kill() {
        this.stop();
    }

    public Folder getIntrospection() {
        return this.folder;
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public Velocity getVelocity() {
        return this.player.getVelocity();
    }

    public Rotation getRotation() {
        return this.player.getRotation();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NativeUnrealBotAdapter)) {
            return false;
        }
        NativeUnrealBotAdapter otherAdapter = (NativeUnrealBotAdapter)other;
        return this.agentId.equals(otherAdapter.getComponentId());
    }

    public int hashCode() {
        return this.agentId.hashCode();
    }
}

