/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarting;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.server.AbstractWorldServer;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.NativeUT2004BotAdapter;
import cz.cuni.amis.pogamut.ut2004.bot.jmx.BotJMXProxy;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetMaps;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.PlayerListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.UT2004Map;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.TranslatedObservableCollection;
import cz.cuni.amis.utils.collections.adapters.WVVisibleObjectsSetAdapter;
import cz.cuni.amis.utils.flag.Flag;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public abstract class AbstractUT2004Server<WORLD_VIEW extends IWorldView, ACT extends IAct>
extends AbstractWorldServer<WORLD_VIEW, ACT, IUT2004Bot>
implements IUT2004Server {
    ObservableCollection<Player> players = null;
    List<Mutator> mutators = null;
    Flag<Double> gameSpeed = new Flag();
    List<MapList> maps = null;
    Flag<String> mapName = new Flag();
    private UT2004Map map;
    ObservableCollection<? extends NativeUT2004BotAdapter> nativeAgents = null;
    ObservableCollection<IUT2004Bot> agents = null;
    private String desiredPassword = null;
    private IWorldEventListener<PlayerListObtained> playerListObtainedListener = new IWorldEventListener<PlayerListObtained>(){

        public void notify(PlayerListObtained event) {
            AbstractUT2004Server.this.players.addAll(event.getPlayers());
        }
    };
    private IWorldEventListener<MapPointListObtained> mapPointListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            AbstractUT2004Server.this.getAct().act((CommandMessage)new GetMaps());
        }
    };
    private SocketConnection connection;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUT2004Server.this.setState((AgentState)new AgentStateStarting("GameBots2004 greeted us, sending READY."));
            AbstractUT2004Server.this.readyCommandRequested();
            AbstractUT2004Server.this.setState((AgentState)new AgentStateStarting("READY sent."));
        }
    };
    private PasswordReply passwordReply = null;
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUT2004Server.this.setState((AgentState)new AgentStateStarting("Password requested by the world."));
            AbstractUT2004Server.this.passwordReply = AbstractUT2004Server.this.createPasswordReply();
            if (AbstractUT2004Server.this.passwordReply == null) {
                AbstractUT2004Server.this.passwordReply = new PasswordReply("");
            }
            if (AbstractUT2004Server.this.log.isLoggable(Level.INFO)) {
                AbstractUT2004Server.this.log.info("Password required for the world, replying with '" + AbstractUT2004Server.this.passwordReply.getPassword() + "'.");
            }
            AbstractUT2004Server.this.getAct().act((CommandMessage)AbstractUT2004Server.this.passwordReply);
        }
    };
    private GameInfo gameInfo = null;

    @Inject
    public AbstractUT2004Server(IAgentId agentId, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, WORLD_VIEW worldView, ACT act) {
        super(agentId, agentLogger, bus, worldView, act);
        this.connection = connection;
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addEventListener(PlayerListObtained.class, this.playerListObtainedListener);
        this.getWorldView().addEventListener(MapPointListObtained.class, this.mapPointListObtainedListener);
        this.players = new WVVisibleObjectsSetAdapter(Player.class, this.getWorldView());
    }

    @Override
    public void setAddress(String host, int port) {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Setting address to: " + host + ":" + port);
        }
        this.connection.setAddress((IWorldConnectionAddress)new SocketConnectionAddress(host, port));
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public GameInfo getGameInfo() {
        if (this.gameInfo == null) {
            this.gameInfo = (GameInfo)this.getWorldView().getSingle(GameInfo.class);
        }
        return this.gameInfo;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)super.getWorldView();
    }

    @Override
    public Collection<MapList> getAvailableMaps() {
        return this.maps;
    }

    @Override
    public Flag<Double> getGameSpeedFlag() {
        return this.gameSpeed;
    }

    @Override
    public String getMapName() {
        if (this.getGameInfo() == null) {
            return null;
        }
        return this.getGameInfo().getLevel();
    }

    @Override
    public ObservableCollection<Player> getPlayers() {
        return this.players;
    }

    @Override
    public List<Mutator> getMutators() {
        return this.mutators;
    }

    public ObservableCollection<IUT2004Bot> getAgents() {
        if (this.agents != null) {
            return this.agents;
        }
        if (this.getPlayers() == null) {
            return null;
        }
        this.agents = new TranslatedObservableCollection<IUT2004Bot, Player>(this.getPlayers()){

            protected IUT2004Bot translate(Player obj) {
                if (obj.getJmx() != null) {
                    try {
                        return new BotJMXProxy(obj.getJmx());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUT2004Server.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.agents;
    }

    public ObservableCollection<? extends NativeUT2004BotAdapter> getNativeAgents() {
        if (this.nativeAgents != null) {
            return this.nativeAgents;
        }
        if (this.getPlayers() == null) {
            return null;
        }
        this.nativeAgents = new TranslatedObservableCollection<NativeUT2004BotAdapter, Player>(this.getPlayers()){

            protected NativeUT2004BotAdapter translate(Player obj) {
                if (obj.getJmx() == null) {
                    try {
                        return new NativeUT2004BotAdapter(obj, AbstractUT2004Server.this, AbstractUT2004Server.this.getAct(), (IWorldView)AbstractUT2004Server.this.getWorldView());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUT2004Server.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.nativeAgents;
    }

    @Override
    public void connectNativeBot(String botName, String botType) {
        this.getAct().act((CommandMessage)new AddBot(botName, null, null, 3, botType));
    }

    @Override
    public UT2004Map getMap() {
        if (this.map == null) {
            this.map = new UT2004Map((IWorldView)this.getWorldView());
        }
        return this.map;
    }

    protected void reset() {
        this.map = null;
        this.gameInfo = null;
        if (this.players != null) {
            this.players.clear();
        }
        if (this.mutators != null) {
            this.mutators.clear();
        }
        if (this.maps != null) {
            this.maps.clear();
        }
        if (this.nativeAgents != null) {
            this.nativeAgents.clear();
        }
        if (this.agents != null) {
            this.agents.clear();
        }
    }

    protected void resetAgent() {
        super.resetAgent();
        this.reset();
    }

    protected void stopAgent() {
        super.stopAgent();
        this.reset();
    }

    protected void killAgent() {
        super.killAgent();
        this.reset();
    }

    protected void startAgent() {
        super.startAgent();
    }
}

