/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages;

import cz.cuni.amis.utils.maps.HashMapSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class ItemType
implements Serializable {
    public static final HashMapSet<Category, ItemType> CATEGORIES = new HashMapSet();
    public static final HashMapSet<Group, ItemType> GROUPS = new HashMapSet();
    private static HashMap<String, ItemType> protos = new HashMap();
    public static final ItemType TRANSLOCATOR = ItemType.MakePrototype(Category.WEAPON, Group.TRANSLOCATOR, new String[]{"XWeapons.TransPickup", "XWeapons.Transpickup"});
    public static final ItemType SHIELD_GUN = ItemType.MakePrototype(Category.WEAPON, Group.SHIELD_GUN, new String[]{"XWeapons.ShieldGunPickup"});
    public static final ItemType SHIELD_GUN_AMMO = ItemType.MakePrototype(Category.AMMO, Group.SHIELD_GUN, new String[]{"XWeapons.ShieldAmmoPickup", "XWeapons.ShieldAmmo"});
    public static final ItemType ASSAULT_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.ASSAULT_RIFLE, new String[]{"XWeapons.AssaultRiflePickup"});
    public static final ItemType ASSAULT_RIFLE_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ASSAULT_RIFLE, new String[]{"XWeapons.AssaultAmmoPickup", "XWeapons.AssaultAmmo"});
    public static final ItemType ASSAULT_RIFLE_GRENADE = ItemType.MakePrototype(Category.AMMO, Group.ASSAULT_RIFLE, new String[]{"XWeapons.GrenadeAmmoPickup", "XWeapons.GrenadeAmmo"});
    public static final ItemType BIO_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.BIO_RIFLE, new String[]{"XWeapons.BioRiflePickup", "UTClassic.ClassicBioRiflePickup"});
    public static final ItemType BIO_RIFLE_AMMO = ItemType.MakePrototype(Category.AMMO, Group.BIO_RIFLE, new String[]{"XWeapons.BioAmmoPickup", "XWeapons.BioAmmo"});
    public static final ItemType SHOCK_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.SHOCK_RIFLE, new String[]{"XWeapons.ShockRiflePickup", "UTClassic.ClassicShockRiflePickup"});
    public static final ItemType SHOCK_RIFLE_AMMO = ItemType.MakePrototype(Category.AMMO, Group.SHOCK_RIFLE, new String[]{"XWeapons.ShockAmmoPickup", "XWeapons.ShockAmmo"});
    public static final ItemType LINK_GUN = ItemType.MakePrototype(Category.WEAPON, Group.LINK_GUN, new String[]{"XWeapons.LinkGunPickup"});
    public static final ItemType LINK_GUN_AMMO = ItemType.MakePrototype(Category.AMMO, Group.LINK_GUN, new String[]{"XWeapons.LinkAmmoPickup", "XWeapons.LinkAmmo"});
    public static final ItemType MINIGUN = ItemType.MakePrototype(Category.WEAPON, Group.MINIGUN, new String[]{"XWeapons.MinigunPickup", "UTClassic.ClassicMinigunPickup"});
    public static final ItemType MINIGUN_AMMO = ItemType.MakePrototype(Category.AMMO, Group.MINIGUN, new String[]{"XWeapons.MinigunAmmoPickup", "XWeapons.MinigunAmmo"});
    public static final ItemType FLAK_CANNON = ItemType.MakePrototype(Category.WEAPON, Group.FLAK_CANNON, new String[]{"XWeapons.FlakCannonPickup", "UTClassic.ClassicFlakCannonPickup"});
    public static final ItemType FLAK_CANNON_AMMO = ItemType.MakePrototype(Category.AMMO, Group.FLAK_CANNON, new String[]{"XWeapons.FlakAmmoPickup", "XWeapons.FlakAmmo"});
    public static final ItemType ROCKET_LAUNCHER = ItemType.MakePrototype(Category.WEAPON, Group.ROCKET_LAUNCHER, new String[]{"XWeapons.RocketLauncherPickup", "UTClassic.ClassicRocketLauncherPickup"});
    public static final ItemType ROCKET_LAUNCHER_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ROCKET_LAUNCHER, new String[]{"XWeapons.RocketAmmoPickup", "XWeapons.RocketAmmo"});
    public static final ItemType LIGHTNING_GUN = ItemType.MakePrototype(Category.WEAPON, Group.LIGHTNING_GUN, new String[]{"XWeapons.SniperRiflePickup"});
    public static final ItemType LIGHTNING_GUN_AMMO = ItemType.MakePrototype(Category.AMMO, Group.LIGHTNING_GUN, new String[]{"XWeapons.SniperAmmoPickup", "XWeapons.SniperAmmo"});
    public static final ItemType SNIPER_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.SNIPER_RIFLE, new String[]{"UTClassic.ClassicSniperRiflePickup"});
    public static final ItemType SNIPER_RIFLE_AMMO = ItemType.MakePrototype(Category.AMMO, Group.SNIPER_RIFLE, new String[]{"UTClassic.ClassicSniperAmmoPickup", "UTClassic.ClassicSniperAmmo"});
    public static final ItemType REDEEMER = ItemType.MakePrototype(Category.WEAPON, Group.REDEEMER, new String[]{"XWeapons.RedeemerPickup"});
    public static final ItemType SUPER_SHOCK_RIFLE = ItemType.MakePrototype(Category.WEAPON, Group.SUPER_SHOCK_RIFLE, new String[]{"XWeapons.SuperShockRiflePickup"});
    public static final ItemType ION_PAINTER = ItemType.MakePrototype(Category.WEAPON, Group.ION_PAINTER, new String[]{"XWeapons.PainterPickup"});
    public static final ItemType ONS_MINE_LAYER = ItemType.MakePrototype(Category.WEAPON, Group.ONS_MINE_LAYER, new String[]{"Onslaught.ONSMineLayerPickup"});
    public static final ItemType ONS_MINE_LAYER_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ONS_MINE_LAYER, new String[]{"Onslaught.ONSMineAmmoPickup", "Onslaught.ONSMineAmmo"});
    public static final ItemType ONS_GRENADE_LAUNCHER = ItemType.MakePrototype(Category.WEAPON, Group.ONS_GRENADE_LAUNCHER, new String[]{"Onslaught.ONSGrenadePickup"});
    public static final ItemType ONS_GRENADE_LAUNCHER_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ONS_GRENADE_LAUNCHER, new String[]{"Onslaught.ONSGrenadeAmmoPickup"});
    public static final ItemType ONS_AVRIL = ItemType.MakePrototype(Category.WEAPON, Group.ONS_AVRIL, new String[]{"Onslaught.ONSAVRiLPickup"});
    public static final ItemType ONS_AVRIL_AMMO = ItemType.MakePrototype(Category.AMMO, Group.ONS_AVRIL, new String[]{"Onslaught.ONSAVRiLAmmoPickup"});
    public static final ItemType ONS_TARGET_PAINTER = ItemType.MakePrototype(Category.WEAPON, Group.ONS_TARGET_PAINTER, new String[]{"OnslaughtFull.ONSPainterPickup"});
    public static final ItemType HEALTH_PACK = ItemType.MakePrototype(Category.HEALTH, Group.HEALTH, new String[]{"XPickups.HealthPack", "XPickups.TournamentHealth"});
    public static final ItemType MINI_HEALTH_PACK = ItemType.MakePrototype(Category.HEALTH, Group.MINI_HEALTH, new String[]{"XPickups.MiniHealthPack"});
    public static final ItemType SUPER_HEALTH_PACK = ItemType.MakePrototype(Category.HEALTH, Group.SUPER_HEALTH, new String[]{"XPickups.SuperHealthPack"});
    public static final ItemType SHIELD_PACK = ItemType.MakePrototype(Category.ARMOR, Group.SMALL_ARMOR, new String[]{"XPickups.ShieldPack", "XPickups.ShieldPickup"});
    public static final ItemType SUPER_SHIELD_PACK = ItemType.MakePrototype(Category.ARMOR, Group.SUPER_ARMOR, new String[]{"XPickups.SuperShieldPack"});
    public static final ItemType U_DAMAGE_PACK = ItemType.MakePrototype(Category.OTHER, Group.UDAMAGE, new String[]{"XPickups.UDamagePack", "XGame.UDamageReward"});
    public static final ItemType ADRENALINE_PACK = ItemType.MakePrototype(Category.ADRENALINE, Group.ADRENALINE, new String[]{"XPickups.AdrenalinePickup"});
    public static final ItemType KEY = ItemType.MakePrototype(Category.OTHER, Group.KEY, new String[]{"UnrealGame.KeyPickup"});
    public static final ItemType NONE = ItemType.MakePrototype(Category.OTHER, Group.NONE, new String[]{"None", "NONE", "none"});
    private String name;
    private Category category;
    private Group group;
    private ItemType proto;

    public String toString() {
        return "ItemType[name = " + this.name + ", category = " + (Object)((Object)this.category) + ", group = " + (Object)((Object)this.group) + "]";
    }

    public Category getCategory() {
        return this.category == null ? (this.category = this.getProto().category) : this.category;
    }

    public Group getGroup() {
        return this.group == null ? (this.group = this.getProto().group) : this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemType getProto() {
        if (this.proto != null) {
            return this.proto;
        }
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            this.proto = protos.get(this.name);
            return this.proto;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ItemType && this.getProto() == ((ItemType)obj).getProto();
    }

    public int hashCode() {
        return this.getProto().name.hashCode();
    }

    public ItemType(String name) {
        this.name = name;
        this.category = Category.OTHER;
        this.group = Group.OTHER;
        this.proto = this;
    }

    private ItemType(String name, Category category, Group group) {
        this.name = name;
        this.category = category;
        this.group = group;
        this.proto = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType MakePrototype(Category category, Group group, String[] utNames) {
        ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = new ItemType(utNames[0], category, group);
            for (String utName : utNames) {
                protos.put(utName, type);
            }
            if (category != null) {
                CATEGORIES.get((Object)category).add(type);
            }
            if (group != null) {
                GROUPS.get((Object)group).add(type);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType getItemType(String utName) {
        ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Group {
        TRANSLOCATOR("Translocator"),
        SHIELD_GUN("ShieldGun"),
        ASSAULT_RIFLE("AssaultRifle"),
        BIO_RIFLE("BioRifle"),
        SHOCK_RIFLE("ShockRifle"),
        LINK_GUN("LinkGun"),
        MINIGUN("Minigun"),
        FLAK_CANNON("FlakCannon"),
        ROCKET_LAUNCHER("RocketLauncher"),
        LIGHTNING_GUN("LightningGun"),
        SNIPER_RIFLE("SniperRifle"),
        ION_PAINTER("IonPainter"),
        REDEEMER("Redeemer"),
        SUPER_SHOCK_RIFLE("SuperShockRifle"),
        ONS_MINE_LAYER("ONS MineLayer"),
        ONS_GRENADE_LAUNCHER("ONS GrenadeLauncher"),
        ONS_AVRIL("ONS AVRiL"),
        ONS_TARGET_PAINTER("TargetPainter"),
        HEALTH("HealthKit"),
        MINI_HEALTH("HealthVial"),
        SUPER_HEALTH("SuperHealth"),
        SMALL_ARMOR("SmallShield"),
        SUPER_ARMOR("SuperShield"),
        ADRENALINE("Adrenaline"),
        UDAMAGE("UDamage"),
        KEY("Key"),
        OTHER("Unknown"),
        NONE("None");

        public String name;

        private Group(String name) {
            this.name = name;
        }

        public Set<ItemType> getTypes() {
            return GROUPS.get((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        WEAPON("Weapon"),
        AMMO("Ammo"),
        HEALTH("Health"),
        ARMOR("Armor"),
        SHIELD("Shield"),
        ADRENALINE("Adrenaline"),
        OTHER("Other");

        public String name;

        private Category(String name) {
            this.name = name;
        }

        public Set<ItemType> getTypes() {
            return CATEGORIES.get((Object)this);
        }
    }
}

