/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.analyzer.stats;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerObserverParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.logging.Logger;

public class UT2004AnalyzerObsStats
extends UT2004AnalyzerObserver {
    public static double LOG_FREQUENCY = 0.5;
    protected Formatter outputFile = null;
    protected IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            UT2004AnalyzerObsStats.this.self = (Self)event.getObject();
        }
    };
    protected IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            if (UT2004AnalyzerObsStats.this.lastTime < 0.0) {
                UT2004AnalyzerObsStats.this.lastTime = event.getTime();
            }
            UT2004AnalyzerObsStats.this.update(event);
        }
    };
    protected IWorldEventListener<BotKilled> botKilledListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            ++UT2004AnalyzerObsStats.this.deaths;
            UT2004AnalyzerObsStats.this.lastPosition = null;
        }
    };
    protected double lastTime = -1.0;
    protected double currentTime;
    protected double timeToLogLeft = LOG_FREQUENCY;
    protected int deaths = 0;
    protected double travelledDistance = 0.0;
    protected Location lastPosition = null;
    protected Self self = null;

    protected File getNewObserverFile(String extension) {
        for (int i = 0; i < 999; ++i) {
            String fileName = this.getObservedBotId().getStringId() + "_" + i + "." + extension;
            File file = new File(fileName);
            if (file.exists()) continue;
            return file;
        }
        throw new PogamutException("No suitable filename for bot's observer '" + this.getObservedBotId().getStringId() + "'...", (Object)this);
    }

    @Inject
    public UT2004AnalyzerObsStats(UT2004AnalyzerObserverParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        File file = this.getNewObserverFile(".csv");
        try {
            this.outputFile = new Formatter(file);
            this.outputFile.format("Time;Health;Deaths;Distance;Position.x;Bot.Location.y;Bot.Location.z\n", new Object[0]);
        }
        catch (FileNotFoundException e) {
            throw new PogamutException("Can't open file '" + file.getAbsoluteFile() + "' for write, can't log!", (Logger)this.log, (Object)this);
        }
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(BotKilled.class, this.botKilledListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(EndMessage.class, this.endMessageListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
    }

    protected void configureObserver() {
        this.getAct().act((CommandMessage)new ConfigurationObserver().setUpdate(0.2).setAll(true).setSelf(true).setAsync(true).setGame(false).setSee(false).setSpecial(false));
    }

    protected void update(EndMessage event) {
        if (this.self == null) {
            this.log.warning("No SELF present for observed bot '" + this.getObservedBotId().getStringId() + "'.");
            return;
        }
        Location actPosition = this.self.getLocation();
        if (this.lastPosition != null) {
            this.travelledDistance += Location.getDistance((Location)this.lastPosition, (Location)actPosition);
        }
        this.lastPosition = actPosition;
        this.timeToLogLeft -= event.getTime() - this.lastTime;
        this.currentTime += event.getTime() - this.lastTime;
        this.lastTime = event.getTime();
        if (this.timeToLogLeft < 0.0) {
            this.timeToLogLeft = LOG_FREQUENCY;
            this.outputFile.format("%.3f;%d;%d;%.2f;%.2f;%.2f;%.2f\n", this.currentTime, this.self.getHealth(), this.deaths, this.travelledDistance, this.self.getLocation().x, this.self.getLocation().y, this.self.getLocation().z);
            this.outputFile.flush();
        }
    }

    protected void stopAgent() {
        super.stopAgent();
        this.outputFile.close();
    }

    protected void killAgent() {
        super.killAgent();
        this.outputFile.close();
    }
}

