/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.analyzer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerObserverParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004AnalyzerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ObserverFactory;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004AnalyzerRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ObserverRunner;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UT2004Analyzer
extends UT2004Server
implements IUT2004Analyzer {
    private Object mutex = new Object();
    private IWorldEventListener<PlayerJoinsGame> playerJoinsGameListener = new IWorldEventListener<PlayerJoinsGame>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerJoinsGame event) {
            if (UT2004Analyzer.this.log.isLoggable(Level.INFO)) {
                UT2004Analyzer.this.log.info("New bot has connected to the game, creating new observer for the bot with id '" + event.getId().getStringId() + "'.");
            }
            IUT2004AnalyzerObserver observer = (IUT2004AnalyzerObserver)UT2004Analyzer.this.getObserverRunner().startAgents(new UT2004AnalyzerObserverParameters[]{new UT2004AnalyzerObserverParameters().setObservedAgentId(event.getId().getStringId())}).get(0);
            Map map = UT2004Analyzer.this.observers;
            synchronized (map) {
                UT2004Analyzer.this.observers.put(event.getId(), observer);
            }
        }
    };
    private IWorldEventListener<PlayerLeft> playerLeftListener = new IWorldEventListener<PlayerLeft>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerLeft event) {
            IUT2004AnalyzerObserver observer;
            Map map = UT2004Analyzer.this.observers;
            synchronized (map) {
                observer = (IUT2004AnalyzerObserver)UT2004Analyzer.this.observers.get(event.getId());
            }
            if (UT2004Analyzer.this.log.isLoggable(Level.INFO)) {
                UT2004Analyzer.this.log.info("Bot '" + event.getId().getStringId() + "' has left the game");
            }
            if (observer != null) {
                if (UT2004Analyzer.this.log.isLoggable(Level.INFO)) {
                    UT2004Analyzer.this.log.info("Stopping observer for the bot.");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException((Throwable)e, (Object)this);
                }
                if (observer.getState().getFlag() instanceof IAgentStateUp) {
                    try {
                        observer.stop();
                    }
                    catch (Exception e) {
                        UT2004Analyzer.this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be stopped, killing...");
                        try {
                            observer.kill();
                        }
                        catch (Exception e2) {
                            UT2004Analyzer.this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be killed: " + e2.getMessage());
                        }
                    }
                }
                map = UT2004Analyzer.this.observers;
                synchronized (map) {
                    UT2004Analyzer.this.observers.remove(event.getId());
                }
            }
            if (UT2004Analyzer.this.log.isLoggable(Level.WARNING)) {
                UT2004Analyzer.this.log.warning("The bot '" + event.getId().getStringId() + "' has no observer attached, was not observer, probably because the analyzer has been started after the bot itself.");
            }
        }
    };
    private Map<UnrealId, IUT2004AnalyzerObserver> observers = new HashMap<UnrealId, IUT2004AnalyzerObserver>();
    private UT2004ObserverRunner<IUT2004AnalyzerObserver, UT2004AnalyzerObserverParameters> observerRunner;

    @Inject
    public UT2004Analyzer(UT2004AnalyzerParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerJoinsGame.class, this.playerJoinsGameListener);
        ((UT2004WorldView)((Object)this.getWorldView())).addEventListener(PlayerLeft.class, this.playerLeftListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UT2004ObserverRunner<IUT2004AnalyzerObserver, UT2004AnalyzerObserverParameters> getObserverRunner() {
        if (this.observerRunner == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.observerRunner == null) {
                    this.observerRunner = new UT2004ObserverRunner(new UT2004ObserverFactory(this.getParams().getObserverModule()));
                }
            }
        }
        return this.observerRunner;
    }

    @Override
    public UT2004AnalyzerParameters getParams() {
        return (UT2004AnalyzerParameters)super.getParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UnrealId, IUT2004AnalyzerObserver> getObservers() {
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            return new HashMap<UnrealId, IUT2004AnalyzerObserver>(this.observers);
        }
    }

    @Override
    protected void stopAgent() {
        super.stopAgent();
        this.cleanUp();
    }

    @Override
    protected void killAgent() {
        super.killAgent();
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Map<UnrealId, IUT2004AnalyzerObserver> map = this.observers;
        synchronized (map) {
            for (IUT2004AnalyzerObserver observer : this.observers.values()) {
                if (!(observer.getState().getFlag() instanceof IAgentStateUp)) continue;
                try {
                    observer.stop();
                }
                catch (Exception e) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be stopped, killing...");
                    }
                    try {
                        observer.kill();
                    }
                    catch (Exception e2) {
                        if (!this.log.isLoggable(Level.WARNING)) continue;
                        this.log.warning("Observer for the bot '" + observer.getObservedBotId().getStringId() + "' could not be killed: " + e2.getMessage());
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        UT2004AnalyzerRunner analyzerRunner = new UT2004AnalyzerRunner(new UT2004AnalyzerFactory(new UT2004AnalyzerModule()));
        analyzerRunner.setLogLevel(Level.INFO);
        analyzerRunner.setMain(true).startAgent();
    }
}

