/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;

public class LoqueRunner
implements IUT2004PathRunner {
    private int runnerStep = 0;
    private int runnerSingleJump = 0;
    private int runnerDoubleJump = 0;
    private int collisionCount = 0;
    private Location collisionSpot = null;
    protected UT2004Bot bot;
    protected AgentInfo memory;
    protected AdvancedLocomotion body;
    protected Logger log;
    protected Senses senses;

    public void reset() {
        this.runnerStep = 0;
        this.runnerSingleJump = 0;
        this.runnerDoubleJump = 0;
        this.collisionCount = 0;
        this.collisionSpot = null;
    }

    public boolean runToLocation(Location firstLocation, Location secondLocation, Location focus, NavPointNeighbourLink navPointsLink, boolean reachable) {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.runToLocation(): runnerStep is " + this.runnerStep + ", reachable is " + reachable + ",  navPointsLink is" + (Object)((Object)navPointsLink));
        }
        ++this.runnerStep;
        if (this.runnerStep <= 0) {
            return true;
        }
        if (this.runnerStep <= 1) {
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            if (navPointsLink != null && (navPointsLink.isForceDoubleJump() || navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0) && ((navPointsLink.getFlags() & 8) == 0 || this.memory.getLocation().z - 100.0 <= firstLocation.z)) {
                Location direction = Location.sub((Location)firstLocation, (Location)this.memory.getLocation()).getNormalized();
                Location velocityDir = new Location((Tuple3d)this.memory.getVelocity().asVector3d()).getNormalized();
                Double result = Math.acos(direction.dot(velocityDir));
                if (this.memory.getVelocity().size() > 200.0 && !result.isNaN() && result < 0.3490658503988659) {
                    return this.resolveJump(firstLocation, secondLocation, focus, navPointsLink, reachable);
                }
            }
            return true;
        }
        if (this.runnerSingleJump > 0) {
            return this.iterateSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (this.runnerDoubleJump > 0) {
            return this.iterateDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (this.senses.isCollidingOnce()) {
            return this.resolveCollision(firstLocation, secondLocation, focus, reachable);
        }
        if (this.runnerSingleJump == 0 && this.runnerDoubleJump == 0 && (!reachable || navPointsLink != null && (navPointsLink.isForceDoubleJump() || navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0))) {
            return this.resolveJump(firstLocation, secondLocation, focus, navPointsLink, reachable);
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.runToLocation(): issuing default move command to: " + firstLocation);
        }
        return true;
    }

    private boolean resolveCollision(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.collisionSpot == null || this.memory.getLocation().getDistance2D(this.collisionSpot) > 120.0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.resolveCollision(): collision at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
            }
            this.collisionSpot = this.memory.getLocation();
            this.collisionCount = 1;
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        switch (this.collisionCount++ % 2) {
            case 0: {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Runner.resolveCollision(): repeated collision (" + this.collisionCount + "):" + " double-jumping at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
                }
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Runner.resolveCollision(): repeated collision (" + this.collisionCount + "):" + " single-jumping at " + (int)this.memory.getLocation().getDistance2D(firstLocation));
        }
        return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
    }

    private boolean resolveJump(Location firstLocation, Location secondLocation, Location focus, NavPointNeighbourLink navPointsLink, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int velocity = (int)this.memory.getVelocity().size();
        int jumpDistance = distance % 1000;
        int zDistance = (int)firstLocation.getDistanceZ(this.memory.getLocation());
        this.log.finer("Runner.resolveJump: distance = " + distance + ", velocity = " + velocity + ", jumpDistance = " + (jumpDistance += Math.min(200, Math.max(-200, zDistance))) + ", zDistance = " + zDistance);
        boolean enforceDoubleJump = false;
        if (!(navPointsLink == null || navPointsLink.getNeededJump() == null && (navPointsLink.getFlags() & 8) == 0 || zDistance <= 60 && jumpDistance <= 380)) {
            enforceDoubleJump = true;
            this.log.finest("Runner.resolveJump(): double jump indicated");
        }
        if (jumpDistance < 370) {
            if (navPointsLink != null) {
                if ((navPointsLink.getNeededJump() != null || (navPointsLink.getFlags() & 8) != 0) && enforceDoubleJump) {
                    return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
                }
                return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            if (reachable || distance >= 1000) {
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        if (jumpDistance < 470) {
            if (enforceDoubleJump) {
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            return this.initSingleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        if (jumpDistance < 600) {
            if (enforceDoubleJump) {
                return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
            }
            this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
            return true;
        }
        if (jumpDistance < 700 && velocity > 300) {
            if (!enforceDoubleJump && navPointsLink != null && (navPointsLink.getFlags() & 8) != 0) {
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            return this.initDoubleJumpSequence(firstLocation, secondLocation, focus, reachable);
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    private boolean initSingleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.runnerSingleJump > 0 || this.runnerDoubleJump > 0) {
            throw new RuntimeException("jumping sequence aleady started");
        }
        this.log.finer("Runner.initSingleJumpSequence() !");
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        this.body.jump();
        this.runnerSingleJump = 1;
        return true;
    }

    private boolean iterateSingleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int zVelocity = (int)this.memory.getVelocity().z;
        switch (this.runnerSingleJump) {
            case 1: {
                if (zVelocity > 100) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateSingleJumpSequence(): single-jump registered at " + distance + ", z-velo " + zVelocity);
                    }
                    ++this.runnerSingleJump;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
        }
        if (zVelocity <= 0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer("Runner.iterateSingleJumpSequence(): single-jump completed at " + distance + ", z-velo " + zVelocity);
            }
            this.runnerSingleJump = 0;
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    private boolean initDoubleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        if (this.runnerSingleJump > 0 || this.runnerDoubleJump > 0) {
            throw new RuntimeException("jumping sequence aleady started");
        }
        boolean doubleJump = true;
        double delay = 0.39;
        double jumpZ = 680.0;
        double distanceZ = firstLocation.getDistanceZ(this.memory.getLocation());
        double distance2D = firstLocation.getDistance2D(this.memory.getLocation());
        this.log.finer("Runner.initDoubleJumpSequence(): disntane2D = " + distance2D + ", distanceZ = " + distanceZ);
        if (distanceZ > 0.0) {
            this.log.finer("Runner.initDoubleJumpSequence(): JUMPING UP! Adjusting parameters of the jump...");
            double jumpZ_up = 680.0 * distanceZ / 70.0;
            boolean doubleJump_up = jumpZ_up > 340.0;
            double jumpZ_forward = 680.0;
            boolean doubleJump_forward = true;
            if (distance2D < 250.0) {
                doubleJump_forward = false;
                jumpZ_forward = 340.0 * distance2D / 250.0;
            } else if (distance2D < 350.0) {
                jumpZ_forward = 340.0 + 340.0 * (distance2D - 250.0) / 100.0;
            }
            if (jumpZ_up > jumpZ_forward) {
                jumpZ = jumpZ_up;
                doubleJump = doubleJump_up;
                this.log.finer("Runner.initDoubleJumpSequence(): jumping up more than jumping forward, jumpZ_up = " + jumpZ_up + " > " + jumpZ_forward + " = jumpZ_forward");
            } else {
                jumpZ = jumpZ_forward;
                doubleJump = doubleJump_forward;
                this.log.finer("Runner.initDoubleJumpSequence(): jumping forward more than jumping up, jumpZ_up = " + jumpZ_up + " < " + jumpZ_forward + " = jumpZ_forward");
            }
        } else {
            this.log.finer("Runner.initDoubleJumpSequence(): FALLING DOWN! Adjusting parameters of the jump for falling...");
            double distanceTravelledByFalling = 1.0 * Math.abs(distanceZ);
            double remainingDistance2D = distance2D - distanceTravelledByFalling;
            if (remainingDistance2D < 300.0) {
                this.log.finer("Runner.initDoubleJumpSequence(): single jump suffice, distance2D = " + distance2D + ", estimated distance travelled by just falling = " + distanceTravelledByFalling + ", remaining distance 2D to jump = " + remainingDistance2D);
                doubleJump = false;
                jumpZ = 340.0 * remainingDistance2D / 300.0;
            } else if (remainingDistance2D < 450.0) {
                this.log.finer("Runner.initDoubleJumpSequence(): smaller double jump is needed, distance2D = " + distance2D + ", estimated distance travelled by just falling = " + distanceTravelledByFalling + ", remaining distance 2D to jump = " + remainingDistance2D);
                jumpZ = 340.0 + 340.0 * (remainingDistance2D - 220.0) * 150.0;
            } else {
                this.log.finer("Runner.initDoubleJumpSequence(): full double jump is needed, distance2D = " + distance2D + ", estimated distance travelled by just falling = " + distanceTravelledByFalling + ", remaining distance 2D to jump = " + remainingDistance2D);
            }
        }
        this.log.finer("Runner.initDoubleJumpSequence(): " + (doubleJump ? "double jumping, double jump delay = " + delay : "single jumping") + ", jumpZ = " + jumpZ);
        this.body.doubleJump(delay, jumpZ);
        this.runnerDoubleJump = 1;
        return true;
    }

    private boolean iterateDoubleJumpSequence(Location firstLocation, Location secondLocation, Location focus, boolean reachable) {
        int distance = (int)this.memory.getLocation().getDistance2D(firstLocation);
        int zVelocity = (int)this.memory.getVelocity().z;
        switch (this.runnerDoubleJump) {
            case 1: {
                if (zVelocity > 100) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateDoubleJumpSequence(): double-jump registered at " + distance + ", z-velo " + zVelocity);
                    }
                    ++this.runnerDoubleJump;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
            case 2: {
                if (zVelocity < 150) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Runner.iterateDoubleJumpSequence(): double-jump boost at " + distance + ", z-velo " + zVelocity);
                    }
                    this.body.jump();
                    ++this.runnerDoubleJump;
                    return true;
                }
                this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
                return true;
            }
        }
        if (zVelocity <= 0) {
            this.runnerDoubleJump = 0;
        }
        this.bot.getAct().act((CommandMessage)new Move().setFirstLocation(firstLocation).setSecondLocation(secondLocation).setFocusLocation(focus));
        return true;
    }

    public LoqueRunner(UT2004Bot bot, AgentInfo agentInfo, AdvancedLocomotion locomotion, Logger log) {
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        NullCheck.check((Object)((Object)agentInfo), (String)"agentInfo");
        this.memory = agentInfo;
        NullCheck.check((Object)((Object)locomotion), (String)"locomotion");
        this.body = new AdvancedLocomotion(bot, log);
        this.senses = new Senses(bot, this.memory, new Players(bot), log);
        this.log = log;
    }
}

