/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.LinkFlag;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloydWarshallMap
extends SensorModule<UT2004Bot> {
    private IWorldEventListener<MapPointListObtained> mapListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            if (FloydWarshallMap.this.log.isLoggable(Level.INFO)) {
                FloydWarshallMap.this.log.info("Map point list obtained.");
            }
            FloydWarshallMap.this.performFloydWarshall(event);
        }
    };
    public static final int BAD_EDGE_FLAG = LinkFlag.FLY.get() | LinkFlag.LADDER.get() | LinkFlag.PROSCRIBED.get() | LinkFlag.SWIM.get() | LinkFlag.PLAYERONLY.get() | LinkFlag.FORCED.get();
    protected int badEdgeFlag = 0;
    protected Map<UnrealId, Integer> navPointIndices;
    protected Map<Integer, NavPoint> indicesNavPoints;
    protected PathMatrixNode[][] pathMatrix;

    public FloydWarshallMap(UT2004Bot bot) {
        this(bot, BAD_EDGE_FLAG, null);
    }

    public FloydWarshallMap(UT2004Bot bot, Logger log) {
        this(bot, BAD_EDGE_FLAG, log);
    }

    public FloydWarshallMap(UT2004Bot bot, int badEdgeFlag, Logger log) {
        super((IObservingAgent)bot, log);
        this.badEdgeFlag = badEdgeFlag;
        this.worldView.addEventListener(MapPointListObtained.class, this.mapListener);
    }

    protected void performFloydWarshall(MapPointListObtained map) {
        List navPoints = MyCollections.asList(map.getNavPoints().values());
        this.performFloydWarshall(navPoints);
    }

    protected void performFloydWarshall(List<NavPoint> navPoints) {
        int i;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine((Object)((Object)this) + ": Beginning Floyd-Warshall algorithm...");
        }
        long start = System.currentTimeMillis();
        int size = navPoints.size();
        this.navPointIndices = new HashMap<UnrealId, Integer>(size);
        this.indicesNavPoints = new HashMap<Integer, NavPoint>(size);
        this.pathMatrix = new PathMatrixNode[size][size];
        for (i = 0; i < navPoints.size(); ++i) {
            this.navPointIndices.put(navPoints.get(i).getId(), i);
            this.indicesNavPoints.put(i, navPoints.get(i));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0.0f : Float.POSITIVE_INFINITY);
            }
        }
        for (i = 0; i < size; ++i) {
            Point3d location = navPoints.get(i).getLocation().getPoint3d();
            for (NavPointNeighbourLink link : navPoints.get(i).getOutgoingEdges().values()) {
                if (!this.checkLink(link)) continue;
                this.pathMatrix[i][this.navPointIndices.get(link.getToNavPoint().getId())].setDistance((float)location.distance(link.getToNavPoint().getLocation().getPoint3d()));
            }
        }
        for (int k = 0; k < size; ++k) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < size; ++j) {
                    float newLen = this.pathMatrix[i2][k].getDistance() + this.pathMatrix[k][j].getDistance();
                    if (!(this.pathMatrix[i2][j].getDistance() > newLen)) continue;
                    this.pathMatrix[i2][j].setDistance(newLen);
                    this.pathMatrix[i2][j].setViaNode(k);
                }
            }
        }
        int count = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            for (int j = 0; j < size; ++j) {
                if (this.pathMatrix[i3][j].getDistance() == Float.POSITIVE_INFINITY) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Unreachable path from " + navPoints.get(i3).getId().getStringId() + " -> " + navPoints.get(j).getId().getStringId());
                    }
                    ++count;
                    continue;
                }
                this.pathMatrix[i3][j].setPath(this.retrievePath(i3, j));
            }
        }
        if (count > 0 && this.log.isLoggable(Level.WARNING)) {
            this.log.warning((Object)((Object)this) + ": There are " + count + " unreachable nav point pairs.");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info((Object)((Object)this) + ": computation for " + size + " navpoints took " + (System.currentTimeMillis() - start) + " millis");
        }
        this.indicesNavPoints = null;
    }

    public boolean checkLink(NavPointNeighbourLink edge) {
        if ((edge.getFlags() & this.badEdgeFlag) != 0) {
            return false;
        }
        if ((edge.getFlags() & LinkFlag.SPECIAL.get()) != 0) {
            return true;
        }
        if (edge.getFromNavPoint().getLocation().getPoint3d().distance(edge.getToNavPoint().getLocation().getPoint3d()) < edge.getToNavPoint().getLocation().z - edge.getFromNavPoint().getLocation().z && edge.getFromNavPoint().getLocation().getPoint3d().distance(edge.getToNavPoint().getLocation().getPoint3d()) > 100.0) {
            return false;
        }
        return (edge.getFlags() & LinkFlag.JUMP.get()) == 0 || !(edge.getToNavPoint().getLocation().z - edge.getFromNavPoint().getLocation().z > 80.0);
    }

    private List<NavPoint> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode node = this.pathMatrix[from][to];
        if (node.getDistance() == Float.POSITIVE_INFINITY) {
            return null;
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.indicesNavPoints.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    private List<NavPoint> retrievePath(Integer from, Integer to) {
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.add(this.indicesNavPoints.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.indicesNavPoints.get(to));
        return path;
    }

    protected PathMatrixNode getPathMatrixNode(NavPoint np1, NavPoint np2) {
        return this.pathMatrix[this.navPointIndices.get(np1.getId())][this.navPointIndices.get(np2.getId())];
    }

    public boolean reachable(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return false;
        }
        return this.getPathMatrixNode(from, to).getDistance() != Float.POSITIVE_INFINITY;
    }

    public float getDistance(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return Float.POSITIVE_INFINITY;
        }
        return this.getPathMatrixNode(from, to).getDistance();
    }

    public List<NavPoint> getPath(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return null;
        }
        return this.getPathMatrixNode(from, to).getPath();
    }

    public String toString() {
        return "FloydWarshallMap";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathMatrixNode {
        private float distance = Float.POSITIVE_INFINITY;
        private Integer viaNode = null;
        private List<NavPoint> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<NavPoint> getPath() {
            return this.path;
        }

        public void setPath(List<NavPoint> path) {
            this.path = path;
        }
    }
}

