/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.aware;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMap<KEY extends ILocated, DATA> {
    private List<Pair<KEY, DATA>> locations = new ArrayList<Pair<KEY, DATA>>();

    public void put(KEY location, DATA data) {
        NullCheck.check(location, (String)"location");
        this.locations.add(new Pair<KEY, DATA>(location, data));
    }

    public int getSize() {
        return this.locations.size();
    }

    public Pair<KEY, DATA> get(int index) {
        return this.locations.get(index);
    }

    public void put(int index, KEY location, DATA data) {
        this.locations.add(index, new Pair<KEY, DATA>(location, data));
    }

    public void putSortZ(KEY location, DATA data) {
        for (int i = 0; i < this.locations.size(); ++i) {
            if (!(this.locations.get((int)i).getLocation().getLocation().z < location.getLocation().z)) continue;
            this.put(i, location, data);
            return;
        }
        this.put(location, data);
    }

    public List<Pair<KEY, DATA>> getLocation(KEY location, double epsilon) {
        NullCheck.check(location, (String)"location");
        ArrayList<Pair<KEY, DATA>> result = new ArrayList<Pair<KEY, DATA>>();
        for (Pair<KEY, DATA> pair : this.locations) {
            if (!(pair.getLocation().getLocation().getDistance(location.getLocation()) < epsilon)) continue;
            result.add(pair);
        }
        return result;
    }

    public List<Pair<KEY, DATA>> remove(KEY location, double epsilon) {
        NullCheck.check(location, (String)"location");
        ArrayList<Pair<KEY, DATA>> result = new ArrayList<Pair<KEY, DATA>>();
        Iterator<Pair<KEY, DATA>> iter = this.locations.iterator();
        while (iter.hasNext()) {
            Pair<KEY, DATA> pair = iter.next();
            if (pair.getLocation().getLocation().getDistance(location.getLocation()) < epsilon) {
                result.add(pair);
                iter.remove();
                continue;
            }
            iter.next();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<KEY extends ILocated, DATA> {
        private KEY location;
        private DATA data;

        public Pair(KEY location, DATA data) {
            this.location = location;
            this.data = data;
        }

        public DATA getData() {
            return this.data;
        }

        public void setData(DATA data) {
            this.data = data;
        }

        public KEY getLocation() {
            return this.location;
        }
    }
}

