/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MutatorListObtained;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
extends SensorModule<UT2004Bot> {
    GameInfo lastGameInfo = null;
    InitedMessage lastInitedMessage = null;
    BeginMessage lastBeginMessage = null;
    MutatorListObtained lastMutatorListObtained = null;
    Map<Integer, FlagInfo> allCTFFlags = new HashMap<Integer, FlagInfo>();
    GameInfoListener gameInfoListener = new GameInfoListener(this.worldView);
    InitedMessageListener initedMessageListener;
    BeginMessageListener beginMessageListener = new BeginMessageListener(this.worldView);
    MutatorListObtainedListener mutatorListObtainedListener;
    FlagInfoObjectListener flagInfoObjectListener;

    public GameType getGameType() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return GameType.getType(this.lastGameInfo.getGametype());
    }

    public String getMapName() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getLevel();
    }

    public double getTime() {
        if (this.lastBeginMessage == null) {
            return 0.0;
        }
        return this.lastBeginMessage.getTime();
    }

    public Double getTimeLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getTimeLimit();
    }

    public Double getRemainingTime() {
        if (this.getTimeLimit() == null) {
            return null;
        }
        return this.getTimeLimit() - this.getTime();
    }

    public Integer getFragLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getFragLimit();
    }

    public Integer getTeamScoreLimit() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return (int)this.lastGameInfo.getGoalTeamScore();
    }

    public Integer getMaxTeams() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getMaxTeams();
    }

    public Integer getMaxTeamSize() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.getMaxTeamSize();
    }

    public Integer getStartHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthStart();
    }

    public Integer getFullHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthFull();
    }

    public Integer getMaxHealth() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getHealthMax();
    }

    public Integer getMaxArmor() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getShieldStrengthMax();
    }

    public int getMaxLowArmor() {
        return 50;
    }

    public int getMaxHighArmor() {
        return 100;
    }

    public Integer getStartAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineStart();
    }

    public Integer getTargetAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public Integer getMaxAdrenaline() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public Boolean getWeaponsStay() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isWeaponStay();
    }

    public Integer getMaxMultiJump() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getMaxMultiJump();
    }

    public List<Mutator> getMutators() {
        if (this.lastMutatorListObtained == null) {
            return null;
        }
        return this.lastMutatorListObtained.getMutators();
    }

    public Boolean isPaused() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isGamePaused();
    }

    public Boolean isBotsPaused() {
        if (this.lastGameInfo == null) {
            return null;
        }
        return this.lastGameInfo.isBotsPaused();
    }

    public Map<Integer, FlagInfo> getAllCTFFlags() {
        return this.allCTFFlags;
    }

    public Collection<FlagInfo> getAllCTFFlagsCollection() {
        return this.allCTFFlags.values();
    }

    public Game(UT2004Bot bot) {
        this(bot, null);
    }

    public Game(UT2004Bot bot, Logger log) {
        super((IObservingAgent)bot, log);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.mutatorListObtainedListener = new MutatorListObtainedListener(this.worldView);
        this.flagInfoObjectListener = new FlagInfoObjectListener(this.worldView);
    }

    protected void start() {
        super.start();
        this.lastGameInfo = null;
        this.lastInitedMessage = null;
        this.lastBeginMessage = null;
        this.lastMutatorListObtained = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlagInfoObjectListener
    implements IWorldObjectEventListener<FlagInfo, WorldObjectFirstEncounteredEvent<FlagInfo>> {
        public void notify(WorldObjectFirstEncounteredEvent<FlagInfo> event) {
            if (Game.this.allCTFFlags.containsKey(((FlagInfo)event.getObject()).getTeam()) && Game.this.log.isLoggable(Level.WARNING)) {
                Game.this.log.warning("Saving second Flag for team: " + ((FlagInfo)event.getObject()).getTeam() + ". Bug?");
            }
            Game.this.allCTFFlags.put(((FlagInfo)event.getObject()).getTeam(), (FlagInfo)event.getObject());
        }

        public FlagInfoObjectListener(IWorldView worldView) {
            worldView.addObjectListener(FlagInfo.class, WorldObjectFirstEncounteredEvent.class, (IWorldObjectEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MutatorListObtainedListener
    implements IWorldEventListener<MutatorListObtained> {
        public void notify(MutatorListObtained event) {
            Game.this.lastMutatorListObtained = event;
        }

        public MutatorListObtainedListener(IWorldView worldView) {
            worldView.addEventListener(MutatorListObtained.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public void notify(BeginMessage event) {
            Game.this.lastBeginMessage = event;
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            Game.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GameInfoListener
    implements IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> {
        public void notify(IWorldObjectEvent<GameInfo> event) {
            Game.this.lastGameInfo = (GameInfo)event.getObject();
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addObjectListener(GameInfo.class, (IWorldObjectEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameType {
        BotDeathMatch,
        BotTeamGame,
        BotCTFGame,
        BotBombingRun,
        BotDoubleDomination,
        Unknown;


        public static GameType getType(String type) {
            if (type.equalsIgnoreCase("BotDeathMatch")) {
                return BotDeathMatch;
            }
            if (type.equalsIgnoreCase("BotTeamGame")) {
                return BotTeamGame;
            }
            if (type.equalsIgnoreCase("BotCTFGame")) {
                return BotCTFGame;
            }
            if (type.equalsIgnoreCase("BotBombingRun")) {
                return BotBombingRun;
            }
            if (type.equalsIgnoreCase("BotDoubleDomination")) {
                return BotDoubleDomination;
            }
            return Unknown;
        }
    }
}

