/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectFuture;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.utils.flag.Flag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raycasting
extends SensomotoricModule<UT2004Bot> {
    Map<String, WorldObjectFuture<AutoTraceRay>> rayFutures = new HashMap<String, WorldObjectFuture<AutoTraceRay>>();
    String idSuffix = null;
    int counter = 0;
    int alreadyInitialized = 0;
    Flag<Boolean> allRaysInitialized = new Flag((Object)false);
    boolean listening = false;

    public Flag<Boolean> getAllRaysInitialized() {
        return this.allRaysInitialized.getImmutable();
    }

    public Raycasting(UT2004Bot bot) {
        this(bot, null);
    }

    public Raycasting(UT2004Bot bot, Logger log) {
        super((IEmbodiedAgent)bot, log);
        this.idSuffix = "_" + bot.getName() + UUID.randomUUID().toString();
    }

    protected void start() {
        super.start();
        this.clearDataStructures();
    }

    private void clearDataStructures() {
        for (WorldObjectFuture<AutoTraceRay> future : this.rayFutures.values()) {
            future.cancel(false);
        }
        this.rayFutures.clear();
        this.allRaysInitialized.setFlag((Object)false);
        this.alreadyInitialized = 0;
        this.listening = false;
    }

    public void clear() throws CommunicationException {
        this.act.act((CommandMessage)new RemoveRay("All"));
        this.clearDataStructures();
    }

    public void endRayInitSequence() {
        this.listening = true;
        this.checkIfAllInited();
    }

    public Future<AutoTraceRay> createRay(String Id, Vector3d Direction, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        AddRay addRay = new AddRay(Id, Direction, Length, FastTrace2, FloorCorrection, TraceActors);
        WorldObjectFuture<AutoTraceRay> future = new WorldObjectFuture<AutoTraceRay>(this.worldView, Id, AutoTraceRay.class){

            protected void customObjectEncounteredHook(AutoTraceRay obj) {
                ++Raycasting.this.alreadyInitialized;
                Raycasting.this.checkIfAllInited();
            }
        };
        this.rayFutures.put(Id, future);
        this.act.act((CommandMessage)addRay);
        return future;
    }

    public Future<AutoTraceRay> createRay(Vector3d Direction, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        String id = this.counter++ + this.idSuffix;
        return this.createRay(id, Direction, Length, FastTrace2, FloorCorrection, TraceActors);
    }

    public AutoTraceRay getRay(String rayID) {
        try {
            Future ray = (Future)this.rayFutures.get(rayID);
            if (ray == null) {
                return null;
            }
            if (ray.isDone()) {
                return (AutoTraceRay)ray.get();
            }
            return null;
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ex.getMessage());
            }
            return null;
        }
    }

    protected void checkIfAllInited() {
        if (this.listening && this.rayFutures.size() == this.alreadyInitialized) {
            this.allRaysInitialized.setFlag((Object)true);
        }
    }
}

