/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.token;

import cz.cuni.amis.utils.token.Token;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Tokens {
    private static volatile long[] lastIds = new long[0];
    private static Map<String, WeakReference<Token>> tokenMap = new HashMap<String, WeakReference<Token>>();
    public static final Token NULL_TOKEN = Tokens.get("null");

    static void restart() {
        lastIds = new long[0];
        tokenMap = new HashMap<String, WeakReference<Token>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token get(String tokenStr) {
        if (tokenStr == null) {
            return NULL_TOKEN;
        }
        WeakReference<Token> refToken = tokenMap.get(tokenStr);
        Token token = null;
        if (refToken != null) {
            token = (Token)refToken.get();
        }
        if (token == null) {
            Map<String, WeakReference<Token>> map = tokenMap;
            synchronized (map) {
                refToken = tokenMap.get(tokenStr);
                if (refToken != null) {
                    token = (Token)refToken.get();
                }
                if (token != null) {
                    return token;
                }
                token = Tokens.newToken(tokenStr);
                tokenMap.put(tokenStr, new WeakReference<Token>(token));
            }
        }
        return token;
    }

    public static synchronized Token get(long id) {
        return Tokens.get(String.valueOf(id));
    }

    private static Token newToken(String tokenStr) {
        return new Token(tokenStr, Tokens.nextLastIds());
    }

    private static long[] nextLastIds() {
        for (int i = 0; i < lastIds.length; ++i) {
            if (lastIds[i] == Long.MAX_VALUE) {
                Tokens.lastIds[i] = Long.MIN_VALUE;
                break;
            }
            if (lastIds[i] != -1L) {
                int n = i;
                lastIds[n] = lastIds[n] + 1L;
                return lastIds;
            }
            Tokens.lastIds[i] = 0L;
        }
        lastIds = new long[lastIds.length + 1];
        Arrays.fill(lastIds, 0L);
        return lastIds;
    }
}

