/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.token;

import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Token
implements IToken,
Serializable {
    private String name;
    private transient long[] ids;
    private transient int hashCode;
    private transient String nameWithIds = null;

    Token(String name, long[] ids) {
        this.name = name;
        this.ids = ids;
        HashCode hc = new HashCode();
        hc.add(ids.length);
        for (long id : ids) {
            hc.add(id);
        }
        this.hashCode = hc.getHash();
    }

    private void readObject(ObjectInputStream ois) {
        try {
            ois.defaultReadObject();
        }
        catch (IOException e) {
            throw new PogamutException("Could not deserialize Token", e);
        }
        catch (ClassNotFoundException e) {
            throw new PogamutException("Could not deserialize Token", e);
        }
        Token trueToken = Tokens.get(this.name);
        this.ids = trueToken.ids;
        this.hashCode = trueToken.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hashCode != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        Token token = (Token)obj;
        if (this.ids.length != token.ids.length) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] == token.ids[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getToken() {
        return this.name;
    }

    @Override
    public long[] getIds() {
        return this.ids;
    }

    public String getNameWithIds() {
        if (this.nameWithIds != null) {
            return this.nameWithIds;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("[");
        sb.append(this.ids[0]);
        for (int i = 1; i < this.ids.length; ++i) {
            sb.append(",");
            sb.append(this.ids[i]);
        }
        sb.append("]");
        this.nameWithIds = sb.toString();
        return this.nameWithIds;
    }

    public String toString() {
        return this.getNameWithIds();
    }
}

