/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.sets;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<K>
implements Set<K> {
    private ConcurrentHashMap<K, K> map = new ConcurrentHashMap();

    @Override
    public boolean add(K e) {
        boolean contains = this.map.containsKey(e);
        this.map.put(e, e);
        return !contains;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean changed = false;
        for (K element : c) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed = this.remove(o) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.clear();
        for (Object element : c) {
            this.add((K)element);
        }
        return true;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }
}

