/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.configuration;

import cz.cuni.amis.utils.configuration.PropertyProvider;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesManager {
    Logger log = Logger.getLogger("Properties logger");
    private List<PropertyProvider> providers = null;

    protected List<PropertyProvider> getProvidersList() {
        if (this.providers == null) {
            this.providers = new LinkedList<PropertyProvider>();
            ServiceLoader<PropertyProvider> loader = ServiceLoader.load(PropertyProvider.class);
            for (PropertyProvider provider : loader) {
                this.providers.add(provider);
            }
            Collections.sort(this.providers);
            this.logProvidersOrder();
        }
        return this.providers;
    }

    protected void logProvidersOrder() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Property providers order:");
        }
        for (PropertyProvider provider : this.getProvidersList()) {
            String str = "[" + provider.getPriority() + "] \t " + provider.toString();
            if (!this.log.isLoggable(Level.INFO)) continue;
            this.log.info(str);
        }
    }

    public String getProperty(String key) {
        for (PropertyProvider provider : this.getProvidersList()) {
            String val = provider.getProperty(key);
            if (val == null) continue;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Property " + key + " was loaded from " + provider.toString() + ".");
            }
            return val;
        }
        return null;
    }
}

