/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class NetworkLogManager {
    private static final int MAXIMUM_AGENTS_LOGGED = 100;
    private static final int MAXIMUM_CLIENTS_PER_AGENT = 100;
    private static final int MAXIMUM_LOGS_PER_AGENT = 100;
    private LogCategory log;
    private LinkedBlockingQueue<IAgentId> agentsLogged = new LinkedBlockingQueue(100);
    private HashMap<IAgentId, LinkedBlockingQueue<Socket>> idToSocketList = new HashMap();
    private HashMap<IAgentId, LinkedBlockingQueue<NetworkLogEnvelope>> idToEnvelopeList = new HashMap();
    private ServerSocket serverSocket;
    private static NetworkLogManager manager = null;
    private Socket client;
    protected Worker worker = null;
    protected Thread workerThread = null;

    private NetworkLogManager() {
        this.log = new LogCategory("NetworkLogManager");
        this.log.setLevel(Level.parse(Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_NETWORK_LOG_MANAGER_LEVEL.getKey())));
        this.log.addConsoleHandler();
        this.log.info("Instantiating the singleton.");
        System.out.println("Instantiating the singleton.");
        try {
            this.serverSocket = new ServerSocket(12345);
            this.serverSocket.setSoTimeout(100);
        }
        catch (IOException ex) {
            System.out.println("IOException at NetworkLogManager constructor.");
        }
    }

    public synchronized int getLoggerPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return new Integer(null);
    }

    public static synchronized NetworkLogManager getNetworkLogManager() {
        if (manager == null) {
            manager = new NetworkLogManager();
            System.out.println("Returning new manager");
            manager.runNetworkLogManager();
        }
        return manager;
    }

    protected synchronized void addAgent(IAgentId agent) {
        this.log.fine(agent.toString() + " added");
        if (this.idToEnvelopeList.get(agent) != null) {
            return;
        }
        if (this.idToEnvelopeList.get(agent) == null) {
            this.idToEnvelopeList.put(agent, new LinkedBlockingQueue(100));
        }
    }

    public synchronized void removeAgent(IAgentId agent) {
        if (this.agentsLogged.contains(agent)) {
            this.agentsLogged.remove(agent);
            this.idToEnvelopeList.remove(agent);
            for (Socket soc : this.idToSocketList.get(agent)) {
                try {
                    soc.close();
                }
                catch (IOException ex) {
                    this.log.severe(ex.toString());
                }
            }
            this.idToSocketList.remove(agent);
        }
    }

    public synchronized void processLog(NetworkLogEnvelope record, IAgentId agent) {
        LinkedBlockingQueue<NetworkLogEnvelope> ll = this.idToEnvelopeList.get(agent);
        if (ll != null) {
            this.log.fine("log processed");
            try {
                ll.add(record);
            }
            catch (IllegalStateException e) {
                this.log.warning("queue full");
                ll.remove();
                ll.add(record);
            }
            this.idToEnvelopeList.put(agent, ll);
        }
    }

    private synchronized void registerSocket(Socket socket, IAgentId agent) {
        this.log.fine(agent.toString());
        if (this.agentsLogged.contains(agent)) {
            this.log.fine("Agent already logged");
            this.idToSocketList.get(agent).add(socket);
        } else {
            this.log.fine("Agent will be logged.");
            this.agentsLogged.add(agent);
            LinkedBlockingQueue<Socket> ll = new LinkedBlockingQueue<Socket>(100);
            ll.add(socket);
            this.idToSocketList.put(agent, ll);
        }
        this.log.fine("Socket succesfully registered. There are " + this.agentsLogged.size() + " agents logged.");
    }

    private synchronized void runNetworkLogManager() {
        this.worker = new Worker();
        this.workerThread = new Thread(this.worker);
        this.workerThread.start();
    }

    public synchronized void shutdown() {
        this.stopSendingLogs();
        this.idToEnvelopeList = null;
        for (IAgentId id : this.agentsLogged) {
            for (Socket soc : this.idToSocketList.get(id)) {
                try {
                    soc.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.agentsLogged = null;
        this.idToSocketList = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.serverSocket = null;
        manager = null;
        this.log.severe("Manager stopped");
        this.log = null;
    }

    public void killSendingLogs() {
        Thread thread;
        Worker w = this.worker;
        if (w != null) {
            w.kill();
        }
        if ((thread = this.workerThread) != null) {
            thread.interrupt();
        }
        this.worker = null;
        this.workerThread = null;
    }

    public void pauseSendingLogs() {
        Worker w = this.worker;
        if (w != null) {
            w.pause();
        }
    }

    public void resumeSendingLogs() {
        Worker w = this.worker;
        if (w != null) {
            w.resume();
        }
    }

    public void stopSendingLogs() throws PogamutException {
        Worker w = this.worker;
        if (w != null) {
            w.stop();
        }
    }

    private class Worker
    implements Runnable {
        private volatile CountDownLatch stopLatch = new CountDownLatch(1);
        private volatile boolean shouldRun = true;
        private volatile Flag<Boolean> shouldPause = new Flag<Boolean>(false);
        private volatile boolean running = false;
        private volatile boolean exceptionExpected = false;
        private Thread myThread;

        private Worker() {
        }

        public void pause() {
            this.shouldPause.setFlag(true);
        }

        public void resume() {
            this.shouldPause.setFlag(false);
        }

        public void stop() {
            this.shouldRun = false;
            this.shouldPause.setFlag(false);
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        public void kill() {
            if (!this.running) {
                return;
            }
            this.shouldRun = false;
            this.shouldPause.setFlag(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            this.running = true;
            NetworkLogManager.this.log.log(Level.INFO, "Worker Started.");
            try {
                while (this.shouldRun && !this.myThread.isInterrupted()) {
                    if (this.shouldPause.getFlag().booleanValue()) {
                        NetworkLogManager.this.log.log(Level.INFO, "Worker Paused.");
                        this.shouldPause.waitFor((Boolean[])new Boolean[]{false});
                        NetworkLogManager.this.log.log(Level.INFO, "Worker Resumed.");
                    }
                    if (!this.shouldRun || this.myThread.isInterrupted()) break;
                    do {
                        try {
                            NetworkLogManager.this.client = NetworkLogManager.this.serverSocket.accept();
                            if (NetworkLogManager.this.client != null) {
                                IAgentId agent = (IAgentId)new ObjectInputStream(NetworkLogManager.this.client.getInputStream()).readObject();
                                NetworkLogManager.this.registerSocket(NetworkLogManager.this.client, agent);
                            }
                        }
                        catch (SocketTimeoutException e) {
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        NetworkLogManager.this.log.finer("sending logs");
                        for (IAgentId t : NetworkLogManager.this.agentsLogged) {
                            for (Socket soc : (LinkedBlockingQueue)NetworkLogManager.this.idToSocketList.get(t)) {
                                try {
                                    new ObjectOutputStream(soc.getOutputStream()).writeObject(NetworkLogManager.this.idToEnvelopeList.get(t));
                                }
                                catch (IOException ex) {
                                    System.out.println("IO problem in runNetworkLogManager");
                                }
                            }
                            NetworkLogManager.this.idToEnvelopeList.remove(t);
                            NetworkLogManager.this.idToEnvelopeList.put(t, new LinkedBlockingQueue(100));
                        }
                    } while (this.shouldRun && !this.myThread.isInterrupted());
                }
            }
            catch (Exception e) {
                this.running = false;
                if (!this.exceptionExpected) {
                    NetworkLogManager.this.log.severe("Exception at Worker.", e);
                }
                NetworkLogManager.this.log.fine("Exception expected, caught: " + e);
            }
            try {
                this.stopLatch.countDown();
            }
            finally {
                this.shouldRun = false;
                this.running = false;
                Worker worker = this;
                synchronized (worker) {
                    if (NetworkLogManager.this.workerThread == this.myThread) {
                        NetworkLogManager.this.worker = null;
                        NetworkLogManager.this.workerThread = null;
                    }
                }
                NetworkLogManager.this.log.warning("Worker Stopped.");
            }
        }
    }
}

