/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AbstractAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.utils.ExceptionToString;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@AgentScoped
public class AgentLogger
extends AbstractAgentLogger {
    private ILogCategories categories = new LogCategories();

    @Inject
    public AgentLogger(IAgentId agentId) {
        super(agentId);
        Level logLevel;
        String level = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_LOGGER_LEVEL_DEFAULT.getKey());
        if (level == null) {
            System.err.println("No default level for AgentLogger is specified! Setting WARNING.");
            logLevel = Level.WARNING;
        } else {
            try {
                logLevel = Level.parse(level);
            }
            catch (Exception e) {
                System.err.println("Default AgentLogger level is malformed, could not par log level from: " + level);
                System.err.println("Setting log level to WARNING.");
                logLevel = Level.WARNING;
            }
        }
        if (logLevel != null) {
            this.setLevel(logLevel);
        } else {
            this.setLevel(Level.WARNING);
        }
    }

    @Override
    public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
        if (this.getCategories() instanceof JMXLogCategories) {
            throw new JMXAlreadyEnabledException("AgentLogger has already JMX turned on.", (Object)this);
        }
        try {
            this.categories = new JMXLogCategories(this.getLogCategories(), mBeanServer, parent);
        }
        catch (Exception e) {
            throw new CantStartJMXException(ExceptionToString.process("Can't start JMX for agent logger", e), (Object)this);
        }
    }

    @Override
    protected ILogCategories getLogCategories() {
        return this.categories;
    }
}

