/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogPublisher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;

@AgentScoped
public abstract class AbstractAgentLogger
implements IAgentLogger {
    public static final String LOG_CATEGORY_NAME = "AgentLogger";
    protected IAgentId agentId;
    private List<Handler> defaultHandlers = new ArrayList<Handler>(4);
    private Level globalLevel = Level.INFO;
    private Handler consoleHandler = null;
    private Handler networkHandler = null;

    @Inject
    public AbstractAgentLogger(IAgentId agentName) {
        this.agentId = agentName;
    }

    @Override
    public IAgentId getAgentId() {
        return this.agentId;
    }

    @Override
    public Integer getNetworkLoggerPort() {
        return NetworkLogManager.getNetworkLogManager().getLoggerPort();
    }

    @Override
    public Map<String, LogCategory> getCategories() {
        return this.getLogCategories().getCategories();
    }

    protected abstract ILogCategories getLogCategories();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogCategory getCategory(String name) {
        if (this.getLogCategories().hasCategory(name)) {
            return this.getLogCategories().getCategory(name);
        }
        LogCategory category = this.getLogCategories().getCategory(name);
        List<Handler> list = this.defaultHandlers;
        synchronized (list) {
            for (Handler handler : this.defaultHandlers) {
                category.addHandler(handler);
            }
        }
        category.setLevel(this.globalLevel);
        return category;
    }

    @Override
    public LogCategory getCategory(IComponent component) {
        return this.getCategory(component.getComponentId().getToken());
    }

    @Override
    public void setLevel(Level newLevel) {
        this.globalLevel = newLevel;
        this.getLogCategories().setLevel(newLevel);
    }

    @Override
    public synchronized Handler addDefaultConsoleHandler() {
        if (this.consoleHandler != null) {
            return this.consoleHandler;
        }
        this.consoleHandler = this.addDefaultPublisher(new LogPublisher.ConsolePublisher(this.getAgentId()));
        return this.consoleHandler;
    }

    @Override
    public synchronized void removeDefaultConsoleHandler() {
        if (this.consoleHandler == null) {
            return;
        }
        this.removeDefaultHandler(this.consoleHandler);
        this.consoleHandler = null;
    }

    @Override
    public boolean isDefaultConsoleHandler() {
        return this.consoleHandler != null;
    }

    @Override
    public synchronized Handler addDefaultNetworkHandler() {
        if (this.networkHandler != null) {
            return this.networkHandler;
        }
        this.networkHandler = this.addDefaultPublisher(new NetworkLogPublisher(this.getAgentId()));
        return this.networkHandler;
    }

    @Override
    public synchronized void removeDefaultNetworkHandler() {
        if (this.networkHandler == null) {
            return;
        }
        this.removeDefaultHandler(this.networkHandler);
        this.networkHandler = null;
        NetworkLogManager.getNetworkLogManager().removeAgent(this.getAgentId());
    }

    @Override
    public boolean isDefaultNetworkHandler() {
        return this.networkHandler != null;
    }

    @Override
    public Handler addDefaultFileHandler(File file) {
        return this.addDefaultPublisher(new LogPublisher.FilePublisher(file, new LogFormatter(this.getAgentId(), true)));
    }

    @Override
    public Handler addDefaultPublisher(ILogPublisher publisher) {
        LogHandler defaultHandler = new LogHandler(publisher);
        this.addDefaultHandler(defaultHandler);
        return defaultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefaultHandler(Handler handler) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            List<Handler> list = this.defaultHandlers;
            synchronized (list) {
                this.defaultHandlers.add(handler);
            }
            this.addToAllCategories(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefaultHandler(Handler handler) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            List<Handler> list = this.defaultHandlers;
            synchronized (list) {
                if (!this.defaultHandlers.remove(handler)) {
                    return;
                }
            }
            this.removeFromAllCategories(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToAllCategories(ILogPublisher logPublisher) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            for (LogCategory category : this.getCategories().values()) {
                category.addHandler(logPublisher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToAllCategories(Handler handler) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            for (LogCategory category : this.getCategories().values()) {
                category.addHandler(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromAllCategories(Handler handler) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            for (LogCategory category : this.getCategories().values()) {
                category.removeHandler(handler);
            }
        }
    }
}

