/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.factory.guice;

import com.google.inject.AbstractModule;
import cz.cuni.amis.pogamut.base.agent.params.IRemoteAgentParameters;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.command.impl.Act;
import cz.cuni.amis.pogamut.base.communication.command.impl.StringCommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldReaderProvider;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldWriterProvider;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceCommunicationModule;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.utils.NullCheck;

public abstract class GuiceRemoteAgentModule<PARAMS extends IRemoteAgentParameters>
extends GuiceCommunicationModule<PARAMS> {
    private AdaptableProvider<IWorldConnectionAddress> addressProvider = new AdaptableProvider<Object>(null);

    protected AdaptableProvider getAddressProvider() {
        return this.addressProvider;
    }

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        NullCheck.check(agentParameters.getWorldAddress(), "agentParameters.getWorldAddress()");
        this.addressProvider.set(agentParameters.getWorldAddress());
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            protected void configure() {
                this.bind(ICommandSerializer.class).to(StringCommandSerializer.class);
                this.bind(IAct.class).to(Act.class);
                this.bind(IWorldReaderProvider.class).to(IWorldConnection.class);
                this.bind(IWorldWriterProvider.class).to(IWorldConnection.class);
            }
        });
    }
}

