/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus.event;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppingEvent;

public class ComponentBusEvents {
    protected IComponentBus bus;
    protected IComponent component;

    public ComponentBusEvents(IComponentBus bus, IComponent component) {
        this.bus = bus;
        this.component = component;
    }

    public boolean starting() {
        return this.bus.event(new StartingEvent<IComponent>(this.component));
    }

    public boolean starting(String message) {
        return this.bus.event(new StartingEvent<IComponent>(this.component, message));
    }

    public boolean started() {
        return this.bus.event(new StartedEvent<IComponent>(this.component));
    }

    public boolean started(String message) {
        return this.bus.event(new StartedEvent<IComponent>(this.component, message));
    }

    public boolean pausing() {
        return this.bus.event(new PausingEvent<IComponent>(this.component));
    }

    public boolean pausing(String message) {
        return this.bus.event(new PausingEvent<IComponent>(this.component, message));
    }

    public boolean paused() {
        return this.bus.event(new PausedEvent<IComponent>(this.component));
    }

    public boolean paused(String message) {
        return this.bus.event(new PausedEvent<IComponent>(this.component, message));
    }

    public boolean resuming() {
        return this.bus.event(new ResumingEvent<IComponent>(this.component));
    }

    public boolean resuming(String message) {
        return this.bus.event(new ResumingEvent<IComponent>(this.component, message));
    }

    public boolean resumed() {
        return this.bus.event(new ResumedEvent<IComponent>(this.component));
    }

    public boolean resumed(String message) {
        return this.bus.event(new ResumedEvent<IComponent>(this.component, message));
    }

    public boolean stopping() {
        return this.bus.event(new StoppingEvent<IComponent>(this.component));
    }

    public boolean stopping(String message) {
        return this.bus.event(new StoppingEvent<IComponent>(this.component, message));
    }

    public boolean stopped() {
        return this.bus.event(new StoppedEvent<IComponent>(this.component));
    }

    public boolean stopped(String message) {
        return this.bus.event(new StoppedEvent<IComponent>(this.component, message));
    }

    public boolean fatalError(String message) {
        return this.bus.event(new FatalErrorEvent<IComponent>(this.component, message));
    }

    public boolean fatalError(String message, Throwable cause) {
        return this.bus.event(new FatalErrorEvent<IComponent>(this.component, message, cause));
    }

    public boolean fatalError(Throwable cause) {
        return this.bus.event(new FatalErrorEvent<IComponent>(this.component, cause));
    }

    public void startingTransactional() {
        this.bus.eventTransactional(new StartingEvent<IComponent>(this.component));
    }

    public void startingTransactional(String message) {
        this.bus.eventTransactional(new StartingEvent<IComponent>(this.component, message));
    }

    public void startedTransactional() {
        this.bus.eventTransactional(new StartedEvent<IComponent>(this.component));
    }

    public void startedTransactional(String message) {
        this.bus.eventTransactional(new StartedEvent<IComponent>(this.component, message));
    }

    public void pausingTransactional() {
        this.bus.eventTransactional(new PausingEvent<IComponent>(this.component));
    }

    public void pausingTransactional(String message) {
        this.bus.eventTransactional(new PausingEvent<IComponent>(this.component, message));
    }

    public void pausedTransactional() {
        this.bus.eventTransactional(new PausedEvent<IComponent>(this.component));
    }

    public void pausedTransactional(String message) {
        this.bus.eventTransactional(new PausedEvent<IComponent>(this.component, message));
    }

    public void resumingTransactional() {
        this.bus.eventTransactional(new ResumingEvent<IComponent>(this.component));
    }

    public void resumingTransactional(String message) {
        this.bus.eventTransactional(new ResumingEvent<IComponent>(this.component, message));
    }

    public void resumedTransactional() {
        this.bus.eventTransactional(new ResumedEvent<IComponent>(this.component));
    }

    public void resumedTransactional(String message) {
        this.bus.eventTransactional(new ResumedEvent<IComponent>(this.component, message));
    }

    public void stoppingTransactional() {
        this.bus.eventTransactional(new StoppingEvent<IComponent>(this.component));
    }

    public void stoppingTransactional(String message) {
        this.bus.eventTransactional(new StoppingEvent<IComponent>(this.component, message));
    }

    public void stoppedTransactional() {
        this.bus.eventTransactional(new StoppedEvent<IComponent>(this.component));
    }

    public void stoppedTransactional(String message) {
        this.bus.eventTransactional(new StoppedEvent<IComponent>(this.component, message));
    }
}

