/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.parser.impl.yylex;

import com.google.inject.Inject;
import com.google.inject.internal.Nullable;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldReaderProvider;
import cz.cuni.amis.pogamut.base.communication.connection.WorldReader;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.parser.exception.ParserException;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylex;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylexObserver;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Reader;
import java.util.logging.Logger;

@AgentScoped
public class YylexParser
implements IWorldMessageParser {
    public static final Token COMPONENT_ID = Tokens.get("Parser");
    private IWorldReaderProvider readerProvider;
    private Reader reader = null;
    private IYylex yylex;
    private IAgentLogger agentLogger = null;
    private LogCategory log = null;
    private ComponentController controller = null;
    private IComponentBus eventBus;
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void start() throws ParserException {
            WorldReader reader = YylexParser.this.readerProvider.getReader();
            if (reader == null) {
                throw new ParserException("Can't get reader from " + YylexParser.this.readerProvider + ", can't start.", (Logger)YylexParser.this.log, (Object)this);
            }
            YylexParser.this.yylex.setReader(reader);
        }
    };

    @Inject
    public YylexParser(IWorldReaderProvider readerProvider, IYylex yylex, @Nullable IYylexObserver yylexObserver, IComponentBus eventBus, IAgentLogger logger) throws CommunicationException {
        this.agentLogger = logger;
        this.log = this.agentLogger.getCategory(this.getComponentId().getToken());
        this.readerProvider = readerProvider;
        this.yylex = yylex;
        this.yylex.setObserver(yylexObserver == null ? new IYylexObserver.LogObserver(logger) : yylexObserver);
        this.eventBus = eventBus;
        this.controller = new ComponentController(this, this.control, eventBus, this.log, ComponentDependencyType.STARTS_AFTER, readerProvider);
    }

    @Override
    public Token getComponentId() {
        return COMPONENT_ID;
    }

    @Override
    public InfoMessage parse() throws ComponentNotRunningException, ComponentPausedException, ParserException {
        if (this.controller.isPaused()) {
            throw new ComponentPausedException(this.controller.getState().getFlag(), (Object)this);
        }
        if (!this.controller.isRunning()) {
            throw new ComponentNotRunningException(this.controller.getState().getFlag(), (Object)this);
        }
        try {
            InfoMessage parsed = this.yylex.yylex();
            return parsed;
        }
        catch (ComponentPausedException cp) {
            throw cp;
        }
        catch (ComponentNotRunningException cnr) {
            throw cnr;
        }
        catch (ParserException p) {
            throw p;
        }
        catch (Exception e) {
            throw new ParserException("Can't parse next message: " + e.getMessage(), (Throwable)e, this.log, this);
        }
    }

    public String toString() {
        if (this == null) {
            return "YylexParser";
        }
        return this.getClass().getSimpleName();
    }
}

