/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.mediator.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

@AgentScoped
public class Mediator
implements IMediator {
    public static final Token COMPONENT_ID = Tokens.get("Mediator");
    public static final String WORKER_THREAD_NAME_PREFIX = "MediatorWorker";
    protected Worker worker = null;
    protected Thread workerThread = null;
    protected Object threadMutex = new Object();
    private LogCategory log = null;
    private IWorldChangeEventOutput producer;
    private IWorldChangeEventInput consumer;
    private ComponentController controller;
    private IComponentBus eventBus;
    private IAgentId agentId;
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void stop() throws PogamutException {
            Worker w = Mediator.this.worker;
            if (w != null) {
                w.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws PogamutException {
            if (Mediator.this.workerThread != null && Mediator.this.log.isLoggable(Level.WARNING)) {
                Mediator.this.log.warning("Mediator worker thread already exists, leaking resources?");
            }
            Object object = Mediator.this.threadMutex;
            synchronized (object) {
                if (Mediator.this.log.isLoggable(Level.FINER)) {
                    Mediator.this.log.finer("Starting mediator thread MediatorWorker.");
                }
                Mediator.this.worker = new Worker();
                Mediator.this.workerThread = new Thread((Runnable)Mediator.this.worker, Mediator.this.agentId.getName().getFlag() + " mediator");
                Mediator.this.workerThread.start();
            }
        }

        @Override
        public void kill() {
            Thread thread;
            Worker w = Mediator.this.worker;
            if (w != null) {
                w.kill();
            }
            if ((thread = Mediator.this.workerThread) != null) {
                thread.interrupt();
            }
            Mediator.this.worker = null;
            Mediator.this.workerThread = null;
        }

        @Override
        public void pause() {
            Worker w = Mediator.this.worker;
            if (w != null) {
                w.pause();
            }
        }

        @Override
        public void resume() {
            Worker w = Mediator.this.worker;
            if (w != null) {
                w.resume();
            }
        }

        @Override
        public void reset() {
            Mediator.this.worker = null;
            Mediator.this.workerThread = null;
        }
    };

    @Inject
    public Mediator(IWorldChangeEventOutput producer, IComponentBus bus, IAgentLogger logger) {
        this.agentId = logger.getAgentId();
        this.log = logger.getCategory(this.getComponentId().getToken());
        this.producer = producer;
        this.eventBus = bus;
    }

    @Override
    public Token getComponentId() {
        return COMPONENT_ID;
    }

    @Override
    public void setConsumer(IWorldChangeEventInput consumer) {
        this.consumer = consumer;
        this.controller = new ComponentController(this, this.control, this.eventBus, this.log, ComponentDependencyType.STARTS_AFTER, this.producer, consumer);
    }

    public String toString() {
        if (this == null) {
            return "Mediator";
        }
        return this.getClass().getSimpleName() + "[producer=" + this.producer + ", consumer=" + this.consumer + "]";
    }

    private class Worker
    implements Runnable {
        private volatile CountDownLatch stopLatch = new CountDownLatch(1);
        private volatile boolean shouldRun = true;
        private volatile Flag<Boolean> shouldPause = new Flag<Boolean>(false);
        private volatile boolean running = false;
        private volatile boolean exceptionExpected = false;
        private Thread myThread;

        private Worker() {
        }

        public void pause() {
            this.shouldPause.setFlag(true);
        }

        public void resume() {
            this.shouldPause.setFlag(false);
        }

        public void stop() {
            this.shouldRun = false;
            this.shouldPause.setFlag(false);
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        public void kill() {
            if (!this.running) {
                return;
            }
            this.shouldRun = false;
            this.shouldPause.setFlag(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            this.running = true;
            this.logWorker(Level.INFO, "Started.");
            try {
                IWorldChangeEvent worldEvent = null;
                while (this.shouldRun && !this.myThread.isInterrupted()) {
                    if (this.shouldPause.getFlag().booleanValue()) {
                        this.logWorker(Level.INFO, "Paused.");
                        this.shouldPause.waitFor((Boolean[])new Boolean[]{false});
                        this.logWorker(Level.INFO, "Resumed.");
                    }
                    if (!this.shouldRun || this.myThread.isInterrupted()) break;
                    IWorldChangeEventInput currentConsumer = Mediator.this.consumer;
                    if (currentConsumer == null) {
                        this.running = false;
                        if (!this.exceptionExpected) {
                            Mediator.this.controller.fatalError("Event consumer lost (is null).");
                        }
                        break;
                    }
                    IWorldChangeEventOutput currentProducer = Mediator.this.producer;
                    if (currentProducer == null) {
                        this.running = false;
                        if (!this.exceptionExpected) {
                            Mediator.this.controller.fatalError("Event producer lost (is null).");
                        }
                        break;
                    }
                    if (worldEvent == null) {
                        try {
                            worldEvent = Mediator.this.producer.getEvent();
                            this.logWorker(Level.FINEST, "received - " + String.valueOf(worldEvent), worldEvent);
                        }
                        catch (ComponentPausedException cpe) {
                            this.logWorker(Level.INFO, "Producer is paused, pausing mediator.");
                            this.shouldPause.setFlag(true);
                            continue;
                        }
                        catch (ComponentNotRunningException nre) {
                            this.logWorker(Level.WARNING, "Producer is not running, stopping the mediator worker.");
                            this.running = false;
                            break;
                        }
                        catch (Exception ce) {
                            this.running = false;
                            if (!this.exceptionExpected) {
                                Mediator.this.controller.fatalError("MediatorWorker: Producer exception.", ce);
                            } else {
                                this.logWorker(Level.FINE, "Producer exception expected, caught: " + ce);
                            }
                            break;
                        }
                    }
                    if (!this.shouldRun || this.myThread.isInterrupted()) break;
                    try {
                        currentConsumer.notify(worldEvent);
                    }
                    catch (ComponentPausedException e) {
                        this.logWorker(Level.INFO, "Consumer is paused, pausing mediator.");
                        this.shouldPause.setFlag(true);
                        continue;
                    }
                    catch (ComponentNotRunningException e) {
                        this.logWorker(Level.WARNING, "Consumer is not running, stopping mediator worker.");
                        this.running = false;
                        break;
                    }
                    catch (Exception e) {
                        this.running = false;
                        if (!this.exceptionExpected) {
                            Mediator.this.controller.fatalError("MediatorWorker: Consumer exception.", e);
                        } else {
                            this.logWorker(Level.FINE, "Consumer exception expected, caught: " + e);
                        }
                        break;
                    }
                    worldEvent = null;
                }
            }
            catch (Exception e) {
                this.running = false;
                if (!this.exceptionExpected) {
                    Mediator.this.controller.fatalError("MediatorWorker: Exception.", e);
                }
                this.logWorker(Level.FINE, "Exception expected, caught: " + e);
            }
            try {
                this.stopLatch.countDown();
            }
            finally {
                this.shouldRun = false;
                this.running = false;
                Object object = Mediator.this.threadMutex;
                synchronized (object) {
                    if (Mediator.this.workerThread == this.myThread) {
                        Mediator.this.worker = null;
                        Mediator.this.workerThread = null;
                    }
                }
                this.logWorker(Level.WARNING, "Stopped.");
            }
        }

        private void logWorker(Level level, String message) {
            Mediator.this.log.log(level, "MediatorWorker: " + message);
        }

        private void logWorker(Level level, String message, Object obj) {
            if (obj == null) {
                Mediator.this.log.log(level, "MediatorWorker: " + message);
            } else {
                Mediator.this.log.log(level, "MediatorWorker: " + message, obj);
            }
        }
    }
}

