/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.command.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.jmx.IJMXEnabled;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.command.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldWriterProvider;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutJMXException;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@AgentScoped
public final class Act
implements IComponent,
IAct,
IJMXEnabled {
    public static final Token COMPONENT_ID = Tokens.get("Act");
    public static final String DEFAULT_LINE_END = "\r\n";
    private CommandMessageListenerNotifier notifier = new CommandMessageListenerNotifier();
    private IWorldWriterProvider writerProvider;
    private Writer writer;
    private PrintWriter printWriter;
    private ICommandSerializer<String> serializer;
    private final LogCategory log;
    private IComponentBus eventBus;
    private ComponentController controller;
    private ListenersMap<Class> listeners = new ListenersMap();
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void stop() {
            Act.this.writer = null;
            Act.this.printWriter = null;
        }

        @Override
        public void start() {
            if (Act.this.log.isLoggable(Level.FINE)) {
                Act.this.log.fine("Getting writer from " + Act.this.writerProvider + ".");
            }
            Act.this.writer = Act.this.writerProvider.getWriter();
            if (Act.this.writer == null) {
                throw new CommunicationException("Can't get writer, " + Act.this.writerProvider + ".getWriter() has returned null.", (Logger)Act.this.log, (Object)this);
            }
            Act.this.printWriter = new PrintWriter(Act.this.writer);
        }

        @Override
        public void kill() {
            Act.this.writer = null;
            Act.this.printWriter = null;
        }

        @Override
        public void reset() {
            Act.this.writer = null;
            Act.this.printWriter = null;
        }
    };

    @Inject
    public Act(IWorldWriterProvider writerProvider, ICommandSerializer serializer, IComponentBus eventBus, IAgentLogger logger) {
        this.log = logger.getCategory(this.getComponentId().getToken());
        this.writerProvider = writerProvider;
        this.serializer = serializer;
        this.writer = null;
        this.eventBus = eventBus;
        this.controller = new ComponentController(this, this.control, eventBus, this.log, ComponentDependencyType.STARTS_AFTER, writerProvider);
    }

    @Override
    public Token getComponentId() {
        return COMPONENT_ID;
    }

    protected void sendCommand(CommandMessage command) {
        this.printWriter.print(this.serializer.serialize(command) + DEFAULT_LINE_END);
        this.printWriter.flush();
    }

    @Override
    public synchronized void act(CommandMessage command) {
        if (!this.controller.isRunning()) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Not running, can't send " + command);
            }
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending: " + command);
        }
        this.notifier.setMessage(command);
        Collection<Class> commandClasses = ClassUtils.getSubclasses(command.getClass());
        for (Class cls : commandClasses) {
            this.listeners.notify(cls, this.notifier);
        }
        this.sendCommand(command);
    }

    @Override
    public void addCommandListener(Class commandClass, ICommandListener listener) {
        this.listeners.add(commandClass, listener);
    }

    @Override
    public boolean isCommandListening(Class commandClass, ICommandListener listener) {
        return this.listeners.isListening(commandClass, listener);
    }

    @Override
    public void removeCommandListener(Class commandClass, ICommandListener listener) {
        this.listeners.remove(commandClass, listener);
    }

    @Override
    public void enableJMX(MBeanServer mBeanServer, ObjectName parent) {
        try {
            mBeanServer.registerMBean(this, PogamutJMX.getObjectName(parent, "act"));
        }
        catch (Exception ex) {
            throw new PogamutJMXException(ex, (Object)this);
        }
    }

    public String toString() {
        return "Act[serializer=" + this.serializer + "]";
    }

    private static class CommandMessageListenerNotifier
    implements Listeners.ListenerNotifier<IListener> {
        private CommandMessage msg;

        private CommandMessageListenerNotifier() {
        }

        public void setMessage(CommandMessage msg) {
            this.msg = msg;
        }

        @Override
        public void notify(IListener listener) {
            listener.notify(this.msg);
        }

        @Override
        public Object getEvent() {
            return this.msg;
        }
    }
}

