/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.AgentModule;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.exception.LogicThreadAlteredException;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.AcceptEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.WaitForEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.utils.Const;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class LogicModule<AGENT extends IAgent>
extends AgentModule<AGENT> {
    private static long THREAD_COUNTER = 0L;
    private static final long LOGIC_WAIT_TIME_PLUS_MILLIS = 1000L;
    public static final long MIN_LOGIC_PERIOD_MILLIS = 1L;
    public static final double MIN_LOGIC_FREQUENCY = 0.0;
    protected Object mutex = new Object();
    protected IAgentLogic logic;
    protected Thread logicThread = null;
    protected boolean logicShouldRun = true;
    protected Flag<Boolean> logicRunning = new Flag<Boolean>(false);
    protected Flag<Boolean> logicShouldPause = new Flag<Boolean>(false);
    protected Flag<Boolean> logicPaused = new Flag<Boolean>(false);
    protected double logicFrequency = 5.0;
    protected double logicPeriod = 200.0;
    protected long lastLogicRun = 0L;

    @Inject
    public LogicModule(AGENT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, log, dependencies);
        this.logic = logic;
    }

    private void clearLogicRunningVars() {
        this.logicShouldPause.setFlag(false);
        this.logicPaused.setFlag(false);
        this.logicRunning.setFlag(false);
        this.logicShouldRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws AgentException {
        super.start();
        Object object = this.mutex;
        synchronized (object) {
            if (this.logicThread != null) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Logic thread is not null! Sending interrupt and dropping the reference, possibly leaking resources.");
                }
                this.logicThread.interrupt();
                this.logicThread = null;
            }
            long counter = THREAD_COUNTER++;
            String name = this.agent.getName() + "'s logic (" + counter + ")";
            this.clearLogicRunningVars();
            this.logicThread = new Thread((Runnable)new LogicRunner("Thread " + counter), this.agent.getName() + " logic");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Starting logic thread.");
        }
        this.logicThread.start();
        long waitTime = this.logic.getLogicInitializeTime() + 1000L;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the logic to initialize (" + waitTime + " ms).");
        }
        Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{true});
        if (!this.controller.inState(ComponentState.STARTING)) {
            throw new ComponentCantStartException("Woke up, module state differs. It is not " + (Object)((Object)ComponentState.STARTING) + " but " + (Object)((Object)this.controller.getState().getFlag()) + ".", this.log, (IComponent)this);
        }
        if (result == null) {
            throw new ComponentCantStartException("Logic initialization is taking too long, did you correctly specified initialize time via getInitializeTime() method?", this.log, (IComponent)this);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadStopping();
        } else {
            Boolean result;
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            if ((result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false})) == null) {
                throw new ComponentCantStopException("Logic thread is still running! Is your logic too cpu-demanding?", this.log, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kill() {
        super.kill();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadKilling();
        } else {
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            Object object = this.mutex;
            synchronized (object) {
                if (this.logicThread == null) {
                    return;
                }
            }
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result == null) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Logic thread is still running, sending interrupt.");
                    } else {
                        return;
                    }
                }
                this.logicThread.interrupt();
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            }
            result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result == null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Logic thread is still running, is your logic too much cpu demanding?");
                }
            }
        }
    }

    @Override
    protected void pause() {
        super.pause();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadPausing();
        } else {
            Boolean result;
            this.logicShouldPause.setFlag(true);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to pause (" + waitTime + " ms).");
            }
            if ((result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{true})) == null) {
                throw new ComponentCantPauseException("Logic is still running, is your logic cpu demanding too much?", this.log, (Object)this);
            }
        }
    }

    @Override
    protected void resume() {
        super.resume();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadResuming();
        } else {
            Boolean result;
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Waiting for the logic to resume (" + waitTime + " ms).");
            }
            if ((result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{false})) == null) {
                throw new ComponentCantResumeException("Logic did not resumed.", this.log, (Object)this);
            }
        }
    }

    protected void inThreadStopping() {
        this.inThreadWarning("Stopping", "stopped", "stop");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
    }

    protected void inThreadKilling() {
        this.inThreadWarning("Killing", "killed", "kill");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
        this.logicThread.interrupt();
    }

    protected void inThreadPausing() {
        this.inThreadWarning("Pausing", "paused", "pause");
        this.logicShouldPause.setFlag(true);
    }

    protected void inThreadResuming() {
        this.inThreadWarning("Resuming", "resumed", "resume");
        this.logicShouldPause.setFlag(false);
    }

    private void inThreadWarning(String str1, String str2, String str3) {
        String warning = "In-Logic-Thread " + str1 + " happens. This occurs whenever the LogicModule is being " + str2 + " from within its own thread. While this may proceed as you have expected, it is unsupported operation with uncertain result." + Const.NEW_LINE + "It is adviced to perform the troubling operation in different thread, e.g.:" + Const.NEW_LINE + "    new Thread(new Runnable() {" + Const.NEW_LINE + "        @Override" + Const.NEW_LINE + "        public void run() {" + Const.NEW_LINE + "            // do something that happens to " + str3 + " the logic module //" + Const.NEW_LINE + "        }" + Const.NEW_LINE + "    }).start();";
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning(warning);
        } else if (this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(warning);
        }
    }

    protected void beforeLogic(String threadName) {
    }

    protected void afterLogic(String threadName) {
    }

    protected void afterLogicException(String threadName, Throwable e) {
    }

    protected boolean shouldExecuteLogic() {
        return true;
    }

    protected void logicLatch(String threadName) {
    }

    public double getLogicPeriod() {
        return this.logicPeriod;
    }

    public double getLogicFrequency() {
        return this.logicFrequency;
    }

    public void setLogicFrequency(double frequency) {
        this.logicFrequency = frequency;
        if (this.logicFrequency <= 0.0) {
            this.logicPeriod = Double.POSITIVE_INFINITY;
            this.logicPeriod = 1.0;
        } else {
            this.logicPeriod = 1000.0 / this.logicFrequency;
            this.logicFrequency = 1000.0;
        }
        if (this.logicPeriod < 0.0 || this.logicFrequency <= 0.0) {
            this.logicPeriod = 1.0;
            this.logicFrequency = 1000.0;
        }
    }

    static /* synthetic */ void access$000(LogicModule x0) {
        x0.clearLogicRunningVars();
    }

    private class LogicRunner
    implements Runnable {
        private String name;
        private WaitForEvent startedEvent;

        public LogicRunner(String name) {
            this.startedEvent = new WaitForEvent(LogicModule.this.eventBus, new AcceptEvent<IStartedEvent>(IStartedEvent.class, LogicModule.this.getComponentId()));
            if (name == null) {
                name = "unnamed";
            }
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (LogicModule.this.log.isLoggable(Level.WARNING)) {
                LogicModule.this.log.warning(this.name + ": Thread started.");
            }
            if (LogicModule.this.log.isLoggable(Level.FINE)) {
                LogicModule.this.log.fine(this.name + ": Initializing logic.");
            }
            StopWatch logicWatch = new StopWatch();
            LogicModule.this.logic.logicInitialize(LogicModule.this);
            if (LogicModule.this.log.isLoggable(Level.INFO)) {
                LogicModule.this.log.info(this.name + ": Logic initialized (" + logicWatch.stopStr() + ").");
            }
            Object object = LogicModule.this.mutex;
            // MONITORENTER : object
            if (LogicModule.this.logicThread != Thread.currentThread()) {
                if (LogicModule.this.log.isLoggable(Level.SEVERE)) {
                    LogicModule.this.log.severe(this.name + ": Logic thread altered! Shutdown not called!");
                }
                // MONITOREXIT : object
                return;
            }
            LogicModule.this.logicRunning.setFlag(true);
            // MONITOREXIT : object
            long sleepTime = 0L;
            try {
                if (LogicModule.this.log.isLoggable(Level.FINER)) {
                    LogicModule.this.log.finer(this.name + ": waiting for the logic module started event.");
                }
                this.startedEvent.await();
                if (LogicModule.this.log.isLoggable(Level.FINER)) {
                    LogicModule.this.log.finer(this.name + ": logic module started event received.");
                }
                Object object2 = LogicModule.this.mutex;
                // MONITORENTER : object2
                if (LogicModule.this.logicThread != Thread.currentThread()) {
                    throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                }
                // MONITOREXIT : object2
                LogicModule.this.logicLatch(this.name);
                object2 = LogicModule.this.mutex;
                // MONITORENTER : object2
                if (LogicModule.this.logicThread != Thread.currentThread()) {
                    throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                }
                // MONITOREXIT : object2
                while (!Thread.currentThread().isInterrupted()) {
                    if (!LogicModule.this.logicShouldRun) return;
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                    if (LogicModule.this.logicShouldPause.getFlag().booleanValue()) {
                        object2 = LogicModule.this.mutex;
                        // MONITORENTER : object2
                        if (LogicModule.this.logicThread != Thread.currentThread()) {
                            throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                        }
                        LogicModule.this.logicPaused.setFlag(true);
                        // MONITOREXIT : object2
                        if (LogicModule.this.log.isLoggable(Level.WARNING)) {
                            LogicModule.this.log.warning(this.name + ": Logic paused.");
                        }
                        LogicModule.this.logicShouldPause.waitFor((Boolean[])new Boolean[]{false});
                        object2 = LogicModule.this.mutex;
                        // MONITORENTER : object2
                        if (LogicModule.this.logicThread != Thread.currentThread()) {
                            throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                        }
                        LogicModule.this.logicPaused.setFlag(false);
                        // MONITOREXIT : object2
                        if (LogicModule.this.log.isLoggable(Level.WARNING)) {
                            LogicModule.this.log.warning(this.name + ": Logic resumed.");
                        }
                    }
                    if ((sleepTime = (long)LogicModule.this.logicPeriod - (System.currentTimeMillis() - LogicModule.this.lastLogicRun)) > 0L) {
                        if (LogicModule.this.log.isLoggable(Level.FINER)) {
                            LogicModule.this.log.finer(this.name + ": Sleeping for " + sleepTime + " ms.");
                        }
                        Thread.sleep(sleepTime);
                    }
                    if (LogicModule.this.logicThread != Thread.currentThread()) {
                        throw new LogicThreadAlteredException(this.name, LogicModule.this.log, LogicModule.this);
                    }
                    try {
                        block129: {
                            if (LogicModule.this.log.isLoggable(Level.FINER)) {
                                LogicModule.this.log.finer(this.name + ": Logic iteration.");
                            }
                            logicWatch.start();
                            LogicModule.this.beforeLogic(this.name);
                            try {
                                LogicModule.this.lastLogicRun = System.currentTimeMillis();
                                if (LogicModule.this.shouldExecuteLogic()) {
                                    LogicModule.this.logic.logic();
                                    break block129;
                                }
                                if (LogicModule.this.log.isLoggable(Level.INFO)) {
                                    LogicModule.this.log.info(this.name + ": Logic should not run now...");
                                }
                            }
                            catch (Exception e1) {
                                try {
                                    LogicModule.this.afterLogicException(this.name, e1);
                                    throw e1;
                                }
                                catch (Exception e2) {
                                    if (!LogicModule.this.log.isLoggable(Level.SEVERE)) throw e1;
                                    LogicModule.this.log.severe(ExceptionToString.process(this.name + ": afterLogicException() exception.", e2));
                                }
                                throw e1;
                            }
                        }
                        LogicModule.this.afterLogic(this.name);
                        if (!LogicModule.this.log.isLoggable(Level.FINE)) continue;
                        LogicModule.this.log.fine(this.name + ": Logic iteration finished (" + logicWatch.stopStr() + ").");
                    }
                    catch (ComponentPausedException e) {
                        if (LogicModule.this.log.isLoggable(Level.INFO)) {
                            LogicModule.this.log.info(this.name + ": pausing the thread, received ComponentPausedException from " + e.getOrigin() + ".");
                        }
                        LogicModule.this.logicShouldPause.setFlag(true);
                    }
                }
                return;
            }
            catch (LogicThreadAlteredException e1) {
                return;
            }
            catch (InterruptedException e2) {
                try {
                    if (LogicModule.this.log.isLoggable(Level.FINE)) {
                        LogicModule.this.log.fine(this.name + ": Shutting down the logic.");
                    }
                    logicWatch.start();
                    LogicModule.this.logic.logicShutdown();
                    if (!LogicModule.this.log.isLoggable(Level.INFO)) return;
                    LogicModule.this.log.info(this.name + ": Logic shutdown (" + logicWatch.stopStr() + ").");
                    return;
                }
                catch (Exception e) {
                    LogicModule.this.controller.fatalError(this.name + ": Logic shutdown exception.", e);
                    return;
                }
                finally {
                    Object e = LogicModule.this.mutex;
                }
            }
            catch (PogamutInterruptedException e3) {
                try {
                    if (LogicModule.this.log.isLoggable(Level.FINE)) {
                        LogicModule.this.log.fine(this.name + ": Shutting down the logic.");
                    }
                    logicWatch.start();
                    LogicModule.this.logic.logicShutdown();
                    if (!LogicModule.this.log.isLoggable(Level.INFO)) return;
                    LogicModule.this.log.info(this.name + ": Logic shutdown (" + logicWatch.stopStr() + ").");
                    return;
                }
                catch (Exception e) {
                    LogicModule.this.controller.fatalError(this.name + ": Logic shutdown exception.", e);
                    return;
                }
                finally {
                    Object e = LogicModule.this.mutex;
                }
            }
            catch (ComponentNotRunningException e5) {
                LogicModule.this.log.log(LogicModule.this.log.getLevel(), this.name + ": stopping the thread, received ComponentNotRunningException from " + e5.getOrigin() + ".");
                return;
            }
            catch (Exception e4) {
                LogicModule.this.controller.fatalError(this.name + ": Logic iteration exception.", e4);
                return;
            }
            finally {
                try {
                    if (LogicModule.this.log.isLoggable(Level.FINE)) {
                        LogicModule.this.log.fine(this.name + ": Shutting down the logic.");
                    }
                    logicWatch.start();
                    LogicModule.this.logic.logicShutdown();
                    if (LogicModule.this.log.isLoggable(Level.INFO)) {
                        LogicModule.this.log.info(this.name + ": Logic shutdown (" + logicWatch.stopStr() + ").");
                    }
                }
                catch (Exception e) {
                    LogicModule.this.controller.fatalError(this.name + ": Logic shutdown exception.", e);
                }
                finally {
                    Object e = LogicModule.this.mutex;
                }
            }
        }
    }
}

