/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class CheckTreeController
extends MouseAdapter {
    JTree tree;
    TreePacksPanel treePacksPanel;
    int checkWidth;

    public CheckTreeController(TreePacksPanel treePacksPanel) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.tree = treePacksPanel.getTree();
        this.treePacksPanel = treePacksPanel;
    }

    private void selectNode(CheckBoxNode checkBoxNode) {
        checkBoxNode.setPartial(false);
        this.treePacksPanel.setModelValue(checkBoxNode);
        Enumeration<TreeNode> enumeration = checkBoxNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            checkBoxNode2.setSelected(checkBoxNode.isSelected() || checkBoxNode2.getPack().required);
            if (!checkBoxNode2.isSelected()) {
                checkBoxNode2.setPartial(false);
            }
            this.treePacksPanel.setModelValue(checkBoxNode2);
        }
        this.treePacksPanel.fromModel();
    }

    private boolean hasExcludes(CheckBoxNode checkBoxNode) {
        Enumeration<TreeNode> enumeration = checkBoxNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            if (checkBoxNode2.getPack().excludeGroup == null) continue;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        CheckBoxNode checkBoxNode = (CheckBoxNode)treePath.getLastPathComponent();
        this.treePacksPanel.setDescription(checkBoxNode.getId());
        this.treePacksPanel.setDependencies(checkBoxNode.getId());
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)treePath).x + this.checkWidth) {
            return;
        }
        if (checkBoxNode.getPack().required) {
            return;
        }
        boolean bl = checkBoxNode.isSelected() & !checkBoxNode.isPartial();
        boolean bl2 = checkBoxNode.isPartial();
        boolean bl3 = this.hasExcludes(checkBoxNode);
        CheckBoxNode checkBoxNode2 = (CheckBoxNode)checkBoxNode.getRoot();
        if (bl2 && bl3) {
            checkBoxNode.setSelected(false);
            this.selectNode(checkBoxNode);
            this.updateAllParents(checkBoxNode2);
        } else {
            if (!bl) {
                this.selectAllChildNodes(checkBoxNode);
            }
            checkBoxNode.setSelected(!bl);
            this.selectNode(checkBoxNode);
            this.updateAllParents(checkBoxNode2);
        }
        CheckTreeController.initTotalSize(checkBoxNode2, true);
        this.treePacksPanel.setBytes((int)checkBoxNode2.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        this.tree.treeDidChange();
    }

    public void selectAllChildNodes(CheckBoxNode checkBoxNode) {
        Enumeration<TreeNode> enumeration = checkBoxNode.children();
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            this.selectAllDependencies(checkBoxNode2);
            if (checkBoxNode2.getChildCount() > 0) {
                this.selectAllChildNodes(checkBoxNode2);
            }
            checkBoxNode2.setSelected(true);
            checkBoxNode2.setEnabled(true);
            this.treePacksPanel.setModelValue(checkBoxNode2);
            checkBoxNode2.setEnabled(!checkBoxNode2.getPack().required);
        }
    }

    public void selectAllDependencies(CheckBoxNode checkBoxNode) {
        Pack pack = checkBoxNode.getPack();
        List<String> list = pack.getDependencies();
        if (list == null) {
            return;
        }
        for (String string : list) {
            CheckBoxNode checkBoxNode2 = this.treePacksPanel.getCbnById(string);
            this.selectAllDependencies(checkBoxNode2);
            if (checkBoxNode2.getChildCount() > 0 && (!checkBoxNode2.isSelected() || checkBoxNode2.isPartial())) {
                this.selectAllChildNodes(checkBoxNode2);
            }
            checkBoxNode2.setSelected(true);
            checkBoxNode2.setEnabled(true);
            this.treePacksPanel.setModelValue(checkBoxNode2);
            checkBoxNode2.setEnabled(!checkBoxNode2.getPack().required);
        }
    }

    public void updateAllParents(CheckBoxNode checkBoxNode) {
        Enumeration<TreeNode> enumeration = checkBoxNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            if (checkBoxNode2.getParent() == null || checkBoxNode2.getParent().equals(checkBoxNode)) continue;
            this.updateParents(checkBoxNode2);
        }
    }

    private void updateParents(CheckBoxNode checkBoxNode) {
        CheckBoxNode checkBoxNode2 = (CheckBoxNode)checkBoxNode.getParent();
        if (checkBoxNode2 != null && !checkBoxNode2.equals(checkBoxNode2.getRoot())) {
            Enumeration<TreeNode> enumeration = checkBoxNode2.children();
            boolean bl = true;
            boolean bl2 = true;
            while (enumeration.hasMoreElements()) {
                CheckBoxNode checkBoxNode3 = (CheckBoxNode)enumeration.nextElement();
                if (checkBoxNode3.isSelected()) {
                    bl2 = false;
                } else {
                    bl = false;
                }
                if (checkBoxNode3.isPartial()) {
                    bl2 = false;
                    bl = false;
                }
                if (bl || bl2) continue;
                break;
            }
            if (checkBoxNode2.getChildCount() > 0) {
                if (!bl && !bl2) {
                    CheckTreeController.setPartialParent(checkBoxNode2);
                } else {
                    checkBoxNode2.setPartial(false);
                }
                if (bl) {
                    checkBoxNode2.setSelected(true);
                }
                if (bl2) {
                    checkBoxNode2.setSelected(false);
                }
                this.treePacksPanel.setModelValue(checkBoxNode2);
                if (bl || bl2) {
                    this.updateParents(checkBoxNode2);
                }
            }
        }
    }

    public static void setPartialParent(CheckBoxNode checkBoxNode) {
        checkBoxNode.setPartial(true);
        CheckBoxNode checkBoxNode2 = (CheckBoxNode)checkBoxNode.getParent();
        if (checkBoxNode2 != null && !checkBoxNode2.equals(checkBoxNode2.getRoot())) {
            CheckTreeController.setPartialParent(checkBoxNode2);
        }
    }

    public static long initTotalSize(CheckBoxNode checkBoxNode, boolean bl) {
        if (checkBoxNode.isLeaf()) {
            return checkBoxNode.getPack().nbytes;
        }
        Enumeration<TreeNode> enumeration = checkBoxNode.children();
        Pack pack = checkBoxNode.getPack();
        long l = 0L;
        if (pack != null) {
            l = pack.nbytes;
        }
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            long l2 = CheckTreeController.initTotalSize(checkBoxNode2, bl);
            if (!checkBoxNode2.isSelected() && !checkBoxNode2.isPartial()) continue;
            l += l2;
        }
        if (bl) {
            long l3 = checkBoxNode.getTotalSize();
            if (l3 != l) {
                checkBoxNode.setTotalSizeChanged(true);
            } else {
                checkBoxNode.setTotalSizeChanged(false);
            }
        }
        checkBoxNode.setTotalSize(l);
        return l;
    }
}

