/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRepositoryAccessor {
    private String installXmlUrl;
    private String baseUrl;
    private String installXmlString;
    private String packsInfo;
    private ArrayList<PackInfo> packs;
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String installFilename = "install.xml";
    private static final String packsinfoFilename = "packsinfo.xml";
    private static final int BUFFER_SIZE = 1000000;

    public WebRepositoryAccessor(String string) {
        this.installXmlUrl = string + "/" + installFilename;
        this.baseUrl = string;
    }

    public ArrayList<PackInfo> getOnlinePacks() {
        this.readConfig();
        this.packs = this.parsePacks();
        this.readPacksInfo();
        this.parsePacksInfo();
        return this.packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromURL(String string) {
        int n = 1000000;
        byte[] byArray = new byte[n];
        InputStream inputStream = null;
        try {
            int n2;
            WebAccessor webAccessor = new WebAccessor(null);
            inputStream = webAccessor.openInputStream(new URL(string));
            if (inputStream == null) {
                throw new RuntimeException("Unable to open network stream");
            }
            int n3 = n2 = inputStream.read(byArray);
            while (n2 > 0) {
                n2 = inputStream.read(byArray, n3, n - n3);
                n3 += n2;
            }
            String string2 = new String(byArray);
            return string2;
        }
        catch (Exception exception) {
            System.out.println(exception + " while trying to download " + string);
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readConfig() {
        this.installXmlString = this.stringFromURL(this.installXmlUrl);
    }

    private void readPacksInfo() {
        String string = this.baseUrl + "/" + packsinfoFilename;
        this.packsInfo = this.stringFromURL(string);
    }

    private ArrayList<PackInfo> parsePacks() {
        try {
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            IXMLReader iXMLReader = StdXMLReader.stringReader(this.installXmlString);
            iXMLParser.setReader(iXMLReader);
            XMLElement xMLElement = (XMLElement)iXMLParser.parse();
            return this.loadPacksList(xMLElement);
        }
        catch (Exception exception) {
            System.out.println("WARN: Unable to parse install.xml");
            return null;
        }
    }

    private void parsePacksInfo() {
        try {
            XMLElement xMLElement;
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            IXMLReader iXMLReader = StdXMLReader.stringReader(this.packsInfo);
            iXMLParser.setReader(iXMLReader);
            XMLElement xMLElement2 = xMLElement = (XMLElement)iXMLParser.parse();
            for (int i = 0; i < xMLElement2.getChildrenCount(); ++i) {
                XMLElement xMLElement3 = xMLElement2.getChildAtIndex(i);
                PackInfo packInfo = this.packs.get(i);
                Pack pack = packInfo.getPack();
                pack.nbytes = Long.parseLong(xMLElement3.getAttribute("nbytes"));
            }
        }
        catch (Exception exception) {
            System.out.println("WARN: Unable to parse packsinfo.xml");
        }
    }

    public static String getCachedUrl(String string, String string2) throws Exception {
        int n = 1000000;
        byte[] byArray = new byte[n];
        try {
            WebAccessor webAccessor = new WebAccessor(null);
            InputStream inputStream = webAccessor.openInputStream(new URL(string));
            int n2 = inputStream.read(byArray);
            File file = new File(string2);
            file.mkdirs();
            File file2 = File.createTempFile("izpacktempfile", "jar", new File(string2));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            String string3 = "file:///" + file2.getAbsolutePath();
            while (n2 > 0) {
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            fileOutputStream.close();
            return string3;
        }
        catch (SecurityException securityException) {
            System.out.println(securityException + " while trying to write temp file: " + string2);
            throw securityException;
        }
        catch (Exception exception) {
            System.out.println(exception + " while trying to download " + string);
            throw exception;
        }
    }

    protected ArrayList<PackInfo> loadPacksList(XMLElement xMLElement) throws CompilerException {
        ArrayList<PackInfo> arrayList = new ArrayList<PackInfo>();
        XMLElement xMLElement2 = this.requireChildNamed(xMLElement, "packs");
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("pack");
        if (vector.isEmpty()) {
            this.parseError(xMLElement2, "<packs> requires a <pack>");
        }
        for (XMLElement xMLElement3 : vector) {
            Object object;
            Object object2;
            Object object3;
            String string = this.requireAttribute(xMLElement3, "name");
            String string2 = xMLElement3.getAttribute("id");
            boolean bl = "true".equalsIgnoreCase(xMLElement3.getAttribute("loose", "false"));
            String string3 = this.requireChildNamed(xMLElement3, "description").getContent();
            boolean bl2 = this.requireYesNoAttribute(xMLElement3, "required");
            String string4 = xMLElement3.getAttribute("group");
            String string5 = xMLElement3.getAttribute("installGroups");
            String string6 = xMLElement3.getAttribute("excludeGroup");
            boolean bl3 = "yes".equalsIgnoreCase(xMLElement3.getAttribute("uninstall", "yes"));
            String string7 = xMLElement3.getAttribute("parent");
            if (bl2 && string6 != null) {
                this.parseError(xMLElement3, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo packInfo = new PackInfo(string, string2, string3, bl2, bl, string6, bl3);
            packInfo.setOsConstraints(OsConstraint.getOsList(xMLElement3));
            packInfo.setParent(string7);
            if (string6 == null) {
                packInfo.setPreselected(this.validateYesNoAttribute(xMLElement3, "preselected", YES));
            } else {
                packInfo.setPreselected(this.validateYesNoAttribute(xMLElement3, "preselected", NO));
            }
            if (string4 != null) {
                packInfo.setGroup(string4);
            }
            if (string5 != null) {
                Iterator<XMLElement> iterator = new StringTokenizer(string5, ",");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    String string8 = ((StringTokenizer)((Object)iterator)).nextToken();
                    packInfo.addInstallGroup(string8);
                }
            }
            for (XMLElement xMLElement4 : xMLElement3.getChildrenNamed("parsable")) {
                object3 = this.requireAttribute(xMLElement4, "targetfile");
                object2 = xMLElement4.getAttribute("type", "plain");
                object = xMLElement4.getAttribute("encoding", null);
                Iterator<XMLElement> iterator = OsConstraint.getOsList(xMLElement4);
                packInfo.addParsable(new ParsableFile((String)object3, (String)object2, (String)object, (List<OsConstraint>)((Object)iterator)));
            }
            for (XMLElement xMLElement5 : xMLElement3.getChildrenNamed("executable")) {
                object3 = new ExecutableFile();
                ((ExecutableFile)object3).path = this.requireAttribute(xMLElement5, "targetfile");
                object2 = xMLElement5.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).executionStage = 2;
                }
                object2 = xMLElement5.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).type = 1;
                    ((ExecutableFile)object3).mainClass = xMLElement5.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase((String)(object2 = xMLElement5.getAttribute("failure", "ask")))) {
                    ((ExecutableFile)object3).onFailure = 0;
                } else if ("warn".equalsIgnoreCase((String)object2)) {
                    ((ExecutableFile)object3).onFailure = 1;
                }
                object2 = xMLElement5.getAttribute("keep");
                ((ExecutableFile)object3).keepFile = "true".equalsIgnoreCase((String)object2);
                object = xMLElement5.getFirstChildNamed("args");
                if (null != object) {
                    for (XMLElement xMLElement6 : ((XMLElement)object).getChildrenNamed("arg")) {
                        ((ExecutableFile)object3).argList.add(this.requireAttribute(xMLElement6, "value"));
                    }
                }
                ((ExecutableFile)object3).osList = OsConstraint.getOsList(xMLElement5);
                packInfo.addExecutable((ExecutableFile)object3);
            }
            for (XMLElement xMLElement7 : xMLElement3.getChildrenNamed("updatecheck")) {
                object3 = xMLElement7.getAttribute("casesensitive");
                object2 = new ArrayList();
                object = new ArrayList();
                for (XMLElement xMLElement8 : xMLElement7.getChildrenNamed("include")) {
                    ((ArrayList)object2).add(this.requireAttribute(xMLElement8, "name"));
                }
                for (XMLElement xMLElement9 : xMLElement7.getChildrenNamed("exclude")) {
                    ((ArrayList)object).add(this.requireAttribute(xMLElement9, "name"));
                }
                packInfo.addUpdateCheck(new UpdateCheck((ArrayList<String>)object2, (ArrayList<String>)object, (String)object3));
            }
            for (XMLElement xMLElement10 : xMLElement3.getChildrenNamed("depends")) {
                object3 = this.requireAttribute(xMLElement10, "packname");
                packInfo.addDependency((String)object3);
            }
            arrayList.add(packInfo);
        }
        return arrayList;
    }

    protected void parseError(String string) throws CompilerException {
        throw new CompilerException("install.xml:" + string);
    }

    protected void parseError(XMLElement xMLElement, String string) throws CompilerException {
        throw new CompilerException("install.xml:" + xMLElement.getLineNr() + ": " + string);
    }

    protected void parseError(XMLElement xMLElement, String string, Throwable throwable) throws CompilerException {
        throw new CompilerException("install.xml:" + xMLElement.getLineNr() + ": " + string, throwable);
    }

    protected void parseWarn(XMLElement xMLElement, String string) {
        System.out.println("install.xml:" + xMLElement.getLineNr() + ": " + string);
    }

    protected XMLElement requireChildNamed(XMLElement xMLElement, String string) throws CompilerException {
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(string);
        if (xMLElement2 == null) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires child <" + string + ">");
        }
        return xMLElement2;
    }

    protected URL requireURLContent(XMLElement xMLElement) throws CompilerException {
        URL uRL = null;
        try {
            uRL = new URL(this.requireContent(xMLElement));
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires valid URL", malformedURLException);
        }
        return uRL;
    }

    protected String requireContent(XMLElement xMLElement) throws CompilerException {
        String string = xMLElement.getContent();
        if (string == null || string.length() == 0) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires content");
        }
        return string;
    }

    protected String requireAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires attribute '" + string + "'");
        }
        return string2;
    }

    protected int requireIntAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires attribute '" + string + "'");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.parseError(xMLElement, "'" + string + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = this.requireAttribute(xMLElement, string);
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseError(xMLElement, "<" + xMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(XMLElement xMLElement, String string, boolean bl) {
        if (xMLElement == null) {
            return bl;
        }
        String string2 = xMLElement.getAttribute(string, bl ? "yes" : "no");
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseWarn(xMLElement, "<" + xMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no) if present");
        return bl;
    }
}

