/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.Pack;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntActionInstallerListener
extends SimpleInstallerListener {
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private HashMap<String, HashMap<Object, ArrayList<AntAction>>> actions = new HashMap();
    private ArrayList<AntAction> uninstActions = new ArrayList();

    public AntActionInstallerListener() {
        super(true);
    }

    public HashMap<String, HashMap<Object, ArrayList<AntAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void beforePacks(AutomatedInstallData automatedInstallData, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        Object object;
        super.beforePacks(automatedInstallData, n, abstractUIProgressHandler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, new VariableSubstitutor(automatedInstallData.getVariables()));
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        Iterator<Object> iterator = automatedInstallData.selectedPacks.iterator();
        Pack pack = null;
        while (iterator != null && iterator.hasNext()) {
            pack = (Pack)iterator.next();
            object = this.getSpecHelper().getPackForName(pack.name);
            if (object == null) continue;
            HashMap hashMap = new HashMap();
            hashMap.put("beforepack", new ArrayList());
            hashMap.put("afterpack", new ArrayList());
            hashMap.put("beforepacks", new ArrayList());
            hashMap.put("afterpacks", new ArrayList());
            Vector<XMLElement> vector = ((XMLElement)object).getChildrenNamed("antcall");
            if (vector != null && vector.size() >= 1) {
                Iterator<XMLElement> iterator2 = vector.iterator();
                while (iterator2 != null && iterator2.hasNext()) {
                    AntAction antAction = this.readAntCall(iterator2.next());
                    if (antAction == null) continue;
                    ((ArrayList)hashMap.get(antAction.getOrder())).add(antAction);
                }
                if (((ArrayList)hashMap.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(pack.name, hashMap);
        }
        iterator = automatedInstallData.availablePacks.iterator();
        while (iterator.hasNext()) {
            object = ((Pack)iterator.next()).name;
            this.performAllActions((String)object, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        this.performAllActions(pack.name, "beforepack", abstractUIProgressHandler);
    }

    @Override
    public void afterPack(Pack pack, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        this.performAllActions(pack.name, "afterpack", abstractUIProgressHandler);
    }

    @Override
    public void afterPacks(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        if (this.informProgressBar()) {
            abstractUIProgressHandler.nextStep(this.getMsg("AntAction.pack"), this.getProgressBarCallerId(), this.getActionCount(automatedInstallData, "afterpacks"));
        }
        Iterator iterator = automatedInstallData.selectedPacks.iterator();
        while (iterator.hasNext()) {
            String string = ((Pack)iterator.next()).name;
            this.performAllActions(string, "afterpacks", abstractUIProgressHandler);
        }
        if (this.uninstActions.size() > 0) {
            UninstallData.getInstance().addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(AutomatedInstallData automatedInstallData, String string) {
        int n = 0;
        Iterator iterator = automatedInstallData.selectedPacks.iterator();
        while (iterator.hasNext()) {
            String string2 = ((Pack)iterator.next()).name;
            ArrayList<AntAction> arrayList = this.getActions(string2, string);
            if (arrayList == null) continue;
            n += arrayList.size();
        }
        return n;
    }

    protected ArrayList<AntAction> getActions(String string, String string2) {
        if (this.actions == null) {
            return null;
        }
        HashMap<Object, ArrayList<AntAction>> hashMap = this.actions.get(string);
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        return hashMap.get(string2);
    }

    private void performAllActions(String string, String string2, AbstractUIProgressHandler abstractUIProgressHandler) throws InstallerException {
        ArrayList<AntAction> arrayList = this.getActions(string, string2);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        Debug.trace("******* Executing all " + string2 + " actions of " + string + " ...");
        for (AntAction antAction : arrayList) {
            if (this.informProgressBar() && abstractUIProgressHandler != null && abstractUIProgressHandler instanceof ExtendedUIProgressHandler && string2.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)abstractUIProgressHandler)).progress(antAction.getMessageID() != null ? this.getMsg(antAction.getMessageID()) : "");
            }
            try {
                antAction.performInstallAction();
            }
            catch (Exception exception) {
                throw new InstallerException(exception);
            }
            if (antAction.getUninstallTargets().size() <= 0) continue;
            this.uninstActions.add(antAction);
        }
    }

    private AntAction readAntCall(XMLElement xMLElement) throws InstallerException {
        String string;
        if (xMLElement == null) {
            return null;
        }
        SpecHelper specHelper = this.getSpecHelper();
        AntAction antAction = new AntAction();
        try {
            antAction.setOrder(specHelper.getRequiredAttribute(xMLElement, "order"));
            antAction.setUninstallOrder(xMLElement.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception exception) {
            throw new InstallerException(exception);
        }
        antAction.setQuiet(specHelper.isAttributeYes(xMLElement, "quiet", false));
        antAction.setVerbose(specHelper.isAttributeYes(xMLElement, "verbose", false));
        antAction.setBuildFile(specHelper.getRequiredAttribute(xMLElement, "buildfile"));
        String string2 = xMLElement.getAttribute("logfile");
        if (string2 != null) {
            antAction.setLogFile(string2);
        }
        if ((string = xMLElement.getAttribute("messageid")) != null && string.length() > 0) {
            antAction.setMessageID(string);
        }
        for (XMLElement xMLElement2 : xMLElement.getChildrenNamed("propertyfile")) {
            antAction.addPropertyFile(specHelper.getRequiredAttribute(xMLElement2, "path"));
        }
        for (XMLElement xMLElement2 : xMLElement.getChildrenNamed("property")) {
            antAction.setProperty(specHelper.getRequiredAttribute(xMLElement2, "name"), specHelper.getRequiredAttribute(xMLElement2, "value"));
        }
        for (XMLElement xMLElement2 : xMLElement.getChildrenNamed("target")) {
            antAction.addTarget(specHelper.getRequiredAttribute(xMLElement2, "name"));
        }
        for (XMLElement xMLElement2 : xMLElement.getChildrenNamed("uninstall_target")) {
            antAction.addUninstallTarget(specHelper.getRequiredAttribute(xMLElement2, "name"));
        }
        return antAction;
    }
}

