/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.installer.ResourceManager;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class LocaleDatabase
extends TreeMap {
    private static Map<String, LocaleDatabase> cachedLocales = new HashMap<String, LocaleDatabase>();
    public static final String LOCALE_DATABASE_DIRECTORY = "/langpacks/";
    public static final String LOCALE_DATABASE_DEF_SUFFIX = ".xml";
    private static final char TEMP_QUOTING_CHARACTER = '\uffff';
    static final long serialVersionUID = 4941525634108401848L;

    public static synchronized LocaleDatabase getLocaleDatabase(String string) throws Exception {
        return LocaleDatabase.getLocaleDatabase(string, false);
    }

    public static synchronized LocaleDatabase getLocaleDatabase(String string, boolean bl) throws Exception {
        LocaleDatabase localeDatabase = cachedLocales.get(string);
        if (bl || localeDatabase == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOCALE_DATABASE_DIRECTORY);
            stringBuffer.append(string);
            stringBuffer.append(LOCALE_DATABASE_DEF_SUFFIX);
            String string2 = stringBuffer.toString();
            if (LocaleDatabase.class.getResource(string2) != null) {
                localeDatabase = new LocaleDatabase(LocaleDatabase.class.getResourceAsStream(string2));
                cachedLocales.put(string, localeDatabase);
            }
        }
        return localeDatabase;
    }

    public static synchronized LocaleDatabase getLocaleDatabase() throws Exception {
        ResourceManager resourceManager = ResourceManager.getInstance();
        String string = resourceManager.getLocale();
        return LocaleDatabase.getLocaleDatabase(string);
    }

    public LocaleDatabase(InputStream inputStream) throws Exception {
        this.add(inputStream);
    }

    public void add(InputStream inputStream) throws Exception {
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        if (!"langpack".equalsIgnoreCase(xMLElement.getName())) {
            throw new Exception("this is not an IzPack XML langpack file");
        }
        Vector vector = xMLElement.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = (XMLElement)vector.get(i);
            String string = xMLElement2.getContent();
            if (string != null && !"".equals(string)) {
                this.put(xMLElement2.getAttribute("id"), string.trim());
                continue;
            }
            this.put(xMLElement2.getAttribute("id"), xMLElement2.getAttribute("txt"));
        }
    }

    public String getString(String string) {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getString(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "N/A";
                continue;
            }
            if (!stringArray[i].startsWith("$")) continue;
            String string2 = stringArray[i];
            string2 = string2.startsWith("${") ? string2.substring(2, string2.length() - 1) : string2.substring(1);
            stringArray[i] = this.getString(string2);
        }
        String string3 = this.getString(string);
        string3 = string3.replace('\'', '\uffff');
        string3 = MessageFormat.format(string3, stringArray);
        return string3.replace('\uffff', '\'');
    }
}

