/*
 * Decompiled with CFR 0.152.
 */
package com.coi.tools.os.win;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.coi.tools.os.win.RegistryLogItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements MSWinConstants {
    private static final String DEFAULT_PLACEHOLDER = "__#$&DEFAULT_PLACEHODER_VALUE#$?";
    private int currentRoot = -2147483647;
    private List logging = new ArrayList();
    private boolean doLogging = false;

    public int getRoot() {
        return this.currentRoot;
    }

    public void setRoot(int n) {
        this.currentRoot = n;
    }

    public RegDataContainer getValue(String string, String string2) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        return this.getValue(this.currentRoot, string, string2);
    }

    public Object getValueAsObject(String string, String string2) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        return this.getValue(this.currentRoot, string, string2).getDataAsObject();
    }

    public String[] getSubkeys(String string) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        return this.getSubkeyNames(this.currentRoot, string);
    }

    public String[] getValueNames(String string) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        return this.getValueNames(this.currentRoot, string);
    }

    public void createKey(String string) throws NativeLibException {
        this.createKey(this.currentRoot, string);
    }

    public void createKey(int n, String string) throws NativeLibException {
        Object object;
        int n2 = string.lastIndexOf(92);
        if (n2 > 0 && !this.exist(n, (String)(object = string.substring(0, n2)))) {
            this.createKey(n, (String)object);
        }
        this.createKeyN(n, string);
        object = new RegistryLogItem(2, n, string, null, null, null);
        this.log((RegistryLogItem)object);
    }

    public boolean keyExist(String string) throws NativeLibException {
        return this.keyExist(this.currentRoot, string);
    }

    public boolean keyExist(int n, String string) throws NativeLibException {
        try {
            return this.exist(n, string);
        }
        catch (NativeLibException nativeLibException) {
            String string2 = nativeLibException.getLibMessage();
            if ("functionFailed.RegOpenKeyEx".equals(string2)) {
                return false;
            }
            throw nativeLibException;
        }
    }

    public boolean valueExist(String string, String string2) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        try {
            this.getValue(this.currentRoot, string, string2);
        }
        catch (NativeLibException nativeLibException) {
            String string3 = nativeLibException.getLibMessage();
            if ("functionFailed.RegOpenKeyEx".equals(string3) || "functionFailed.RegQueryValueEx".equals(string3)) {
                return false;
            }
            throw nativeLibException;
        }
        return true;
    }

    public void setValue(String string, String string2, String string3) throws NativeLibException {
        this.setValue(this.currentRoot, string, string2, new RegDataContainer(string3));
    }

    public void setValue(String string, String string2, String[] stringArray) throws NativeLibException {
        this.setValue(this.currentRoot, string, string2, new RegDataContainer(stringArray));
    }

    public void setValue(String string, String string2, byte[] byArray) throws NativeLibException {
        this.setValue(this.currentRoot, string, string2, new RegDataContainer(byArray));
    }

    public void setValue(String string, String string2, long l) throws NativeLibException {
        this.setValue(this.currentRoot, string, string2, new RegDataContainer(l));
    }

    public void setValue(String string, String string2, RegDataContainer regDataContainer) throws NativeLibException {
        this.setValue(this.currentRoot, string, string2, regDataContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, String string, String string2, RegDataContainer regDataContainer) throws NativeLibException {
        RegDataContainer regDataContainer2 = null;
        String string3 = string2;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.replace('/', '\\');
        List list = this.logging;
        synchronized (list) {
            try {
                regDataContainer2 = this.getValue(this.currentRoot, string, string2);
            }
            catch (NativeLibException nativeLibException) {
                String string4 = nativeLibException.getLibMessage();
                if ("functionFailed.RegOpenKeyEx".equals(string4) || "functionFailed.RegQueryValueEx".equals(string4)) {
                    this.setValueR(n, string, string2, regDataContainer);
                    return;
                }
                throw nativeLibException;
            }
            this.setValueN(n, string, string2, regDataContainer);
            if (string2.length() == 0) {
                string3 = DEFAULT_PLACEHOLDER;
            }
            RegistryLogItem registryLogItem = new RegistryLogItem(5, n, string, string3, regDataContainer, regDataContainer2);
            this.log(registryLogItem);
        }
    }

    public void deleteKey(String string) throws NativeLibException {
        this.deleteKeyL(this.currentRoot, string);
    }

    public void deleteKeyIfEmpty(String string) throws NativeLibException {
        this.deleteKeyIfEmpty(this.currentRoot, string);
    }

    public void deleteKeyIfEmpty(int n, String string) throws NativeLibException {
        if (this.keyExist(n, string) && this.isKeyEmpty(n, string)) {
            this.deleteKeyL(n, string);
        }
    }

    public void deleteValue(String string, String string2) throws NativeLibException {
        this.deleteValueL(this.currentRoot, string, string2);
    }

    private void deleteKeyL(int n, String string) throws NativeLibException {
        RegistryLogItem registryLogItem = new RegistryLogItem(1, n, string, null, null, null);
        this.log(registryLogItem);
        this.deleteKeyN(n, string);
    }

    private void deleteValueL(int n, String string, String string2) throws NativeLibException {
        if (string == null) {
            string = "";
        }
        RegDataContainer regDataContainer = this.getValue(this.currentRoot, string, string2);
        RegistryLogItem registryLogItem = new RegistryLogItem(3, n, string, string2, null, regDataContainer);
        this.log(registryLogItem);
        this.deleteValueN(this.currentRoot, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() throws IllegalArgumentException, NativeLibException {
        List list = this.logging;
        synchronized (list) {
            Iterator iterator = this.logging.iterator();
            this.suspendLogging();
            while (iterator.hasNext()) {
                RegistryLogItem registryLogItem = (RegistryLogItem)iterator.next();
                String string = DEFAULT_PLACEHOLDER.equals(registryLogItem.getValueName()) ? "" : registryLogItem.getValueName();
                switch (registryLogItem.getType()) {
                    case 2: {
                        this.deleteKeyIfEmpty(registryLogItem.getRoot(), registryLogItem.getKey());
                        break;
                    }
                    case 1: {
                        this.createKeyN(registryLogItem.getRoot(), registryLogItem.getKey());
                        break;
                    }
                    case 4: {
                        RegDataContainer regDataContainer = null;
                        try {
                            regDataContainer = this.getValue(registryLogItem.getRoot(), registryLogItem.getKey(), string);
                        }
                        catch (NativeLibException nativeLibException) {
                            break;
                        }
                        if (!regDataContainer.equals(registryLogItem.getNewValue())) break;
                        this.deleteValueN(registryLogItem.getRoot(), registryLogItem.getKey(), string);
                        break;
                    }
                    case 3: {
                        try {
                            this.getValue(registryLogItem.getRoot(), registryLogItem.getKey(), string);
                        }
                        catch (NativeLibException nativeLibException) {
                            this.setValueN(registryLogItem.getRoot(), registryLogItem.getKey(), string, registryLogItem.getOldValue());
                        }
                        break;
                    }
                    case 5: {
                        RegDataContainer regDataContainer;
                        try {
                            regDataContainer = this.getValue(registryLogItem.getRoot(), registryLogItem.getKey(), string);
                        }
                        catch (NativeLibException nativeLibException) {
                            break;
                        }
                        if (!regDataContainer.equals(registryLogItem.getNewValue())) break;
                        this.setValueN(registryLogItem.getRoot(), registryLogItem.getKey(), string, registryLogItem.getOldValue());
                    }
                }
            }
        }
    }

    private void setValueR(int n, String string, String string2, RegDataContainer regDataContainer) throws NativeLibException {
        String string3 = string2;
        if (!this.exist(n, string)) {
            this.createKey(n, string);
        }
        this.setValueN(n, string, string2, regDataContainer);
        if (string2.length() == 0) {
            string3 = DEFAULT_PLACEHOLDER;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SetValue;").append(Integer.toString(n)).append(";").append(string).append(";").append(string3);
        RegistryLogItem registryLogItem = new RegistryLogItem(4, n, string, string3, regDataContainer, null);
        this.log(registryLogItem);
    }

    private native boolean exist(int var1, String var2) throws NativeLibException;

    private native void createKeyN(int var1, String var2) throws NativeLibException;

    private native void setValueN(int var1, String var2, String var3, RegDataContainer var4) throws NativeLibException;

    private native RegDataContainer getValue(int var1, String var2, String var3) throws NativeLibException;

    private native void deleteValueN(int var1, String var2, String var3) throws NativeLibException;

    private native void deleteKeyN(int var1, String var2) throws NativeLibException;

    private native boolean isKeyEmpty(int var1, String var2) throws NativeLibException;

    private native String[] getSubkeyNames(int var1, String var2) throws NativeLibException;

    private native String[] getValueNames(int var1, String var2) throws NativeLibException;

    public void resetLogging() {
        this.logging = new ArrayList();
        this.activateLogging();
    }

    public void suspendLogging() {
        this.doLogging = false;
    }

    public void activateLogging() {
        this.doLogging = true;
    }

    public List<Object> getLoggingInfo() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.logging.size());
        Iterator iterator = this.logging.iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(((RegistryLogItem)iterator.next()).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return arrayList;
    }

    public void setLoggingInfo(List list) {
        this.resetLogging();
        this.addLoggingInfo(list);
    }

    public void addLoggingInfo(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                this.logging.add(((RegistryLogItem)iterator.next()).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    private void log(RegistryLogItem registryLogItem) {
        if (this.doLogging && this.logging != null) {
            this.logging.add(0, registryLogItem);
        }
    }
}

