/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    protected int instanceNumber = instanceCount++;
    private static int instanceCount = 0;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String NODE_ID = "panel";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String FIELD_NODE_ID = "field";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    private static final String VARIABLE = "variable";
    private static final String SET = "set";
    private static final String TEXT = "txt";
    private static final String SPEC = "spec";
    private static final String PWD = "pwd";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TEXT_FIELD = "text";
    private static final String COMBO_FIELD = "combo";
    private static final String STATIC_TEXT = "staticText";
    private static final String CHOICE = "choice";
    private static final String FILE = "file";
    private static final String PASSWORD = "password";
    private static final String VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String TITLE_FIELD = "title";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String SPACE = "space";
    private static final String DIVIDER = "divider";
    static final String DISPLAY_FORMAT = "displayFormat";
    static final String PLAIN_STRING = "plainString";
    static final String SPECIAL_SEPARATOR = "specialSeparator";
    static final String LAYOUT = "layout";
    static final String RESULT_FORMAT = "resultFormat";
    private static final String DESCRIPTION = "description";
    private static final String TRUE = "true";
    private static final String NAME = "name";
    private static final String FAMILY = "family";
    private static final String OS = "os";
    private static final String SELECTEDPACKS = "createForPack";
    private static Input SPACE_INTPUT_FIELD = new Input("space", null, null, "space", "\r", 0);
    private static Input DIVIDER_INPUT_FIELD = new Input("divider", null, null, "divider", "------------------------------------------", 0);
    public List<Input> listInputs = new ArrayList<Input>();

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData automatedInstallData, Properties properties) {
        this.collectInputs(automatedInstallData);
        Iterator<Input> iterator = this.listInputs.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().strVariableName;
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            automatedInstallData.setVariable(string, string2);
        }
        return true;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData automatedInstallData, PrintWriter printWriter) {
        this.collectInputs(automatedInstallData);
        Iterator<Input> iterator = this.listInputs.iterator();
        while (iterator.hasNext()) {
            printWriter.println(iterator.next().strVariableName + "=");
        }
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData automatedInstallData) {
        boolean bl = this.collectInputs(automatedInstallData);
        if (!bl) {
            return true;
        }
        boolean bl2 = true;
        for (Input input : this.listInputs) {
            if (TEXT_FIELD.equals(input.strFieldType) || FILE.equals(input.strFieldType) || RULE_FIELD.equals(input.strFieldType)) {
                bl2 = bl2 && this.processTextField(input, automatedInstallData);
                continue;
            }
            if (COMBO_FIELD.equals(input.strFieldType) || RADIO_FIELD.equals(input.strFieldType)) {
                bl2 = bl2 && this.processComboRadioField(input, automatedInstallData);
                continue;
            }
            if (CHECK_FIELD.equals(input.strFieldType)) {
                bl2 = bl2 && this.processCheckField(input, automatedInstallData);
                continue;
            }
            if (STATIC_TEXT.equals(input.strFieldType) || TITLE_FIELD.equals(input.strFieldType) || DIVIDER.equals(input.strFieldType) || SPACE.equals(input.strFieldType)) {
                bl2 = bl2 && this.processSimpleField(input, automatedInstallData);
                continue;
            }
            if (!PASSWORD.equals(input.strFieldType)) continue;
            bl2 = bl2 && this.processPasswordField(input, automatedInstallData);
        }
        int n = this.askEndOfConsolePanel();
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        return this.runConsole(automatedInstallData);
    }

    public boolean collectInputs(AutomatedInstallData automatedInstallData) {
        Serializable serializable;
        this.listInputs.clear();
        IXMLElement iXMLElement = null;
        String string = automatedInstallData.panelsOrder.get(automatedInstallData.curPanelNumber).getPanelid();
        String string2 = Integer.toString(this.instanceNumber);
        SpecHelper specHelper = new SpecHelper();
        try {
            specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Vector<IXMLElement> vector = specHelper.getSpec().getChildrenNamed(NODE_ID);
        for (int i = 0; i < vector.size(); ++i) {
            IXMLElement iXMLElement2 = vector.elementAt(i);
            String string3 = iXMLElement2.getAttribute(INSTANCE_IDENTIFIER);
            String string4 = iXMLElement2.getAttribute(PANEL_IDENTIFIER);
            if ((string3 == null || !string2.equals(string3)) && (string4 == null || string == null || !string.equals(string4))) continue;
            Vector<IXMLElement> vector2 = iXMLElement2.getChildrenNamed(SELECTEDPACKS);
            serializable = iXMLElement2.getChildrenNamed(OS);
            if (!this.itemRequiredFor(vector2, automatedInstallData) || !this.itemRequiredForOs((Vector<IXMLElement>)serializable)) continue;
            iXMLElement = iXMLElement2;
            break;
        }
        if (iXMLElement == null) {
            return false;
        }
        Vector<IXMLElement> vector3 = iXMLElement.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < vector3.size(); ++i) {
            Input input;
            String string5;
            serializable = vector3.elementAt(i);
            Vector<IXMLElement> vector4 = serializable.getChildrenNamed(SELECTEDPACKS);
            Vector<IXMLElement> vector5 = serializable.getChildrenNamed(OS);
            if (!this.itemRequiredFor(vector4, automatedInstallData) || !this.itemRequiredForOs(vector5) || (string5 = serializable.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !automatedInstallData.getRules().isConditionTrue(string5, automatedInstallData.getVariables()) || (input = this.getInputFromField((IXMLElement)serializable, automatedInstallData)) == null) continue;
            this.listInputs.add(input);
        }
        return true;
    }

    boolean processSimpleField(Input input, AutomatedInstallData automatedInstallData) {
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(automatedInstallData.getVariables());
        System.out.println(variableSubstitutor.substitute(input.strText, null));
        return true;
    }

    boolean processPasswordField(Input input, AutomatedInstallData automatedInstallData) {
        Password password = (Password)input;
        boolean bl = false;
        for (int i = 0; i < password.input.length; ++i) {
            bl = this.processTextField(password.input[i], automatedInstallData);
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    boolean processTextField(Input input, AutomatedInstallData automatedInstallData) {
        Object object;
        String string = input.strVariableName;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (input.listChoices.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        String string2 = automatedInstallData.getVariable(string);
        if (string2 == null && (string2 = input.strDefaultValue) == null) {
            string2 = "";
        }
        if (string2 != null && !"".equals(string2)) {
            object = new VariableSubstitutor(automatedInstallData.getVariables());
            string2 = ((VariableSubstitutor)object).substitute(string2, null);
        }
        String string3 = input.listChoices.get((int)0).strText;
        System.out.println(string3 + " [" + string2 + "] ");
        try {
            object = new BufferedReader(new InputStreamReader(System.in));
            String string4 = ((BufferedReader)object).readLine();
            if (!string4.trim().equals("")) {
                automatedInstallData.setVariable(string, string4);
            } else {
                automatedInstallData.setVariable(string, string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    boolean processComboRadioField(Input input, AutomatedInstallData automatedInstallData) {
        String string;
        List<Choice> list;
        String string2 = input.strVariableName;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = automatedInstallData.getVariable(string2);
        boolean bl = false;
        if (input.strText != null) {
            System.out.println(input.strText);
        }
        if ((list = input.listChoices).size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        if (string3 != null) {
            bl = true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Choice choice = list.get(i);
            string = choice.strValue;
            if (bl) {
                if (string != null && string.length() > 0 && string3.equals(string)) {
                    input.iSelectedChoice = i;
                }
            } else {
                String string4 = choice.strSet;
                if (string4 != null) {
                    if (string4 != null && !"".equals(string4)) {
                        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(automatedInstallData.getVariables());
                        string4 = variableSubstitutor.substitute(string4, null);
                    }
                    if (string4.equals(TRUE)) {
                        input.iSelectedChoice = i;
                    }
                }
            }
            System.out.println(i + "  [" + (input.iSelectedChoice == i ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            boolean bl2 = true;
            while (bl2) {
                System.out.println("input selection:");
                string = bufferedReader.readLine();
                if (string.trim().equals("") && input.iSelectedChoice != -1) {
                    bl2 = false;
                }
                int n = -1;
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n < 0 || n >= list.size()) continue;
                input.iSelectedChoice = n;
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        automatedInstallData.setVariable(string2, input.listChoices.get((int)input.iSelectedChoice).strValue);
        return true;
    }

    boolean processCheckField(Input input, AutomatedInstallData automatedInstallData) {
        String string;
        List<Choice> list;
        String string2 = input.strVariableName;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = automatedInstallData.getVariable(string2);
        if (string3 == null) {
            string3 = "";
        }
        if ((list = input.listChoices).size() == 0) {
            Debug.trace("Error: no spec element defined in check field");
            return false;
        }
        Choice choice = null;
        for (int i = 0; i < list.size(); ++i) {
            choice = list.get(i);
            String string4 = choice.strValue;
            if (string4 != null && string4.length() > 0 && string3.equals(string4)) {
                input.iSelectedChoice = i;
                continue;
            }
            string = input.strDefaultValue;
            if (string == null) continue;
            if (string != null && !"".equals(string)) {
                VariableSubstitutor variableSubstitutor = new VariableSubstitutor(automatedInstallData.getVariables());
                string = variableSubstitutor.substitute(string, null);
            }
            if (!string.equals(TRUE)) continue;
            input.iSelectedChoice = 1;
        }
        System.out.println("  [" + (input.iSelectedChoice == 1 ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            boolean bl = true;
            while (bl) {
                System.out.println("input 1 to select, 0 to deseclect:");
                string = bufferedReader.readLine();
                if (string.trim().equals("")) {
                    bl = false;
                }
                int n = -1;
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 0 && n != 1) continue;
                input.iSelectedChoice = n;
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        automatedInstallData.setVariable(string2, input.listChoices.get((int)input.iSelectedChoice).strValue);
        return true;
    }

    public Input getInputFromField(IXMLElement iXMLElement, AutomatedInstallData automatedInstallData) {
        String string = iXMLElement.getAttribute(VARIABLE);
        String string2 = iXMLElement.getAttribute(TYPE_ATTRIBUTE);
        if (TITLE_FIELD.equals(string2)) {
            String string3 = null;
            string3 = iXMLElement.getAttribute(TEXT);
            return new Input(string, null, null, TITLE_FIELD, string3, 0);
        }
        if (STATIC_TEXT.equals(string2)) {
            String string4 = null;
            string4 = iXMLElement.getAttribute(TEXT);
            return new Input(string, null, null, STATIC_TEXT, string4, 0);
        }
        if (TEXT_FIELD.equals(string2) || FILE.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string5 = null;
            String string6 = null;
            String string7 = null;
            IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement3 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            if (iXMLElement2 != null) {
                string7 = iXMLElement2.getAttribute(TEXT);
                string6 = iXMLElement2.getAttribute(SET);
            }
            if (iXMLElement3 != null) {
                string5 = iXMLElement3.getAttribute(TEXT);
            }
            arrayList.add(new Choice(string7, null, string6));
            return new Input(string, string6, arrayList, string2, string5, 0);
        }
        if (RULE_FIELD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string8 = null;
            String string9 = null;
            String string10 = null;
            IXMLElement iXMLElement4 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement5 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            if (iXMLElement4 != null) {
                string10 = iXMLElement4.getAttribute(TEXT);
                string9 = iXMLElement4.getAttribute(SET);
            }
            if (iXMLElement5 != null) {
                string8 = iXMLElement5.getAttribute(TEXT);
            }
            if (string9 != null && iXMLElement4.getAttribute(LAYOUT) != null) {
                String string11;
                StringTokenizer stringTokenizer = new StringTokenizer(iXMLElement4.getAttribute(LAYOUT));
                List<String> list = Arrays.asList(new String[stringTokenizer.countTokens()]);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string9);
                while (stringTokenizer2.hasMoreTokens()) {
                    string11 = stringTokenizer2.nextToken();
                    if (string11.indexOf(":") <= -1) continue;
                    list.set(new Integer(string11.substring(0, string11.indexOf(":"))), string11.substring(string11.indexOf(":") + 1));
                }
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string12 = iXMLElement4.getAttribute(RESULT_FORMAT);
                String string13 = iXMLElement4.getAttribute(SPECIAL_SEPARATOR);
                while (stringTokenizer.hasMoreTokens()) {
                    string11 = stringTokenizer.nextToken();
                    if (string11.matches(".*:.*:.*")) {
                        stringBuffer.append(list.get(n) != null ? list.get(n) : "");
                        ++n;
                        continue;
                    }
                    if (SPECIAL_SEPARATOR.equals(string12)) {
                        stringBuffer.append(string13);
                        continue;
                    }
                    if (PLAIN_STRING.equals(string12)) continue;
                    stringBuffer.append(string11);
                }
                string9 = stringBuffer.toString();
            }
            arrayList.add(new Choice(string10, null, string9));
            return new Input(string, string9, arrayList, TEXT_FIELD, string8, 0);
        }
        if (COMBO_FIELD.equals(string2) || RADIO_FIELD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string14 = null;
            int n = -1;
            IXMLElement iXMLElement6 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement7 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            Vector<IXMLElement> vector = null;
            if (iXMLElement6 != null) {
                vector = iXMLElement6.getChildrenNamed(CHOICE);
            }
            if (iXMLElement7 != null) {
                string14 = iXMLElement7.getAttribute(TEXT);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                String string15;
                String string16;
                IXMLElement iXMLElement8 = vector.elementAt(i);
                String string17 = iXMLElement8.getAttribute("processor");
                if (string17 != null && !"".equals(string17)) {
                    string16 = "";
                    try {
                        string16 = ((Processor)Class.forName(string17).newInstance()).process(null);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    string15 = iXMLElement8.getAttribute(SET);
                    if (string15 == null) {
                        string15 = "";
                    }
                    if (string15 != null && !"".equals(string15)) {
                        object = new VariableSubstitutor(automatedInstallData.getVariables());
                        string15 = ((VariableSubstitutor)object).substitute(string15, null);
                    }
                    object = new StringTokenizer(string16, ":");
                    int n2 = 0;
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string18 = ((StringTokenizer)object).nextToken();
                        String string19 = null;
                        if (string18.equals(string15)) {
                            string19 = TRUE;
                            n = n2;
                        }
                        arrayList.add(new Choice(string18, string18, string19));
                        ++n2;
                    }
                    continue;
                }
                string16 = iXMLElement8.getAttribute(VALUE);
                string15 = iXMLElement8.getAttribute(SET);
                if (string15 != null) {
                    if (string15 != null && !"".equals(string15)) {
                        object = new VariableSubstitutor(automatedInstallData.getVariables());
                        string15 = ((VariableSubstitutor)object).substitute(string15, null);
                    }
                    if (string15.equalsIgnoreCase(TRUE)) {
                        n = i;
                    }
                }
                arrayList.add(new Choice(iXMLElement8.getAttribute(TEXT), string16, string15));
            }
            if (arrayList.size() == 1) {
                n = 0;
            }
            return new Input(string, null, arrayList, string2, string14, n);
        }
        if (CHECK_FIELD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string20 = null;
            String string21 = null;
            String string22 = null;
            int n = 0;
            IXMLElement iXMLElement9 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement10 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            if (iXMLElement9 != null) {
                string22 = iXMLElement9.getAttribute(TEXT);
                string21 = iXMLElement9.getAttribute(SET);
                arrayList.add(new Choice(string22, iXMLElement9.getAttribute("false"), null));
                arrayList.add(new Choice(string22, iXMLElement9.getAttribute(TRUE), null));
                if (string21 != null && string21.equalsIgnoreCase(TRUE)) {
                    n = 1;
                }
            } else {
                System.out.println("No spec specified for input of type check");
            }
            if (iXMLElement10 != null) {
                string20 = iXMLElement10.getAttribute(TEXT);
            }
            return new Input(string, string21, arrayList, CHECK_FIELD, string20, n);
        }
        if (SPACE.equals(string2)) {
            return SPACE_INTPUT_FIELD;
        }
        if (DIVIDER.equals(string2)) {
            return DIVIDER_INPUT_FIELD;
        }
        if (PASSWORD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string23 = null;
            String string24 = null;
            String string25 = null;
            IXMLElement iXMLElement11 = iXMLElement.getFirstChildNamed(SPEC);
            if (iXMLElement11 != null) {
                Vector<IXMLElement> vector = iXMLElement11.getChildrenNamed(PWD);
                if (vector == null || vector.size() == 0) {
                    System.out.println("No pwd specified in the spec for type password");
                    return null;
                }
                Input[] inputArray = new Input[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    IXMLElement iXMLElement12 = vector.elementAt(i);
                    string25 = iXMLElement12.getAttribute(TEXT);
                    string24 = iXMLElement12.getAttribute(SET);
                    arrayList.add(new Choice(string25, null, string24));
                    inputArray[i] = new Input(string, string24, arrayList, string2, string23, 0);
                }
                return new Password(string2, inputArray);
            }
            System.out.println("No spec specified for input of type password");
            return null;
        }
        System.out.println(string2 + " field collection not implemented");
        return null;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> vector, AutomatedInstallData automatedInstallData) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < automatedInstallData.selectedPacks.size(); ++i) {
            String string = automatedInstallData.selectedPacks.get((int)i).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute(NAME, "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).getAttribute(FAMILY);
            boolean bl = false;
            if ("windows".equals(string)) {
                bl = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(string)) {
                bl = OsVersion.IS_OSX;
            } else if ("unix".equals(string)) {
                bl = OsVersion.IS_UNIX;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static class Password
    extends Input {
        Input[] input;

        public Password(String string, Input[] inputArray) {
            super(string);
            this.input = inputArray;
        }
    }

    public static class Choice {
        String strText;
        String strValue;
        String strSet;

        public Choice(String string, String string2, String string3) {
            this.strText = string;
            this.strValue = string2;
            this.strSet = string3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Input {
        String strVariableName;
        String strDefaultValue;
        List<Choice> listChoices;
        String strFieldType;
        String strText;
        int iSelectedChoice = -1;

        public Input(String string) {
            this.strFieldType = string;
        }

        public Input(String string, String string2, List<Choice> list, String string3, String string4, int n) {
            this.strVariableName = string;
            this.strDefaultValue = string2;
            this.listChoices = list;
            this.strFieldType = string3;
            this.strText = string4;
            this.iSelectedChoice = n;
        }
    }
}

