//=============================================================================
// AVCR experiment
//
// @author Michal Bida
// @date 02/03/2008
//=============================================================================
class AVCR_Experiment extends DeathMatch;


#exec OBJ LOAD FILE=TeamSymbols_UT2003.utx
#exec OBJ LOAD FILE=TeamSymbols.utx				// needed right now for Link symbols, etc.
#exec OBJ LOAD File=AnnouncerMain.uax
#exec OBJ LOAD File=PsuAVCR.usx

replication
{

	reliable if ( Role==ROLE_Authority )
		bSecondStage, ExperimentCount;
}


var string GameClass;
var string ExperimentStartTime;

//This is used for logging used ports for bot and control server
var FileLog Logger;
var Actor FocusActor;

var Actor Goal;
var Actor Start;
var Actor Mark0;
var Actor Mark1;
var Actor Mark2;
var Actor Mark3;
var Actor Mark4;
var Actor Mark5;

var array<vector> CircleLocList;
var array<vector> StartLocList;
var array<vector> MarkLocList;
var array<rotator> MarkRotList;
var array<Actor> MarkList;

var vector ArenaMiddleGoal;
var vector ArenaMiddleReal;

var array<int> MarkPositions;
var array<int> StartPositions;

var float experiment_delay;
var float ArenaDiameter;
var float MarkHeight;

var bool bSecondStage;
var bool bSecondVariation;
var bool bExperimentKeyPressed;

var int ExperimentCount;
var int ChoosedMark;

var AVCRxPlayer Experimenter;

//This function is automaticaly called after beginning of the game
simulated function PostBeginPlay()
{

	Super.PostBeginPlay();
	FocusActor = spawn(class'AVCR.AVCR_FocusActor', self);
	FocusActor.SetDrawScale(0.2);
	FocusActor.bHidden = false;

	Goal = Spawn(class'AVCR.AVCR_Circle', self);
	Goal.SetRotation(rot(0, 32768, 0));

	Start = Spawn(class'AVCR.AVCR_Point', self);
	//Start = Spawn(class'BotAPI.FocusActorClass', self);
	//FocusActor.SetDrawScale(0.2);

	MarkList[0] = Spawn(class'AVCR.AVCR_MarkGreen1',self);
	MarkList[1] = Spawn(class'AVCR.AVCR_MarkGreen2',self);
	MarkList[2] = Spawn(class'AVCR.AVCR_MarkGreen3',self);
	MarkList[3] = Spawn(class'AVCR.AVCR_MarkRed1',self);
	MarkList[4] = Spawn(class'AVCR.AVCR_MarkRed2',self);
	MarkList[5] = Spawn(class'AVCR.AVCR_MarkRed3',self);

	InitVariables();

    //Test();
}

function InitVariables()
{

	ArenaMiddleGoal = vect(-260, 444, -310);
	ArenaMiddleReal = vect(-268, 256, 0);

	ArenaDiameter = 138.5;
	MarkHeight = -143;

	experiment_delay = 5; //(5 seconds)
	ExperimentCount = 1;
	ChoosedMark = 5;

	MarkPositions[0] = 6;
	MarkPositions[1] = 0;
	MarkPositions[2] = 7;
	MarkPositions[3] = 3;
	MarkPositions[4] = 4;
	MarkPositions[5] = 1;
	MarkPositions[6] = 5;
	MarkPositions[7] = 2;

	StartPositions[0] = 2;
	StartPositions[1] = 3;
	StartPositions[2] = 5;
	StartPositions[3] = 7;
	StartPositions[4] = 1;
	StartPositions[5] = 6;
	StartPositions[6] = 0;
	StartPositions[7] = 4;

	  /*
	  //Old Ones ( for map 02, some are working)
	MarkLocList[0]=vect(311,0,-282);
	MarkRotList[0]=rot(0, -16384, 0);

	MarkLocList[1]=vect(242,199,-282 );
	MarkRotList[1]=rot(0, -8192, 0);

	MarkLocList[2]=vect(-2, 313, -249);
	MarkRotList[2]=rot(0,0,0);

	MarkLocList[3]=vect(-200,245,-249);
	MarkRotList[3]=rot(0, 8192, 0);

	MarkLocList[4]=vect(-313,0,-266);
	MarkRotList[4]=rot(0,16384, 0);

	MarkLocList[5]=vect(-251,-186,-264);
	MarkRotList[5]=rot(0,23552,0);

	MarkLocList[6]=vect(-25,-310,-282);
	MarkRotList[6]=rot(0, 32768, 0);

	MarkLocList[7]=vect(221, -234, -272);
	MarkRotList[7]=rot(0,-23552,0);

	CircleLocList[0]=vect(78,210,-310);
	CircleLocList[1]=vect(66,260,-310);
	CircleLocList[2]=vect(-10,284,-310);
	CircleLocList[3]=vect(-74,244,-310);
	CircleLocList[4]=vect(74,160,-310);
	CircleLocList[5]=vect(-42,116,-310);
	CircleLocList[6]=vect(30,116,-310);
	CircleLocList[7]=vect(62,144,-310);
	  */
	StartLocList[0]=vect(78,210,-310);
	StartLocList[1]=vect(66,260,-310);
	StartLocList[2]=vect(-10,284,-310);
	StartLocList[3]=vect(-74,244,-310);
	StartLocList[4]=vect(74,160,-310);
	StartLocList[5]=vect(-42,116,-310);
	StartLocList[6]=vect(30,116,-310);
	StartLocList[7]=vect(62,144,-310);

	Log("AVCR Experiment Scenario Ready.");

	//New ones, for 03, 04
	MarkLocList[0]=vect(-364.999756,350.999939,-143);
	MarkRotList[0]=rot(0, 8192, 0);

	MarkLocList[1]=vect(-399.999756,248.000122,-143);
	MarkRotList[1]=rot(0, 16384, 0);

	MarkLocList[2]=vect(-360.000122, 143.999863,-143);
	MarkRotList[2]=rot(0, 24576,0);

	MarkLocList[3]=vect(-265.999908,108.999954,-143);
	MarkRotList[3]=rot(0, 32768, 0);

	MarkLocList[4]=vect(-171,146.999985,-143);
	MarkRotList[4]=rot(0, 40960, 0);

	MarkLocList[5]=vect(-127.000061,248.999939,-143);
	MarkRotList[5]=rot(0, 49152,0);

	MarkLocList[6]=vect(-161.999878,343.999695,-143);
	MarkRotList[6]=rot(0, 57344, 0);

	MarkLocList[7]=vect(-264, 390, -143);
	MarkRotList[7]=rot(0,0,0);


   	CircleLocList[0]=vect(-297,319,-241);
	CircleLocList[1]=vect(-337,267,-241);
	CircleLocList[2]=vect(-329,207,-241);
	CircleLocList[3]=vect(-281,175,-241);
	CircleLocList[4]=vect(-225,187,-241);
	CircleLocList[5]=vect(-193,231,-241);
	CircleLocList[6]=vect(-201,287,-241);
	CircleLocList[7]=vect(-245,323,-241);



	/*
   	CircleLocList[0]=vect(-336,496,-310);
	CircleLocList[1]=vect(-356,424,-310);
	CircleLocList[2]=vect(-312,360,-310);
	CircleLocList[3]=vect(-244,360,-310);
	CircleLocList[4]=vect(-188,396,-310);
	CircleLocList[5]=vect(-172,464,-310);
	CircleLocList[6]=vect(-212,520,-310);
	CircleLocList[7]=vect(-276,532,-310);
	  */

}

simulated function UpdateHeight(float newHeight)
{
	local int i;
	local vector v;

	MarkHeight = newHeight;

	for(i = 0; i < 8;i = i + 1)
	{
		MarkLocList[i].z=MarkHeight;
	}

	v.x = MarkList[ChoosedMark].Location.x;
	v.y = MarkList[ChoosedMark].Location.y;
	v.z = MarkHeight;
	MarkList[ChoosedMark].SetLocation(v);
}

simulated function Test()
{
	local StaticMeshActor A;

	foreach AllActors(class'Engine.StaticMeshActor', A,)
	{
		log("Actor is "$A);
		A.bHidden = true;
		A.bAlwaysRelevant = false;
		log("Acotr bHidden is "$A.bHidden);
	}
}

event PlayerController Login
(
    string Portal,
    string Options,
    out string Error
)
{
    local PlayerController NewPlayer;

    NewPlayer = Super.Login(Portal,Options,Error);
    if (Experimenter == none)
       Experimenter = AVCRxPlayer(NewPlayer);

    return NewPlayer;
}

//Here we store information about our game server into special file
function LogExperiment()
{
	local int i;
	local string FileName;

	Logger = Spawn(class'Engine.FileLog',self);

	FileName = Level.Year$"-"$Level.Month$"-"$Level.Day$"_"$Level.Hour$"-"$Level.Minute$"-"$Level.Second$"-Experiment_"$ExperimentCount;
	if (bSecondStage)
		FileName = FileName $ "_SecondStage";
	else
		FileName = FileName $ "_FirstStage";

	if (bSecondVariation)
		FileName = FileName $ "_130Degrees";
	else
		FileName = FileName $ "_15Degrees";

	Logger.OpenLog(FileName);

	Logger.Logf("ExperimentStart: "$ExperimentStartTime);
	Logger.Logf("ExperimentEnd: "$Level.Year$"/"$Level.Month$"/"$Level.Day$" "$Level.Hour$":"$Level.Minute$":"$Level.Second$":"$Level.MilliSecond);
	Logger.Logf("ExperimentSecondStage: "$bSecondStage);
	Logger.Logf("Experiment130Degrees: "$bSecondVariation);

	Logger.Logf("PlayerEndPosition: "$Experimenter.Pawn.Location);
	Logger.Logf("GoalPosition: "$Goal.Location);
	Logger.Logf("StartPosition: "$Start.Location);

	Logger.Logf("//------------------------//");
	Logger.Logf("//------------------------//");
	Logger.Logf("PlayerPath: ");
	for (i = 0;i < Experimenter.PlayerPosList.Length; i=i+1 )
	{
		Logger.Logf(string(Experimenter.PlayerPosList[i]));
	}

	Logger.CloseLog();
	Logger.Destroy();

	Broadcast(self,"Log written to UT2004/UserLogs/"$FileName$".log");

	ConsoleCommand("flush", True);

}

simulated function Tick(float DeltaTime)
{
	local Controller C;

	super.Tick(DeltaTime);
	//log("DeltaTime is "$DeltaTime);
	for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer'))
		{
			if (C.Pawn != none)
			{
			    FocusActor.SetLocation(C.Pawn.Location);
			}
		}
	}
}

state ExperimentStart
{
Begin:
FirstStage:
	//log("ExperimentStart");
	Broadcast(self,"Prepare for new experiment round, FIRST STAGE");
	sleep(1);
	Broadcast(self,"Experiment INITIATING");
	InitExperiment();
	Start.bHidden = false;
	bExperimentKeyPressed = false;
	sleep(1);
	Broadcast(self,"Confirm you have reached red dot by pressing the HOME key");
WaitingForReachingStart1:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForReachingStart1';
	Start.bHidden = true;
	Goal.bHidden = false;
	MarkList[ChoosedMark].bHidden = false;
	Broadcast(self,"Red dot reached, for experiment start press HOME key");
	bExperimentKeyPressed = false;
WaitingForStart1:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForStart1';
	ExperimentStarted();
	gotoState('ExperimentRunning','Begin');
SecondStage:
	Broadcast(self,"Prepare for new experiment round, SECOND STAGE");
	sleep(1);
	Broadcast(self,"Experiment INITIATING");
	InitExperiment();
	Start.bHidden = false;
	bExperimentKeyPressed = false;
	sleep(1);
	Broadcast(self,"Confirm you have reached red dot by pressing the HOME key");
WaitingForReachingStart2:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForReachingStart2';
	Start.bHidden = true;
	MarkList[ChoosedMark].bHidden = false;
	Broadcast(self,"Red dot reached, for experiment start press HOME key");
	bExperimentKeyPressed = false;
WaitingForStart2:
	sleep(0.2);
	if (!bExperimentKeyPressed)
		goto 'WaitingForStart2';
	ExperimentStarted();
	gotoState('ExperimentRunning','Begin');
}

state ExperimentRunning
{

Begin:
	//log("ExperimentRunning");
	Broadcast(self,"Experiment RUNNING");
	sleep(1.0);
	Broadcast(self,"When you think you've reached the goal, press HOME key");
Running:
	sleep(1.0);
	goto 'Running';
}

state ExperimentEnd
{
Begin:
	//log("ExperimentEnd");
	Broadcast(self,"Experiment ENDED");
	ExperimentEnded();
	sleep(2);
End:
	Broadcast(self,"For switching from FIRST to SECOND stage or vice versa press END key");
	sleep(1);
	Broadcast(self,"Waiting for HOME key to be pressed for a new round");
Waiting:
	sleep(1.0);
	goto 'Waiting';

}

function InitExperiment()
{
	local int i,k,l,a;
	local rotator angle;
	local vector GoalPosition, temp, RealPosDirection, vec15, vec130, usedvec;

	if (ExperimentCount > 8)
		ExperimentCount = 1;

	i = MarkPositions[ExperimentCount];
	l = StartPositions[ExperimentCount];

    for( k = 0; k < MarkList.Length; k = k + 1 )
	{
		MarkList[k].bHidden = true;
	}

	Goal.bHidden = true;
	Start.bHidden = true;

   	MarkList[ChoosedMark].SetLocation(MarkLocList[i]);
	MarkList[ChoosedMark].SetRotation(MarkRotList[i]);

	Start.SetLocation(MarkLocList[l]);
	Start.SetRotation(MarkRotList[l]);

	vec130 = vect(-1,1.19,0);
	vec15 = vect(1,0.268,0);

	if (bSecondVariation)
	{
		//angle = rot(23673, 0, 0); //130 degrees

		Goal.SetLocation(CircleLocList[(i+3)%8]);
	}
	else
	{
		Goal.SetLocation(CircleLocList[(i+1)%8]);
	}

	//RealPosDirection += Normal(usedvec) * (RealPosDirection dot Normal(usedvec)) * -1;
    //RealPosDirection = Normal(Normal(RealPosDirection * (1 - (a / 90) ) ) + (Normal(RealPosDirection cross vect(0, 0, 1)) * (a / 90)));

 	log("Goal is "$Goal$" location: "$Goal.Location);
	log("Mark is "$MarkList[ChoosedMark]$" location: "$MarkList[ChoosedMark].Location);


		/*	angle = rot(2731, 0, 0); //15 degrees
		temp.x = MarkLocList[i].x;
		temp.y = MarkLocList[i].y;
		temp.z = 0;

		RealPosDirection = vector(rotator(temp - ArenaMiddleReal) + angle);
		GoalPosition = ArenaMiddleReal + RealPosDirection * 0.6 * ArenaDiameter;
		GoalPosition.z = -241;
   		Goal.SetLocation(GoalPosition);
   		*/
}

function ExperimentStarted()
{
	local Controller C;

    ExperimentStartTime = Level.Year$"/"$Level.Month$"/"$Level.Day$" "$Level.Hour$":"$Level.Minute$":"$Level.Second$":"$Level.MilliSecond;
	Goal.bHidden = true;
	Experimenter.bExperimentOn = true;
	Experimenter.gotoState('PlayerWalking','Running');
	Experimenter.NotifyClient();
	/*
    for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer') && !C.PlayerReplicationInfo.bIsSpectator)
		{

			AVCRxPlayer(C).bExperimentOn = true;
			AVCRxPlayer(C).gotoState('PlayerWalking','Running');
			AVCRxPlayer(C).NotifyClient();
			BroadCast(self,"Controller "$C.PlayerReplicationInfo.PlayerName);
		}
	}*/
}

function ExperimentEnded()
{
	local Controller C;

	if (!bSecondStage)
		Goal.bHidden = false;
	LogExperiment();
	Experimenter.bExperimentOn = false;
	Experimenter.gotoState('PlayerWalking','Waiting');
	Experimenter.NotifyClient();
	Experimenter.PlayerPosList.Length = 0;
	/*
    for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('AVCRxPlayer') && !C.PlayerReplicationInfo.bIsSpectator)
		{
			AVCRxPlayer(C).bExperimentOn = false;
			AVCRxPlayer(C).gotoState('PlayerWalking','Waiting');
			AVCRxPlayer(C).NotifyClient();
			AVCRxPlayer(C).PlayerPosList.Length = 0;
		}
	}*/
   	ExperimentCount += 1;
}

//Prevents epic bots from automatically joining the game
function bool NeedPlayers()
{
	return false;
}

//Prevents epic bots from automatically joining the game
function bool BecomeSpectator(PlayerController P)
{
	if ( !Super.BecomeSpectator(P) )
		return false;

	return true;
}

defaultproperties
{
	NetWait=2
	CountDown=0
	bPauseable=True
	TimeLimit=40
	DefaultEnemyRosterClass="XGame.xDMRoster"
	PlayerControllerClassName="AVCR.AVCRxPlayer"
	DefaultPlayerClassName="AVCR.AVCRxPawn"
	DecoTextName="XGame.DeathMatch"
	HUDType="xInterface.HudCDeathmatch"
	GameName="AVCR Experiment"
	GameClass="BotDeathMatch"
	Acronym="AVCR"
	MapPrefix="DM"
	RemoteRole=ROLE_AutonomousProxy

}
