package cz.cuni.pogamut.cup2013.match;

import java.io.File;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;

/**
 * Class that performs match between Pogamut-Bot and UT2004-Native-Bot.
 * 
 * <p><p>
 * Just adjust bot's/match's constants and run this file.
 * 
 * <p><p>
 * Note that the match will auto-run its own UCC (GameBots2004 instance).
 * If you wish to observe what's going on in the match, just connect to 127.0.0.1 via
 * UT2004 console to it (start UT2004, press '~' to open the console, type command 'open 127.0.0.1' without entailing apostrophes).
 * 
 * <p><p>
 * If you want to use YOUR bot, you have to
 * <ol>
 *   <li>executes 'mvn package' shell command in the directory of your DMBot (in the directory that contains 'pom.xml' file of the DMBot project).</li>
 *   <li>alter {@link DMMatch1vNative#BOT_1_PATH_TO_JAR} to point to result '${DMBotProjectDir}/target/xxx.one-jar.jar' file</li>
 * </ol>
 * 
 * <p><p>
 * You may use rk Demo Watcher for watching UT2004 replays, see: http://www.pumpt.net/rK_DemoWatcher/Finest_demowatching_since_2004.html
 * 
 * <p><p>
 * <b>PITFALLS</b>
 * <ol>
 * 	 <li>Bot from my one-jar is not working - check your bot project's pom.xml whether 'bot.main.class' property is correctly filled.</li>
 * </ol>
 * 
 * @author Jakub Gemrot aka Jimmy
 */
public class DMMatch1vNative {

	// =============
	// UT2004 CONFIG
	// =============
	
	/**
	 * Full path to directory that contains UT2004 installation with GameBots2004.
	 */
	public static final String UT2004_HOME = "D:\\Games\\UT2004-Devel";
	
	// ===============
	// DM MATCH CONFIG
	// ===============
	
	/**
	 * Map to be used for the match. For complete list see $UT2004_HOME/Maps,
	 * you can try antyhing prefixed with "DM-".
	 * 
	 * 
	 * PogamutCup matches are going to be played on:
	 * 1st match: DM-1on1-Roughinery-FPS
	 * 2nd match: DM-1on1-Solitude
	 * 3rd match: DM-1on1-Backspace
	 */
	public static final String MATCH_MAP_NAME = "DM-1on1-Roughinery-FPS";
	
	/**
	 * How many frags in the match means victory. 
	 * 
	 * PogamutCup matches will be played for 10 frags.
	 */
	public static final int MATCH_FRAG_TARGET = 10;

	/**
	 * Defines time limit for the game in minutes. The game will end after the specified number of minutes
	 * if frag limit is not reached by neither of bots.
	 * 
	 * PogamutCup matches will be played for 10 minutes max.
	 */
	public static final int MATCH_TIME_LIMIT_IN_MINUTES = 10;
	
	/**
	 * Path to the directory (if does not exist, will be auto-created) where the match will store results, replay and match statistics.
	 */
	public static final String MATCH_OUTPUT_FOLDER_PATH = "./results";
	
	// ====================
	// POGAMUT BOT 1 CONFIG
	// ====================
	
	/**
	 * Defines name of the first bot, this identifier will be used in generated statistics.
	 */
	public static final String BOT_1_NAME = "DMBot";
	
	/**
	 * Defines full path to the jar that contains the first bot. The jar must be executable, i.e., it contains
	 * all libraries embedded (fortunately all Pogamut-Bot projects are auto-generating such jars ;-), just execute 'mvn package' on the project 
	 * and see 'target' folder, you will find 'one-jar' there containing the bot with all dependencies).
	 * <p><p>
	 * WARNING: this .jar is not auto-updating, if you want test your DMBot, you have to rebuild one-jar (that 'mvn package' command executed in the folder of DMBot project).
	 */
	public static final String BOT_1_PATH_TO_JAR = "../DMBot-Template/target/pogamut-cup-2013-dm-bot-3.5.0.one-jar.jar";
	//public static final String BOT_1_PATH_TO_JAR = "./bots/ut2004-04-hunter-bot-3.5.1-SNAPSHOT.one-jar.jar";
	//public static final String BOT_1_PATH_TO_JAR = "./bots-2012/adam_heinrich_cvut-1.0-SNAPSHOT.one-jar.jar";
	//public static final String BOT_1_PATH_TO_JAR = "./bots-2012/deset_ran_do_cepice_zcu-1.0-SNAPSHOT.one-jar.jar";
	//public static final String BOT_1_PATH_TO_JAR = "./bots-2012/frei_and_gauner_zcu-1.0-SNAPSHOT.one-jar.jar";
	//public static final String BOT_1_PATH_TO_JAR = "./bots-2012/gladiatorBot-0.0.1.one-jar.jar";
	
	// ==========================
	// NATIVE UT2004 BOT 2 CONFIG
	// ==========================
	
	/**
	 * Defines name of the first bot, this identifier will be used in generated statistics.
	 */
	public static final String BOT_2_NAME = "NativeBot";
	
	/**
	 * Defines skill-level of the native bot. PogamutCup is using '5'.
	 */
	public static final int BOT_2_SKILL_LEVEL = 5;

	// ===================
	// MATCH CONFIGURATION
	// ===================
	
	public UT2004DeathMatchConfig createMatchConfig() {
		UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();
		
		matchConfig.setMatchId("DMMatch1vNative");
		matchConfig.setOutputDirectory(new File(MATCH_OUTPUT_FOLDER_PATH));
				
		matchConfig.setFragLimit(MATCH_FRAG_TARGET);
		matchConfig.setTimeLimit(MATCH_TIME_LIMIT_IN_MINUTES);
		
		matchConfig.getUccConf().setStartOnUnusedPort(true);
		matchConfig.getUccConf().setUnrealHome(UT2004_HOME);
		matchConfig.getUccConf().setGameType("BotDeathMatch");
		matchConfig.getUccConf().setMapName(MATCH_MAP_NAME);
		
		UT2004BotConfig botConfig;
		
		botConfig = new UT2004BotConfig();
		botConfig.setBotId(BOT_1_NAME);
		botConfig.setPathToBotJar(BOT_1_PATH_TO_JAR);
		botConfig.setTeamNumber(255);
		botConfig.setRedirectStdErr(true);
		botConfig.setRedirectStdOut(true);		
		matchConfig.addBot(botConfig);
		
		UT2004NativeBotConfig nativeBotConfig;
		
		nativeBotConfig = new UT2004NativeBotConfig();
		nativeBotConfig.setBotId(BOT_2_NAME);
		nativeBotConfig.setSkillLevel(BOT_2_SKILL_LEVEL);
		nativeBotConfig.setTeamNumber(255);
		matchConfig.addNativeBot(nativeBotConfig);
		
		return matchConfig;
	}
	
	// =============
	// MATCH CREATOR
	// =============
	
	public UT2004DeathMatch createMatch() {
		LogCategory log = new LogCategory("DMMatch1vNative");
		UT2004DeathMatch match = new UT2004DeathMatch(createMatchConfig(), log);
		return match;
	}
	
	// ============
	// MATCH RUNNER
	// ============
	
	public void run() {
		UT2004DeathMatch match = createMatch();
		match.run();
	}
	
	
	// ===========
	// MAIN METHOD
	// ===========
	
	public static void main(String[] args) {
		try {
			// CONSTRUCT THE MATCH
			DMMatch1vNative match = new DMMatch1vNative();
		
			// EXECUTE THE MATCH (blocking method)
			match.run();
		} finally {
			// CLEAN UP
			Pogamut.getPlatform().close();
		}
	}
	
}
