package cz.cuni.pogamut.cup2013.match;

import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchRepeater;

/**
 * Class that repeats {@link DMMatch1v1} {@link DMMatch1v1Repeater#REPEAT_COUNT} times.
 * 
 * <p><p>
 * Just adjust bot's/match's constants within {@link DMMatch1v1} and run this file to automatically (sequentially) execute the match {@link DMMatch1v1Repeater#REPEAT_COUNT} times. 
 * 
 * <p><p>
 * Note that the match will auto-run its own UCC (GameBots2004 instance).
 * If you wish to observe what's going on in the match, just connect to 127.0.0.1 via
 * UT2004 console to it (start UT2004, press '~' to open the console, type command 'open 127.0.0.1' without entailing apostrophes).
 * 
 * @author Jakub Gemrot aka Jimmy
 */
public class DMMatch1v1Repeater {
	
	/**
	 * How many times we should execute configuration from {@link DMMatch1v1}.
	 */
	public static final int REPEAT_COUNT = 3;
	
	// ============
	// MATCH RUNNER
	// ============
	
	public void run() {
		DMMatch1v1 matchTemplate = new DMMatch1v1();
		UT2004DeathMatchConfig matchConfig = matchTemplate.createMatchConfig();
		
		UT2004DeathMatchRepeater repeater = new UT2004DeathMatchRepeater(matchConfig, REPEAT_COUNT, new LogCategory("DMMatch1v1Repeater"));
		repeater.getLog().addConsoleHandler();
		repeater.getLog().setLevel(Level.INFO);
		repeater.run();
	}
	
	// ===========
	// MAIN METHOD
	// ===========
	
	public static void main(String[] args) {
		try {
			// CONSTRUCT THE MATCH
			DMMatch1v1Repeater match = new DMMatch1v1Repeater();
		
			// EXECUTE THE MATCH (blocking method)
			match.run();
		} finally {
			// CLEAN UP
			Pogamut.getPlatform().close();
		}
		
	}

}
