package cz.cuni.pogamut.cup2013.bot;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;

/**
 * Class containing adjustments for navigation graph of PogamutCup competition maps.
 * 
 * @author Jimmy
 */
public class MapTweaks {

	/**
	 * Called from {@link DMBot#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}.
	 * @param navBuilder
	 */
	public static void tweak(NavigationGraphBuilder navBuilder) {
		if (navBuilder.isMapName("DM-1on1-Backspace")) tweakDM1on1Backspace(navBuilder);
		else
		if (navBuilder.isMapName("DM-1on1-Roughinery-FPS")) tweakDM1on1RoughineryFPS(navBuilder);
		else
		if (navBuilder.isMapName("DM-1on1-Solitude")) tweakDM1on1Solitude(navBuilder);
	}

	// =================
	// DM-1on1-Backspace
	// =================
	
	private static void tweakDM1on1Backspace(NavigationGraphBuilder navBuilder) {
		navBuilder.removeEdge("LiftCenter0", "LiftExit1");
		navBuilder.removeEdge("LiftCenter0", "LiftExit2");
		navBuilder.removeEdge("LiftCenter0", "LiftExit3");
		navBuilder.removeEdge("InventorySpot72", "PathNode93");
		navBuilder.removeEdge("PathNode91", "InventorySpot25");
		navBuilder.removeEdge("PathNode91", "InventorySpot27");
		navBuilder.removeEdge("PathNode8", "JumpSpot4");
	}

	// ======================
	// DM-1on1-Roughinery-FPS
	// ======================
	
	private static void tweakDM1on1RoughineryFPS(NavigationGraphBuilder navBuilder) {
		navBuilder.removeEdge("PathNode5", "PathNode26");
		navBuilder.removeEdge("JumpSpot0", "PathNode74");
		navBuilder.removeEdge("LiftCenter0", "LiftExit2");
		
	}

	// =================
	// DM-1on1-Solitude
	// =================
	
	private static void tweakDM1on1Solitude(NavigationGraphBuilder navBuilder) {
		navBuilder.removeEdge("LiftCenter2", "LiftExit1");
		navBuilder.removeEdge("PathNode10", "PathNode93");
	}
	
}
