/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.CheckBoxNodeRenderer;
import com.izforge.izpack.panels.CheckTreeController;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreePacksPanel
extends IzPanel
implements PacksPanelInterface {
    private static final long serialVersionUID = 5684716698930628262L;
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTree packsTree;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private HashMap<String, Pack> idToPack;
    private HashMap<String, ArrayList<String>> treeData;
    private HashMap<Pack, Integer> packToRowNumber;
    private HashMap<String, CheckBoxNode> idToCheckBoxNode = new HashMap();
    private CheckTreeController checkTreeController;
    boolean doNotShowPackSize;

    public TreePacksPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        try {
            this.langpack = installerFrame.langpack;
            InputStream inputStream = null;
            String string = installData.info.getWebDirURL();
            if (string != null) {
                try {
                    URL uRL = new URL(string + "/langpacks/" + LANG_FILE_NAME + installData.localeISO3);
                    inputStream = new WebAccessor(null).openInputStream(uRL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                inputStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            }
            this.langpack.add(inputStream);
            inputStream.close();
        }
        catch (Throwable throwable) {
            Debug.trace(throwable);
        }
        this.doNotShowPackSize = Boolean.parseBoolean(installData.guiPrefs.modifier.get("doNotShowPackSizeColumn"));
        this.computePacks(installData.availablePacks);
    }

    protected void createNormalLayout() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.createLabel("PacksPanel.info", "preferences", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        this.createLabel("PacksPanel.tip", "tip", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.tableScroller = new JScrollPane();
        this.packsTree = this.createPacksTree(300, this.tableScroller, null, null);
        if (this.dependenciesExist) {
            this.dependencyArea = this.createTextArea("PacksPanel.dependencyList", null, null, null);
        }
        this.descriptionArea = this.createTextArea("PacksPanel.description", null, null, null);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", null, null);
        if (IoHelper.supported("getFreeSpace")) {
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", null, null);
        }
    }

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long l) {
        this.bytes = l;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            String string = null;
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.idata.getInstallPath())).getAbsolutePath());
            string = this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString(this.freeBytes);
            this.freeSpaceLabel.setText(string);
        }
    }

    public Debugger getDebugger() {
        return null;
    }

    public boolean isValidated() {
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        new ImgPacksPanelAutomationHelper().makeXMLData(this.idata, iXMLElement);
    }

    private String getI18NPackName(Pack pack) {
        String string = pack.name;
        String string2 = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            string = this.langpack.getString(string2);
        }
        if ("".equals(string) || string2 == null || string2.equals(string)) {
            string = pack.name;
        }
        return string;
    }

    public String getI18NPackName(String string) {
        Pack pack = this.idToPack.get(string);
        if (pack == null) {
            return string;
        }
        return this.getI18NPackName(pack);
    }

    protected JLabel createLabel(String string, String string2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = LabelFactory.create(this.parent.langpack.getString(string), this.parent.icons.getImageIcon(string2), 11);
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        }
        this.add(jLabel);
        return jLabel;
    }

    protected JLabel createPanelWithLabel(String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        if (jLabel == null) {
            jLabel = new JLabel("");
        }
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(LabelFactory.create(this.parent.langpack.getString(string)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jLabel);
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jPanel, gridBagConstraints);
        }
        this.add(jPanel);
        return jLabel;
    }

    private void refreshPacksToInstall() {
        this.idata.selectedPacks.clear();
        CheckBoxNode checkBoxNode = (CheckBoxNode)this.getTree().getModel().getRoot();
        Enumeration<TreeNode> enumeration = checkBoxNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
            if (!checkBoxNode2.isSelected() && !checkBoxNode2.isPartial()) continue;
            this.idata.selectedPacks.add(checkBoxNode2.getPack());
        }
    }

    protected JTextArea createTextArea(String string, JScrollPane jScrollPane, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setAlignmentX(0.0f);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(string)));
        jTextArea.setFont(this.getControlTextFont());
        if (gridBagLayout != null && gridBagConstraints != null) {
            if (jScrollPane != null) {
                gridBagLayout.addLayoutComponent(jScrollPane, gridBagConstraints);
            } else {
                gridBagLayout.addLayoutComponent(jTextArea, gridBagConstraints);
            }
        }
        if (jScrollPane != null) {
            jScrollPane.setViewportView(jTextArea);
            this.add(jScrollPane);
        } else {
            this.add(jTextArea);
        }
        jTextArea.setPreferredSize(new Dimension(500, 10));
        return jTextArea;
    }

    protected JTree createPacksTree(int n, JScrollPane jScrollPane, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JTree jTree;
        this.packsTree = jTree = new JTree((CheckBoxNode)this.populateTreePacks(null));
        jTree.setCellRenderer(new CheckBoxNodeRenderer(this, !this.doNotShowPackSize));
        jTree.setEditable(false);
        jTree.setShowsRootHandles(true);
        jTree.setRootVisible(false);
        this.checkTreeController = new CheckTreeController(this);
        jTree.addMouseListener(this.checkTreeController);
        jTree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jTree.setBackground(Color.white);
        jTree.setToggleClickCount(0);
        jScrollPane.setViewportView(jTree);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.setPreferredSize(new Dimension(n, this.idata.guiPrefs.height / 3 + 30));
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jScrollPane, gridBagConstraints);
        }
        this.add(jScrollPane);
        return jTree;
    }

    private void computePacks(List list) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Object e : list) {
            Pack pack = (Pack)e;
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void fromModel() {
        TreeModel treeModel = this.packsTree.getModel();
        CheckBoxNode checkBoxNode = (CheckBoxNode)treeModel.getRoot();
        this.updateModel(checkBoxNode);
    }

    private int getRowIndex(Pack pack) {
        Integer n = this.packToRowNumber.get(pack);
        if (n == null) {
            return -1;
        }
        Integer n2 = n;
        return n2;
    }

    private void updateModel(CheckBoxNode checkBoxNode) {
        Object object;
        int n = this.getRowIndex(checkBoxNode.getPack());
        if (n >= 0 && (Integer)(object = (Integer)this.packsModel.getValueAt(n, 0)) == -2 && checkBoxNode.getChildCount() > 0) {
            boolean bl = false;
            Enumeration<TreeNode> enumeration = checkBoxNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                CheckBoxNode checkBoxNode2 = (CheckBoxNode)enumeration.nextElement();
                boolean bl2 = checkBoxNode2.isSelected() || checkBoxNode2.isPartial() || checkBoxNode2.isEnabled();
                boolean bl3 = bl = bl || bl2;
                if (!bl2) continue;
                checkBoxNode2.setPartial(false);
                checkBoxNode2.setSelected(false);
                checkBoxNode2.setEnabled(false);
                this.setModelValue(checkBoxNode2);
            }
            if (bl) {
                this.fromModel();
            }
            return;
        }
        object = checkBoxNode.children();
        while (object.hasMoreElements()) {
            int n2;
            Object e = object.nextElement();
            CheckBoxNode checkBoxNode3 = (CheckBoxNode)e;
            String string = checkBoxNode3.getId();
            Pack pack = this.idToPack.get(string);
            if (!checkBoxNode3.isPartial() && (n2 = this.getRowIndex(pack)) >= 0) {
                Integer n3 = (Integer)this.packsModel.getValueAt(n2, 0);
                checkBoxNode3.setEnabled(n3 >= 0);
                checkBoxNode3.setSelected(Math.abs(n3) == 1);
            }
            this.updateModel(checkBoxNode3);
        }
    }

    public void setModelValue(CheckBoxNode checkBoxNode) {
        Integer n;
        Integer n2;
        int n3;
        String string = checkBoxNode.getId();
        Pack pack = this.idToPack.get(string);
        int n4 = 0;
        if (checkBoxNode.isEnabled() && checkBoxNode.isSelected()) {
            n4 = 1;
        }
        if (!checkBoxNode.isEnabled() && checkBoxNode.isSelected()) {
            n4 = -1;
        }
        if (!checkBoxNode.isEnabled() && !checkBoxNode.isSelected()) {
            n4 = -2;
        }
        if ((n3 = this.getRowIndex(pack)) >= 0 && !(n2 = Integer.valueOf(n4)).equals(n = (Integer)this.packsModel.getValueAt(n3, 0))) {
            this.packsModel.setValueAt(n2, n3, 0);
        }
    }

    private void createTreeData() {
        this.treeData = new HashMap();
        this.idToPack = new HashMap();
        for (Pack pack : this.idata.availablePacks) {
            this.idToPack.put(pack.id, pack);
            if (pack.parent == null) continue;
            ArrayList<String> arrayList = null;
            arrayList = this.treeData.containsKey(pack.parent) ? this.treeData.get(pack.parent) : new ArrayList<String>();
            arrayList.add(pack.id);
            this.treeData.put(pack.parent, arrayList);
        }
    }

    public void setDescription(String string) {
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        if (this.descriptionArea != null) {
            Pack pack = this.idToPack.get(string);
            String string2 = "";
            String string3 = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                string2 = this.langpack.getString(string3);
            }
            if ("".equals(string2) || string3.equals(string2)) {
                string2 = pack.description;
            }
            string2 = variableSubstitutor.substitute(string2, null);
            this.descriptionArea.setText(string2);
        }
    }

    public void setDependencies(String string) {
        if (this.dependencyArea != null) {
            Pack pack = this.idToPack.get(string);
            List<String> list = pack.dependencies;
            String string2 = "";
            if (list != null) {
                string2 = string2 + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            for (int i = 0; list != null && i < list.size(); ++i) {
                String string3 = list.get(i);
                string2 = string2 + this.getI18NPackName(this.names.get(string3));
                if (i == list.size() - 1) continue;
                string2 = string2 + ", ";
            }
            String string4 = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int n = 0;
            int n2 = this.getRowIndex(pack);
            if (pack.excludeGroup != null) {
                for (int i = 0; i < this.idata.availablePacks.size(); ++i) {
                    Pack pack2 = (Pack)this.idata.availablePacks.get(i);
                    String string5 = pack2.excludeGroup;
                    if (string5 == null || i == n2 || !pack.excludeGroup.equals(string5)) continue;
                    string4 = string4 + this.getI18NPackName(pack2) + ", ";
                    ++n;
                }
            }
            if (list != null) {
                string4 = "    " + string4;
            }
            if (n > 0) {
                string2 = string2 + string4;
            }
            if (string2.endsWith(", ")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            this.dependencyArea.setText(string2);
        }
    }

    public CheckBoxNode getCbnById(String string) {
        return this.idToCheckBoxNode.get(string);
    }

    private Object populateTreePacks(String string) {
        if (string == null) {
            Serializable serializable;
            Iterator iterator = this.idata.availablePacks.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                serializable = (Pack)iterator.next();
                if (serializable.parent != null || serializable.isHidden()) continue;
                arrayList.add(this.populateTreePacks(serializable.id));
            }
            serializable = new CheckBoxNode("Root", "Root", arrayList.toArray(), true);
            return serializable;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = this.treeData.get(string);
        Pack pack = this.idToPack.get(string);
        String string2 = this.getI18NPackName(string);
        if (arrayList2 != null) {
            ArrayList<String> arrayList3 = arrayList2;
            Object object = arrayList3.iterator();
            while (object.hasNext()) {
                String string3;
                String string4 = string3 = object.next();
                arrayList.add(this.populateTreePacks(string4));
            }
            object = new CheckBoxNode(string, string2, arrayList.toArray(), true);
            this.idToCheckBoxNode.put(((CheckBoxNode)object).getId(), (CheckBoxNode)object);
            ((CheckBoxNode)object).setPack(pack);
            ((CheckBoxNode)object).setTotalSize(pack.nbytes);
            return object;
        }
        CheckBoxNode checkBoxNode = new CheckBoxNode(string, string2, true);
        this.idToCheckBoxNode.put(checkBoxNode.getId(), checkBoxNode);
        checkBoxNode.setPack(pack);
        checkBoxNode.setTotalSize(pack.nbytes);
        return checkBoxNode;
    }

    public void panelActivate() {
        try {
            Serializable serializable;
            this.packsModel = new PacksModel(this, this.idata, this.parent.getRules()){
                private static final long serialVersionUID = 697462278279845304L;

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.packToRowNumber = new HashMap();
            Iterator iterator = this.idata.availablePacks.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                serializable = (Pack)iterator.next();
                if (serializable.isHidden()) continue;
                this.packToRowNumber.put((Pack)serializable, n++);
            }
            this.createTreeData();
            this.createNormalLayout();
            this.fromModel();
            serializable = (CheckBoxNode)this.packsTree.getModel().getRoot();
            this.checkTreeController.updateAllParents((CheckBoxNode)serializable);
            CheckTreeController.initTotalSize((CheckBoxNode)serializable, false);
            this.packsTree.revalidate();
            this.packsTree.repaint();
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iterator2 = this.idata.availablePacks.iterator();
            this.bytes = 0L;
            while (iterator2.hasNext()) {
                Pack pack = (Pack)iterator2.next();
                if (pack.required) {
                    this.bytes += pack.nbytes;
                    continue;
                }
                if (!this.idata.selectedPacks.contains(pack)) continue;
                this.bytes += pack.nbytes;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
    }

    public String getSummaryBody() {
        StringBuffer stringBuffer = new StringBuffer(256);
        Iterator iterator = this.idata.selectedPacks.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append("<br>");
            }
            bl = false;
            Pack pack = (Pack)iterator.next();
            stringBuffer.append(this.getI18NPackName(pack));
        }
        return stringBuffer.toString();
    }

    public JTree getTree() {
        return this.packsTree;
    }
}

