/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.panels.JDKPathPanel;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class JDKPathPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private String minVersion;
    private String maxVersion;
    private String variableName;
    private String detectedVersion;

    public boolean runGeneratePropertiesFile(AutomatedInstallData automatedInstallData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    public boolean runConsoleFromPropertiesFile(AutomatedInstallData automatedInstallData, Properties properties) {
        String string = properties.getProperty("INSTALL_PATH");
        if (string == null || "".equals(string.trim())) {
            System.err.println("Inputting the target path is mandatory!!!!");
            return false;
        }
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(automatedInstallData.getVariables());
        string = variableSubstitutor.substitute(string, null);
        automatedInstallData.setInstallPath(string);
        return true;
    }

    public boolean runConsole(AutomatedInstallData automatedInstallData) {
        this.minVersion = automatedInstallData.getVariable("JDKPathPanel.minVersion");
        this.maxVersion = automatedInstallData.getVariable("JDKPathPanel.maxVersion");
        this.variableName = "JDKPath";
        String string = "";
        String string2 = automatedInstallData.getVariable(this.variableName);
        if (string2 == null) {
            string2 = OsVersion.IS_OSX ? "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home/" : new File(automatedInstallData.getVariable("JAVA_HOME")).getParent();
        }
        if (!(JDKPathPanelConsoleHelper.pathIsValid(string2) && this.verifyVersion(this.minVersion, this.maxVersion, string2) || JDKPathPanelConsoleHelper.pathIsValid(string2 = this.resolveInRegistry(this.minVersion, this.maxVersion)) && this.verifyVersion(this.minVersion, this.maxVersion, string2))) {
            string2 = "";
        }
        boolean bl = true;
        while (bl) {
            String string3;
            System.out.println("Select JDK path [" + string2 + "] ");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                string3 = bufferedReader.readLine();
                string = !string3.trim().equals("") ? string3.trim() : string2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!JDKPathPanelConsoleHelper.pathIsValid(string)) {
                System.out.println("Path " + string + " is not valid.");
            } else if (!this.verifyVersion(this.minVersion, this.maxVersion, string)) {
                System.out.println("The chosen JDK has the wrong version (available: " + this.detectedVersion + " required: " + this.minVersion + " - " + this.maxVersion + ").");
                System.out.println("Continue anyway? [no]");
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    string3 = bufferedReader.readLine();
                    if (string3.trim().toLowerCase().equals("y") || string3.trim().toLowerCase().equals("yes")) {
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                bl = false;
            }
            automatedInstallData.setVariable(this.variableName, string);
        }
        int n = this.askEndOfConsolePanel();
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        return this.runConsole(automatedInstallData);
    }

    private static boolean pathIsValid(String string) {
        for (String string2 : JDKPathPanel.testFiles) {
            File file = new File(string, string2).getAbsoluteFile();
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private boolean verifyVersion(String string, String string2, String string3) {
        String string4;
        String[] stringArray;
        boolean bl = true;
        if (string == null && string2 == null) {
            return true;
        }
        String[] stringArray2 = System.getProperty("os.name").indexOf("Windows") >= 0 ? (stringArray = new String[]{"cmd", "/c", string3 + File.separator + "bin" + File.separator + "java", "-version"}) : (stringArray = new String[]{string3 + File.separator + "bin" + File.separator + "java", "-version"});
        stringArray = new String[2];
        FileExecutor fileExecutor = new FileExecutor();
        fileExecutor.executeCommand(stringArray2, stringArray);
        String string5 = string4 = stringArray[0].length() > 0 ? stringArray[0] : stringArray[1];
        if (string != null && !this.compareVersions(string4, string, true, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            bl = false;
        }
        if (string2 != null && !this.compareVersions(string4, string2, false, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            bl = false;
        }
        return bl;
    }

    private boolean compareVersions(String string, String string2, boolean bl, int n, int n2, String string3) {
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        int n4 = 0;
        String[] stringArray = new String[n2 + n2];
        for (n3 = 0; n3 < n - n2; ++n3) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        for (n3 = 0; n3 < n2 + n2; ++n3) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringArray[n3] = stringTokenizer.nextToken();
            ++n4;
        }
        for (n3 = 0; n3 < n4 && (string3 != null && stringArray[n3].indexOf(string3) > -1 || Character.getType(stringArray[n3].charAt(0)) != 9); ++n3) {
        }
        if (n3 == n4) {
            this.detectedVersion = "<not found>";
            return false;
        }
        this.detectedVersion = stringArray[n3];
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[n3], "._-");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, "._-");
        while (stringTokenizer3.hasMoreTokens()) {
            if (!stringTokenizer2.hasMoreTokens()) {
                return false;
            }
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer3.nextToken();
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = Integer.parseInt(string4);
                n6 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n5 < n6) {
                return !bl;
            }
            if (n5 <= n6) continue;
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveInRegistry(String string, String string2) {
        String string3 = "";
        int n = 0;
        RegistryHandler registryHandler = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            registryHandler = RegistryDefaultHandler.getInstance();
            if (registryHandler == null) {
                String string4 = string3;
                return string4;
            }
            n = registryHandler.getRoot();
            registryHandler.setRoot(-2147483646);
            Object[] objectArray = registryHandler.getSubkeys("Software\\JavaSoft\\Java Development Kit");
            if (objectArray == null || objectArray.length == 0) {
                String string5 = string3;
                return string5;
            }
            Arrays.sort(objectArray);
            for (int i = objectArray.length - 1; i > 0; --i) {
                if (string2 != null && !this.compareVersions((String)objectArray[i], string2, false, 4, 4, "__NO_NOT_IDENTIFIER_") || string != null && !this.compareVersions((String)objectArray[i], string, true, 4, 4, "__NO_NOT_IDENTIFIER_")) continue;
                String string6 = "Software\\JavaSoft\\Java Development Kit\\" + (String)objectArray[i];
                String string7 = registryHandler.getValue(string6, "JavaHome").getStringData();
                if (!JDKPathPanelConsoleHelper.pathIsValid(string7)) {
                    hashSet.add(objectArray[i]);
                    continue;
                }
                if (!"".equals(string3)) continue;
                string3 = string7;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (registryHandler != null && n != 0) {
                try {
                    registryHandler.setRoot(-2147483646);
                }
                catch (NativeLibException nativeLibException) {
                    nativeLibException.printStackTrace();
                }
            }
        }
        return string3;
    }
}

