/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.JDKPathPanelAutomationHelper;
import com.izforge.izpack.panels.PathInputPanel;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class JDKPathPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3257006553327810104L;
    public static final String[] testFiles = new String[]{"lib" + File.separator + "tools.jar"};
    public static final String JDK_ROOT_KEY = "Software\\JavaSoft\\Java Development Kit";
    public static final String JDK_VALUE_NAME = "JavaHome";
    public static final String OSX_JDK_HOME = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home/";
    private static final int OK = 0;
    private static final int BAD_VERSION = 1;
    private static final int BAD_REAL_PATH = 2;
    private static final int BAD_REG_PATH = 3;
    private String detectedVersion;
    private String minVersion = null;
    private String maxVersion = null;
    private String variableName;
    private Set<String> badRegEntries = null;

    public JDKPathPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setMustExist(true);
        if (!OsVersion.IS_OSX) {
            this.setExistFiles(testFiles);
        }
        this.setMinVersion(installData.getVariable("JDKPathPanel.minVersion"));
        this.setMaxVersion(installData.getVariable("JDKPathPanel.maxVersion"));
        this.setVariableName("JDKPath");
    }

    public boolean isValidated() {
        boolean bl = false;
        if (super.isValidated()) {
            switch (this.verifyVersionEx()) {
                case 0: {
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    bl = true;
                    break;
                }
                case 3: {
                    if (this.askQuestion(this.parent.langpack.getString("installer.warning"), this.parent.langpack.getString("JDKPathPanel.nonValidPathInReg"), 37, 49) != 47) break;
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    bl = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    String string = this.getMinVersion();
                    String string2 = this.getMaxVersion();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.parent.langpack.getString("JDKPathPanel.badVersion1")).append(this.getDetectedVersion()).append(this.parent.langpack.getString("JDKPathPanel.badVersion2"));
                    if (string != null && string2 != null) {
                        stringBuffer.append(string).append(" - ").append(string2);
                    } else if (string != null) {
                        stringBuffer.append(" >= ").append(string);
                    } else if (string2 != null) {
                        stringBuffer.append(" <= ").append(string2);
                    }
                    stringBuffer.append(this.parent.langpack.getString("JDKPathPanel.badVersion3"));
                    if (this.askQuestion(this.parent.langpack.getString("installer.warning"), stringBuffer.toString(), 37, 49) != 47) break;
                    this.idata.setVariable(this.getVariableName(), this.pathSelectionPanel.getPath());
                    bl = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: unknown result of version verification.");
                }
            }
        }
        return bl;
    }

    public void panelActivate() {
        super.panelActivate();
        String string = this.idata.getVariable(this.getVariableName()) != null ? this.idata.getVariable(this.getVariableName()) : (OsVersion.IS_OSX ? OSX_JDK_HOME : new File(this.idata.getVariable("JAVA_HOME")).getParent());
        this.pathSelectionPanel.setPath(string);
        if (!this.pathIsValid() || !this.verifyVersion()) {
            string = this.resolveInRegistry();
            if (!this.pathIsValid() || !this.verifyVersion()) {
                string = "";
            }
        }
        this.pathSelectionPanel.setPath(string);
        String string2 = this.idata.getVariable("JDKPathPanel.skipIfValid");
        if (string.length() > 0 && string2 != null && "yes".equalsIgnoreCase(string2)) {
            this.idata.setVariable(this.getVariableName(), string);
            this.parent.skipPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveInRegistry() {
        String string = "";
        int n = 0;
        RegistryHandler registryHandler = null;
        this.badRegEntries = new HashSet<String>();
        try {
            registryHandler = RegistryDefaultHandler.getInstance();
            if (registryHandler == null) {
                String string2 = string;
                return string2;
            }
            registryHandler.verify(this.idata);
            n = registryHandler.getRoot();
            registryHandler.setRoot(-2147483646);
            Object[] objectArray = registryHandler.getSubkeys(JDK_ROOT_KEY);
            if (objectArray == null || objectArray.length == 0) {
                String string3 = string;
                return string3;
            }
            Arrays.sort(objectArray);
            String string4 = this.getMinVersion();
            String string5 = this.getMaxVersion();
            for (int i = objectArray.length - 1; i > 0; --i) {
                if (!this.compareVersions((String)objectArray[i], string5, false, 4, 4, "__NO_NOT_IDENTIFIER_") || !this.compareVersions((String)objectArray[i], string4, true, 4, 4, "__NO_NOT_IDENTIFIER_")) continue;
                String string6 = "Software\\JavaSoft\\Java Development Kit\\" + (String)objectArray[i];
                String string7 = registryHandler.getValue(string6, JDK_VALUE_NAME).getStringData();
                this.pathSelectionPanel.setPath(string7);
                if (!this.pathIsValid()) {
                    this.badRegEntries.add((String)objectArray[i]);
                } else if ("".equals(string)) {
                    string = string7;
                }
                this.pathSelectionPanel.setPath(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (registryHandler != null && n != 0) {
                try {
                    registryHandler.setRoot(-2147483646);
                }
                catch (NativeLibException nativeLibException) {
                    nativeLibException.printStackTrace();
                }
            }
        }
        return string;
    }

    private int verifyVersionEx() {
        String string;
        String[] stringArray;
        String string2 = this.getMinVersion();
        String string3 = this.getMaxVersion();
        int n = 0;
        if (string2 == null && string3 == null) {
            return 0;
        }
        if (!this.pathIsValid()) {
            return 2;
        }
        String[] stringArray2 = System.getProperty("os.name").indexOf("Windows") >= 0 ? (stringArray = new String[]{"cmd", "/c", this.pathSelectionPanel.getPath() + File.separator + "bin" + File.separator + "java", "-version"}) : (stringArray = new String[]{this.pathSelectionPanel.getPath() + File.separator + "bin" + File.separator + "java", "-version"});
        stringArray = new String[2];
        FileExecutor fileExecutor = new FileExecutor();
        fileExecutor.executeCommand(stringArray2, stringArray);
        String string4 = string = stringArray[0].length() > 0 ? stringArray[0] : stringArray[1];
        if (string2 != null && !this.compareVersions(string, string2, true, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            n = 1;
        }
        if (string3 != null && !this.compareVersions(string, string3, false, 4, 4, "__NO_NOT_IDENTIFIER_")) {
            n = 1;
        }
        if (n == 0 && this.badRegEntries != null && this.badRegEntries.size() > 0 && this.badRegEntries.contains(this.getDetectedVersion())) {
            n = 3;
        }
        return n;
    }

    private boolean verifyVersion() {
        return this.verifyVersionEx() <= 0;
    }

    private boolean compareVersions(String string, String string2, boolean bl, int n, int n2, String string3) {
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        int n4 = 0;
        String[] stringArray = new String[n2 + n2];
        for (n3 = 0; n3 < n - n2; ++n3) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        for (n3 = 0; n3 < n2 + n2; ++n3) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringArray[n3] = stringTokenizer.nextToken();
            ++n4;
        }
        for (n3 = 0; n3 < n4 && (string3 != null && stringArray[n3].indexOf(string3) > -1 || Character.getType(stringArray[n3].charAt(0)) != 9); ++n3) {
        }
        if (n3 == n4) {
            this.detectedVersion = "<not found>";
            return false;
        }
        this.detectedVersion = stringArray[n3];
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[n3], "._-");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, "._-");
        while (stringTokenizer3.hasMoreTokens()) {
            if (!stringTokenizer2.hasMoreTokens()) {
                return false;
            }
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer3.nextToken();
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = Integer.parseInt(string4);
                n6 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n5 < n6) {
                return !bl;
            }
            if (n5 <= n6) continue;
            return bl;
        }
        return true;
    }

    public String getDetectedVersion() {
        return this.detectedVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    protected void setDetectedVersion(String string) {
        this.detectedVersion = string;
    }

    protected void setMaxVersion(String string) {
        this.maxVersion = string != null && string.length() > 0 ? string : "99.0.0";
    }

    protected void setMinVersion(String string) {
        this.minVersion = string != null && string.length() > 0 ? string : "1.0.0";
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getSummaryBody() {
        return this.idata.getVariable(this.getVariableName());
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        new JDKPathPanelAutomationHelper().makeXMLData(this.idata, iXMLElement);
    }
}

