/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.WrappedNativeLibException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class RegistryInstallerListener
extends NativeInstallerListener
implements CleanupClient {
    private static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";
    private static final String SAVE_PREVIOUS = "saveprevious";
    private RulesEngine rules;
    private List registryModificationLog;

    public RegistryInstallerListener() {
        super(true);
    }

    public void beforePacks(AutomatedInstallData automatedInstallData, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        super.beforePacks(automatedInstallData, n, abstractUIProgressHandler);
        this.rules = automatedInstallData.getRules();
        this.initializeRegistryHandler(automatedInstallData);
    }

    public void afterPacks(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        try {
            Object object;
            Object object2;
            Housekeeper.getInstance().registerForCleanup(this);
            RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
            if (registryHandler == null) {
                return;
            }
            IXMLElement iXMLElement = null;
            Unpacker.setDiscardInterrupt(true);
            registryHandler.activateLogging();
            if (this.getSpecHelper().getSpec() != null) {
                object2 = new VariableSubstitutor(automatedInstallData.getVariables());
                object = automatedInstallData.selectedPacks.iterator();
                iXMLElement = this.getSpecHelper().getPackForName("UninstallStuff");
                this.performPack(iXMLElement, (VariableSubstitutor)object2);
                while (object != null && object.hasNext()) {
                    IXMLElement iXMLElement2 = this.getSpecHelper().getPackForName(((Pack)object.next()).name);
                    this.performPack(iXMLElement2, (VariableSubstitutor)object2);
                }
            }
            if ((object2 = automatedInstallData.getVariable("UninstallKeySuffix")) != null) {
                registryHandler.setUninstallName(registryHandler.getUninstallName() + " " + (String)object2);
            }
            if (iXMLElement == null) {
                registryHandler.registerUninstallKey();
            }
            if ((object = registryHandler.getLoggingInfo()) != null) {
                UninstallData.getInstance().addAdditionalData("registryEntries", object);
            }
            this.registryModificationLog = object;
        }
        catch (Exception exception) {
            if (exception instanceof NativeLibException) {
                throw new WrappedNativeLibException(exception);
            }
            throw exception;
        }
    }

    public void cleanUp() {
        if (AutomatedInstallData.getInstance().installSuccess || this.registryModificationLog == null || this.registryModificationLog.size() < 1) {
            return;
        }
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        try {
            if (registryHandler == null) {
                return;
            }
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(this.registryModificationLog);
            registryHandler.rewind();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void performPack(IXMLElement iXMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        Vector<IXMLElement> vector;
        if (iXMLElement == null) {
            return;
        }
        String string = iXMLElement.getAttribute("condition");
        if (string != null) {
            Debug.trace("condition " + string + " found for pack of registry entries.");
            if (!this.rules.isConditionTrue(string)) {
                Debug.trace("not fulfilled.");
                return;
            }
        }
        if ((vector = iXMLElement.getChildren()) == null) {
            return;
        }
        Iterator<IXMLElement> iterator = vector.iterator();
        while (iterator != null && iterator.hasNext()) {
            String string2;
            IXMLElement iXMLElement2 = iterator.next();
            String string3 = iXMLElement2.getAttribute("condition");
            if (string3 != null) {
                Debug.trace("condition " + string3 + " found for registry entry.");
                if (!this.rules.isConditionTrue(string3)) {
                    Debug.trace("not fulfilled.");
                    continue;
                }
            }
            if ((string2 = iXMLElement2.getName()).equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(iXMLElement2, variableSubstitutor);
                continue;
            }
            if (string2.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(iXMLElement2, variableSubstitutor);
                continue;
            }
            this.getSpecHelper().parseError(iXMLElement2, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(IXMLElement iXMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        SpecHelper specHelper = this.getSpecHelper();
        String string = specHelper.getRequiredAttribute(iXMLElement, REG_BASENAME);
        string = variableSubstitutor.substitute(string, null);
        String string2 = specHelper.getRequiredAttribute(iXMLElement, REG_KEYPATH);
        string2 = variableSubstitutor.substitute(string2, null);
        String string3 = specHelper.getRequiredAttribute(iXMLElement, REG_ROOT);
        int n = this.resolveRoot(iXMLElement, string3, variableSubstitutor);
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.setRoot(n);
        String string4 = iXMLElement.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(string4) && registryHandler.getValue(string2, string, null) != null) {
            return;
        }
        registryHandler.setLogPrevSetValueFlag("true".equalsIgnoreCase(iXMLElement.getAttribute(SAVE_PREVIOUS, "true")));
        String string5 = iXMLElement.getAttribute(REG_DWORD);
        if (string5 != null) {
            string5 = variableSubstitutor.substitute(string5, null);
            registryHandler.setValue(string2, string, Long.parseLong(string5));
            return;
        }
        string5 = iXMLElement.getAttribute(REG_STRING);
        if (string5 != null) {
            string5 = variableSubstitutor.substitute(string5, null);
            registryHandler.setValue(string2, string, string5);
            return;
        }
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(REG_MULTI);
        if (vector != null && !vector.isEmpty()) {
            Iterator<IXMLElement> iterator = vector.iterator();
            String[] stringArray = new String[vector.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                IXMLElement iXMLElement2 = iterator.next();
                stringArray[n2] = specHelper.getRequiredAttribute(iXMLElement2, REG_DATA);
                stringArray[n2] = variableSubstitutor.substitute(stringArray[n2], null);
                ++n2;
            }
            registryHandler.setValue(string2, string, stringArray);
            return;
        }
        vector = iXMLElement.getChildrenNamed(REG_BIN);
        if (vector != null && !vector.isEmpty()) {
            Iterator<IXMLElement> iterator = vector.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (iterator.hasNext()) {
                IXMLElement iXMLElement3 = iterator.next();
                String string6 = specHelper.getRequiredAttribute(iXMLElement3, REG_DATA);
                stringBuffer.append(string6);
                if (!string6.endsWith(",") && iterator.hasNext()) {
                    stringBuffer.append(",");
                }
                ++n3;
            }
            byte[] byArray = this.extractBytes(iXMLElement, variableSubstitutor.substitute(stringBuffer.toString(), null));
            registryHandler.setValue(string2, string, byArray);
            return;
        }
        specHelper.parseError(iXMLElement, "No data found.");
    }

    private byte[] extractBytes(IXMLElement iXMLElement, String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byte by = 0;
            String string2 = stringTokenizer.nextToken().trim();
            try {
                int n2 = Integer.parseInt(string2, 16);
                if (n2 < 0 || n2 > 255) {
                    throw new NumberFormatException("Value out of range.");
                }
                if (n2 > 127) {
                    n2 -= 256;
                }
                by = (byte)n2;
            }
            catch (NumberFormatException numberFormatException) {
                this.getSpecHelper().parseError(iXMLElement, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvalue followed by a ','.");
            }
            byArray[n++] = by;
        }
        return byArray;
    }

    private void performKeySetting(IXMLElement iXMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        String string = this.getSpecHelper().getRequiredAttribute(iXMLElement, REG_KEYPATH);
        string = variableSubstitutor.substitute(string, null);
        String string2 = this.getSpecHelper().getRequiredAttribute(iXMLElement, REG_ROOT);
        int n = this.resolveRoot(iXMLElement, string2, variableSubstitutor);
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.setRoot(n);
        if (!registryHandler.keyExist(string)) {
            registryHandler.createKey(string);
        }
    }

    private int resolveRoot(IXMLElement iXMLElement, String string, VariableSubstitutor variableSubstitutor) throws Exception {
        String string2 = variableSubstitutor.substitute(string, null);
        Integer n = RegistryHandler.ROOT_KEY_MAP.get(string2);
        if (n != null) {
            return n;
        }
        this.getSpecHelper().parseError(iXMLElement, "Unknown value (" + string2 + ")for registry root.");
        return 0;
    }

    private void initializeRegistryHandler(AutomatedInstallData automatedInstallData) throws Exception {
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.verify(automatedInstallData);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
    }
}

