from __future__ import nested_scopes

import string
import math
import time

import sys

# -------------------------------------------------------------------------------------------------
# here we've got some utils functions to deal with unreal units and support for gamebot "datatypes"
# -------------------------------------------------------------------------------------------------

# takes degrees (0 - 360)f and converts them to UT degrees (0-65535)i
def angle_to_ut_angle( angle ):   
    return float(math.floor((float(65536) / float(360)) * float(angle)))

# takes UT degrees (0-65535)i and converts them to degrees (float num)
def ut_angle_to_angle( ut_angle ):
    return float((float(360) / float(65536)) * float(ut_angle))

def ut_angle_to_rad( ut_angle ):
    return (float(2*math.pi) / float(65536)) * ut_angle

# takes a string of the form 'x,y,z' and converts it to a tuple (x,y,z)
def location_string_to_tuple(LocationString):
    LocList = string.split(LocationString, ",")
    if len(LocList) != 3:
        return (0,0,0)
    LTuple = (float(LocList[0]), float(LocList[1]), float(LocList[2]))
    return LTuple

# takes a triple and converts it to a string '[0],[1],[2]'
def location_tuple_to_string(LocationTuple):
    if len(LocationTuple) != 3:
        return "0,0,0"
    else:
        LString = str(LocationTuple[0]) + "," + str(LocationTuple[1]) + "," + str(LocationTuple[2])
        return LString

# takes a string of the form 'pitch,yaw,roll' and converts it to a tuple (pitch, yaw, roll)
def rotation_string_to_tuple(RotationString):
    RotList = string.split(RotationString, ",")
    if len(RotList) != 3:
        return (0,0,0)
    RTuple = (int(RotList[0]), int(RotList[1]), int(RotList[2]))
    return RTuple

# takes a triple and converts it to a string '[0],[1],[2]'
def rotation_tuple_to_string(RotationTuple):
    if len(RotationTuple) != 3:
        return "0,0,0"
    else:
        RString = str(RotationTuple[0]) + "," + str(RotationTuple[1]) + "," + str(RotationTuple[2])
        return RString

# takes a string of the form 'pitch,yaw,roll' and converts it to a tuple (pitch_in_degrees, yaw_in_degrees, roll_in_degrees)
def rotation_string_to_degrees_tuple(RotationString):
    RotList = string.split(RotationString, ",")
    if len(RotList) != 3:
        return (0,0,0)
    RTuple = (ut_angle_to_angle(float(RotList[0])), ut_angle_to_angle(float(RotList[1])), ut_angle_to_angle(float(RotList[2])))
    return RTuple

# returns negative if the string-number a represents is < the string-number b represents,  0 if ==, positive if >
def compare_number_strings(a, b):
    return int(a) - int(b)
    
# lists of nav points arrive as dicts with an "ID" key and keys "0", "1", .... "n" these need converting to lists
def nav_points_dict_to_list(ValuesDict):
    del ValuesDict["ID"] # remove the ID key to leave just numbers
    # now get a list of just keys, and sort it to use in extracting the key:value pairs
    KeyList = ValuesDict.keys()
    KeyList.sort(compare_number_strings) #need a home-grown sort function as although they're strings, we don't want "10" < "2"
    
    #now use the keylist to create an ordered list of location strings    
    LocList = []
    for key in KeyList:
        #need to strip out the ID by including only everything after the first space 
        string = ValuesDict[key]
        string = string[string.find(string, " ") : len(string)]
        string = string.strip()
        LocList.append(string)
    
    return LocList

# will calculate a vector where to go (if added to a location and send as runto will move bot forward)
def calculate_move_vector(RotationTuple, length = 1): # parametr is a triple of abs ut angle units, length == length of vector
    angle = ut_angle_to_rad( RotationTuple[1] )

    x = length * math.cos( angle )
    y = length * math.sin( angle )

    return (x, y, 0)

def sum_location(location_tuple_1, location_tuple_2): # sum of two location points
    return (location_tuple_1[0] + location_tuple_2[0], location_tuple_1[1] + location_tuple_2[1], location_tuple_1[2] + location_tuple_2[2]) 

def distance_of_locations(location_tuple_1, location_tuple_2):
    x1 = float(location_tuple_1[0])
    y1 = float(location_tuple_1[1])
    z1 = float(location_tuple_1[2])
    
    x2 = float(location_tuple_2[0])
    y2 = float(location_tuple_2[1])
    z2 = float(location_tuple_2[2])

    distance = float( math.sqrt( (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2) + (z1-z2)*(z1-z2) ) )

#    print "distance is ", distance
    return distance

def is_ut_weapon( weapon_name_string ):

    return weapon_name_string in ["ImpactHammer", "Enforcer", "Translocator", "GESBioRifle", "ShockRifle", "PulseGun",
                                  "Minigun2", "UT_FlakCannon", "UT_Eightball", "WarheadLauncher"]

def wait_check( self, check_fn, limit = 5, step = 0.5):

    counter = 0
    while check_fn(self) and counter < limit:
        counter += step
        time.sleep(step)

    return counter < limit

def compare_number_strings(str_1, str_2):
    return int(str_1) - int(str_2)

# values we get from PTH values == lists of nav points arrive as dicts with an "ID" key and keys "0", "1", .... "n" these need converting to lists
def path_to_location_list(path_values):

    if path_values.has_key("ID"):    
        del path_values["ID"] # remove the ID key to leave just numbers
    elif path_values.has_key("Id"):
        del path_values["Id"] # remove the Id key to leave just numbers ... according to documentation there shouldn't be ID key but Id
    else:
        pass
    
    keys = path_values.keys() #now get a list of just keys, and sort it to use in extracting the key:value pairs
    keys.sort(compare_number_strings) # comparing with our functions
    
    #now use the keylist to create an ordered list of location strings
    path_list = []
    
    for num in keys:
        location = path_values[num]
        location = location[string.find(location, " ") : len(location)]
        location = location.strip()
        path_list.append(location)
    
    return path_list

