from __future__ import nested_scopes

class Ordered_List:

    def __init__(self, compare_fn): # compare_fn suppose to have 2 params and to return negative number for item1 < item2, 0 for ==, positive for > 

        self.compare_fn = compare_fn
        self.list = []

    def get_list(self):
        return self.list

    def top(self):
        if len(self.list) != 0:
            return self.list[0]
        else:
            return None

    def pop(self):
        if len(self.list) != 0:
            del self.list[0]

    def top_pop(self):
        if len(self.list) != 0:
            item = self.list[0]
            del self.list[0]            
            return item
        else:
            return None

    def insert(self, item): # bisection insert (well I hope this is how it's called ;)
        if len(self.list) == 0:
            self.list.append(item)
            return 1
        if self.compare_fn(item, self.list[0]) <= 0:
            self.list.insert(0, item)
            return 1
        if self.compare_fn(item, self.list[len(self.list)-1]) >= 0:
            self.list.append(item)
            return 1
        left = 0
        right = len(self.list)

        while left-right > 1:
            middle = math.floor((left-right)/2)
            if self.compare_fn(self.list[middle], item) < 0:
                left = middle
            elif self.compare_fn(self.list[middle], item) > 0:
                right = middle
            else:
                self.list.insert(middle, item)
                return 1

        self.list.insert(left+1, item)
        return 1
