from __future__ import nested_scopes
from types import *

class Log_To_File:
    # volejte start() pro zahajeni cinnosti
    # volejte metodu log_msg(msg) pro zapsani zpravy
    # volejte end() pro ukonceni cinnosti
    # volejte file_ready() pro test, jestli lze zapisovat

    def __init__(self, filename, reason, always_flush, debug_fn): # filename - specifikujeme jmeno souboru, kam logovat,
                                                                  # reason - string, ktery objasnuje duvod (pr. GameBot msgs)
                                                                  # always_flush - nastavuje, zda volat flush() po kazde zapsane zprave    
                                                                  # debug_fn - debugovaci funkce, predpokladane parametry (level, msg)
        self.filename = filename
        self.reason = reason
        self.always_flush = always_flush
        self.debug_fn = debug_fn

        # zde mame systemove info o souboru ... = open()    
        self.file = None

    def call_debug_fn(self, level, debug_msg):
        if type(self.debug_fn) in (MethodType, FunctionType):
            self.debug_fn(level, debug_msg)
            return 1
        else:
            print "Log_To_File(", self.filename, ", ", self.reason, "): debug_fn is not MethodType or FunctionType"
            print "Debug msg: " + str(level) + ", " + debug_msg
            return 0


    def report_excpetion(self, msg):
       if not self.call_debug_fn(1, msg):
           print msg

    def start(self):

        if (self.file == None):
            self.call_debug_fn(5, "Opening file " + self.filename + " for logging (" + self.reason + ").")

            try:
                self.file = open(self.filename, "w")
            except IOError, error:
                self.report_exception("File " + self.filename + " for logging (" + self.reason + ") was not opened, IOError: " + error)                
                self.file = None
                return 0
            else:
                self.call_debug_fn(30, "File " + self.filename + " opened for logging (" + self.reason + ").")
                return 1
        else:
            self.call_debug_fn(1, "Attempting to open file " + self.filename + " (" + self.reason + ") which is already opened.")
            return 0

    def end(self):

        if (self.file == None):
            self.call_debug_fn(1, "Attempting to end Log_To_File(" + self.filename + ", " + self.reason + ") when file was not opened.")
        else:
            if self.file.closed:
                self.file = None
            else:
                self.call_debug_fn(5, "Closing file " + self.filename + " (" + self.reason + ").")
                try:
                    self.file.flush()
                    self.file.close()
                except IOError, error:
                    self.report_exception("File " + self.filename + " (" + self.reason + ") wasn't closed, IOError: " + error)
                    self.file = None
                else:
                    self.file = None

    def file_ready(self):
        if self.file == None:
            return 0
        return not self.file.closed

    def log_msg(self, msg):

        if self.file_ready():
            try:
                self.file.write(msg)
                if self.always_flush:
                    self.file.flush()
            except IOError, error:
                self.report_exception("Can't write msg to file " + self.filename + " (" + self.reason + "), msg: " + msg + ", IOError: " + error)
                return 0
            else:
                return 1
            
        else:
            self.call_debug_fn(1, "Attempting to log message to a file " + self.filename + " (" + self.reason + "), when the file wasn't opened.")
            return 0

            
        
                    
            
