from __future__ import nested_scopes
from posh_bits import *

# this class supports creating behaviors in more structural way
# it allows you to have more behaviors and to unite them in this class
# which will be given to posh_agent
class Multiple_Behavior(Base):
    def __init__(self, agent, **kw):
        Base.__init__(self, agent, **kw) # Call the ancestor init

        self.behaviors = [] # here we'll have stored other behaviors
        self.behaviors_dict = {} # we'll have them stored also in dictionary
        
    # This method is called by agent.execute in posh_agent to make sure that the behavior is ok every cycle.
    # Returns 0 if everything is OK. We can assign error codes or something similar.
    def check_error(self):
        for behavior in self.behaviors:
            if behavior.check_error():
                return 1 # means error
        return 0 # all is OK, no error found

    # calling before the posh_agent is shutdowned
    def exit_prepare(self):
        for behavior in self.behaviors:
            behavior.exit_prepare()

    # adds behavior and to behavior add attribute ... behavior.behaviors = self as an link to this object so you can retrieve another behavior
    def add_behavior(self, behavior_name, behavior):
        if self.behaviors_dict.has_key(behavior_name):
            self.debug(1, "Can't add behavior " + name + " because there is already one registered under this name.")
            return 0
        elif (hasattr(behavior, "behaviors")) and (behavior.behaviors != None):
            self.debug(1, "Behavior " + behavior_name + " already has attribute behaviors, can't be added.")
            return 0
        else:
            self.debug(5, "Behavior - " + behavior_name + " added to multiple_behavior.")
            self.behaviors.append(behavior)
            self.behaviors_dict[behavior_name] = behavior
            behavior.behaviors = self # add link to us (owner of the behavior)
            behavior.init_acts()   # writes acts to agent
            behavior.init_senses() # writes senses to agent
            return 1

    def has_behavior(self, behavior_name):
        return self.behaviors_dict.has_key(behavior_name)

    def get_behavior(self, behavior_name):
        if self.behaviors_dict.has_key(behavior_name):
            return self.behaviors_dict[behavior_name]
        else:
            self.debug(1, "Behavior " + name + " doesn't exist.")
            return None
            
        

          

    
