from __future__ import nested_scopes

import thread
import time

from bot_base import *

EXPIRATION_PRIORITY = 5 # priority of the expire function for bot_scheduler when scheduling ... 



# this class was meant to be used in Bot for items which holds information which have expiration time and needs to be cleaned from time to time
# the class has self.lock attribute ... it locks the object and then do expiration work ...
# priority of expiration for scheduler is EXPIRATION_PRIORITY ... defined at the beggining of this file
# also notice that Expire_Info is scheduling themself to bot_scheduler, the bot class doesn't need to worry about this
# actually it's not used in Bot ... producing strange behavior ... some item exists for X seconds, some are wiped out almost imediately after insertion,
# but has advantage - after creation you don't need to worry about anything, I've left it here in case that somebody will have use for it
class AutoExpire_Info(Bot_Base):

    def __init__(self, bot, implicite_value,      # implicite value we want the object to have
                            expire_every_seconds, # how often to call the function in seconds, can be float
                            expiration_function): # function to call with one param ... self.value is passed
 
                                                  # ... as default in bot ... bots' functions are provided
        Bot_Base.__init__(self, bot)

        self.value = implicite_value # this holds the value of the object
        self.expire_every_seconds = expire_every_seconds
        self.expiration_function = expiration_function # if needed change this function for each object where you want to provide your own expiration
                                                       # handling ... use set_expiration_function ... it has to accept one parametr ... self.value is passed
                                                       # also notice that the object will be automatically locked before calling this / unlocked after
        self.value_lock = thread.allocate_lock() # this should be acquired if you want to work with self.value
        self.schedule_expire() # we schedule first call


    # tells scheduler about another expiration: time = current_time + expire_each_seconds
    def schedule_expire(self):
        bot.scheduler.schedule_system_time(time.time() + self.expire_every_seconds, self.expire, EXPIRATION_PRIORITY)

    # sets how often the expiration function is scheduled
    def set_expiration(self, seconds): 
        self.expire_every_seconds = seconds

    # sets an expiraton function
    def set_expiration_function(self, expiration_function):
        self.expiration_function = expiration_function

    # locking the object
    def lock(self):
        self.value_lock.acquire()

    # unlocking the object
    def unlock(self):
        self.value_lock.release()

    # function which is scheduled to do the expiration work
    def expire(self):
        self.lock()
        self.expiration_function(self.value)
        self.unlock()

# now for better mechanism to deal with expirations ... we'll have two object -> Expire_Dictionary which will contains Expire_Dictionary_Items,
# each item will now who is its owner and its key, so he can tell the owner that it's time to wipe him
# ... also has a problem, because for each new item, this instance is created...
class Expire_Dictionary_Item(Bot_Base):

    def __init__(self, bot, owner,          # who owns the item ... should be Expire_Dictionary instance
                            key,            # what's the key of the item in owner 
                            value,          # value of the item
                            type_of_time,   # either "system" / "ut_time" ... which time units we wish to use to specifu for how long the item will survive
                                            # before it will be seen as expired and wiped out
                            time_survive ): # how long the item will survive before expiration ... can be float

        Bot_Base.__init__(self, bot)

        self.owner = owner
        self.key = key
        self.value = value
        self.scheduled_expiracy = 0 # for the sake of completness

        self.expired = 0 # to wipe the object out of his owner we need to acquire his lock ... before we try to acquire it we set this to 1

        # and now, we schedule the expiration
        if type_of_time == "system":
            self.scheduled_expiracy = time.time() + float(time_survive)
            self.scheduled_item = self.bot.scheduler.schedule_system_time(self.scheduled_expiracy, self.expire, EXPIRATION_PRIORITY)
        elif type_of_time == "ut_time":
            self.scheduled_expiracy = bot.get_actual_ut_time() + float(time_survive)
            self.scheduled_item = self.bot.scheduler.schedule_ut_time(self.scheduled_expiracy, self.expire, EXPIRATION_PRIORITY)
        else:
            self.debug(1, "Expire_Dictionary_Item - unknown type_of_time '" + str(type_of_time) + "', key - '" + str(key) + "', value - '" + str(value) + "'")

    # checks whetver item expired ... at best it doesn't have to be checked at all, but to be sure ... :-)
    def expired(self):
        return self.expired

    # expire the item - this method is scheduled - flag self.expired = 1 and tells the owner it is time to kill me!
    def expire(self):
        self.expired = 1
        self.owner.lock()        
        item = self.owner.get(self.key)
        if item == self: # well we should delete the key only and only when it's still refers to the same item!
                         # we certainly don't want to delete something which has the right to exist ;)
            self.owner.delete(self.key)  
            print "kill ", self.key, item.scheduled_expiracy, '<=', self.scheduled_expiracy, 'TIME: ', self.bot.get_actual_ut_time()
#        else:            
#            print "NOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
              
        self.owner.unlock()    

# and finally Expire_Dictionary ... each instance has its lock and have safe_insert_item / safe_del_item which locks + insert / delete + release
# NOTE: there are two types of operation ... safe and unsafe, each safe operation has prefix safe, those without prefix is unsafe,
#                                            safe operations locks the object / work / unlock the object
# Operations: count(), has_key(key), get(key), insert(key, value), delete(key) 
class Expire_Dictionary(Bot_Base):

    def __init__(self, bot):
        Bot_Base.__init__(self, bot)
        self.dict = {} # items are stored here
        self.dict_lock = thread.allocate_lock() # this is lock for the object

    def lock(self):
        self.dict_lock.acquire()

    def unlock(self):
        self.dict_lock.release()

    def count(self):
        return len(self.dict)

    def keys(self):
        return self.dict.keys()

    def has_key(self, key):
        return self.dict.has_key(key)

    def get(self, key):
        if self.dict.has_key(key):
            return self.dict[key]
        else:
            return None

    def insert(self, key, value):        
        self.dict[key] = value

    def delete(self, key):
        if self.dict.has_key(key):
            self.dict[key].scheduled_item.lock()
            self.dict[key].scheduled_item.should_run = 0 # we tells to item not to run it's function, because it will be deleted
            self.dict[key].scheduled_item.unlock()
            del self.dict[key]

    def safe_count(self):
        self.lock()
        return_value = len(self.dict)
        self.unlock()
        return return_value

    def safe_has_key(self, key):
        self.lock()
        return_value = self.dict.has_key(key)
        self.unlock()
        return return_value

    def safe_get(self, key):
        self.lock()
        return_value = self.get(key)
        self.unlock()
        return return_value

    def safe_insert(self, key, value):
        self.lock()
        if self.dict.has_key(key):
            #self.dict[key].scheduled_item.lock()
            #self.dict[key].scheduled_item.should_run = 0 # we tells to item not to run it's function, because it will be overwritten
            #self.dict[key].scheduled_item.unlock()
            self.delete(key)
        self.dict[key] = value
        self.unlock()

    def safe_delete(self, key):
        self.lock()
        self.delete_key(key)
        self.unlock()