from __future__ import nested_scopes

import thread
import time

from bot_base import *

# ************
# BOT_EXECUTOR
# ************

# Is used to call a function ... you're giving him a functions and he's sequentuly running them ... used in Bot when running functions upon arrival
# of some GB message - the connection thread can't wait for non-trivial to finish ... it has to update informations from GB as fast as it can :-)

# for list exixts a lock ... if you acquire it, make sure you also release it! (it's silly for me to say this obvious thing, but ... be sure, ok?)

# to start executor call execute_executor()

class Bot_Executor(Bot_Base):

    def __init__(self, bot, **kw): # we assume that bot has attribute bot.agent

        Bot_Base.__init__(self, bot.agent, **kw)

        self.bot = bot # from self.bot we will get self.bot.actual_ut_time

        self.list = [] # here we'll store functions
        self.list_lock = thread.allocate_lock()

        self.list_length_should_not_exceed = 20 # if length of the list exceeds this number -> we'll report it as bot.debug(1, "...")

        self.exec_thread_id = 0
        self.exec_thread_active = 0
        self.exec_exec = 0   # flag, if set true - executor is working, if set false, executor is not working or will stop it's function
        self.exec_pause = 0  # flag, if true - executor will pause it's work until set false

        self.exec_sleep_length_when_no_items_left = 0.2 # if no items is on exec, the scheduler calls time.sleep( this variable )
                                                             # I have no idea what the number should be, depends on your needs - experiment :-)                           
        
    # adds item to the end of the list
    def insert(self, function):
        self.list_lock.acquire()
        self.list.append(function)
        self.list_lock.release()
        return 1

    def execute_executor(self):
        self.exec_thread_id = thread.start_new_thread(self.execute_executor_wrapper, ())

    # ***************
    # EXECUTOR METHOD
    # ***************
    
    def execute_executor_wrapper(self):
        self.exec_thread_active = 1
        self.exec_exec = 1
        self.exec_pause = 0

        self.bot.debug(5, "Bot_Executor was started.")

        while self.exec_exec:
            self.list_lock.acquire()
            if len(self.list):
                fn = self.list[0]
                del self.list[0]
                self.list_lock.release()
                fn()
            else:    
                self.list_lock.release()
                time.sleep(self.exec_sleep_length_when_no_items_left)

            while self.exec_pause:
                if not self.exec_exec: break # exits this waiting-while and then exits main loop (because self.exec_exec == 1)
                time.sleep(1)        

        self.bot.debug(5, "Bot_Executor was stopped.")

        self.exec_exec = 0
        self.exec_pause = 0
        self.exec_thread_active = 0
        self.exec_thread_id = 0    

    # ------------------------------------------------
    # methods which can stop / pause / resume executor
    # ------------------------------------------------

    def stop_executor(self):
        self.bot.debug(5, "Bot_Executor - stop command received.")
        self.exec_exec = 0

    def pause_executor(self):
        self.bot_debug(5, "Bot_Executor - pause command received.")
        self.exec_pause = 1

    def resume_executor(self):
        if self.exec_pause:
            self.bot_debug(5, "Bot_Executor - resume command received.")
            self.exec_pause = 0
        else:
            self.bot_debug(1, "Bot_Executor - resume command received while it's not paused.")
