from __future__ import nested_scopes
from multiple_behavior import *
from bot import *

# this class is meant as a behavior for any Bot you wish to create
# it handles creation of Bot instance, connecting to GB via Bot instance and after the work is done, properly closing the connection to GB
class Bot_Behavior(Multiple_Behavior):
    
    def __init__(self, ip, port, botname, agent, **kw):
        
        Multiple_Behavior.__init__(self, agent, **kw) # Call the ancestor init

        # we initialize acts and senses
        self.init_acts()
        self.init_senses()

        # now for the bot
        self.bot = self.init_bot(ip, port, botname, agent, **kw) # as you can see bot is initialized with self.init, if you write your own bot
                                                                 # simply write YourBot_Behavior inheriting this class and override self.init_bot
                                                                 # to create the instance of YourBot class (which I hope is descendant of Bot class)
        self.bot.start() # connects to GB server


    # this method create the instance of Bot ... override it in your future behaviors to create your own bot
    def init_bot(self, ip, port, botname, agent, **kw):
        return Bot(ip, port, botname, agent, **kw)
        
    # This method is called by agent.execute in posh_agent to make sure
    # that the behavior is ok every cycle. Returns 0 if everything is OK.
    # We can assign error codes or something similar.
    def check_error(self):	
        if self.bot.conn_ready: # Check the bot to see if connection
            return Multiple_Behavior.check_error(self)
        else:
            return 1 # means error occured

    # called before ending of posh_agent ASE ... method execute() / execute_thread()
    def exit_prepare(self):
        Multiple_Behavior.exit_prepare(self)
        self.bot.end() # closing connection to GB
        
    def init_acts(self):
        self.agent.add_act("do-nothing", self.do_nothing)

    def init_senses(self):
        self.agent.add_sense("fail", lambda : 0)    # sense, always report failure == false
        self.agent.add_sense("succeed", lambda : 1) # sense, always report succes == true

    def add_behavior(self, behavior_name, behavior):
        behavior.bind_bot(self.bot) # we first binds the bot to the behavior and then add it to our list (see multiple_behavior.py)
        Multiple_Behavior.add_behavior(self, behavior_name, behavior)        
        
    #  == ACTIONS ==
    def do_nothing(self):
        return 1 # really doesn't do anything :-D
