# this file should serve as an exemple / templete how your behaviors should look like
# don't edit it since it can be used by over behaviors which can be descendents of this Behaviot

from __future__ import nested_scopes
from posh_bits import *

# This class can be used as a template to create other behaviors for Bot_Behavior in bot_behavior.py
# To add this behavior to instance of Bot_Behavior edit make_bot_behavior.py (at your module directory) and use Bot_Behavior.add_behavior
# You can inherit this class to create new behaviors (if so, you don't have to write check_error, etc. in your new behavior unless needed)

# NOTE: I recommand you to keep declaration of your behavior as clear as possible since it has to represent only an interface of Bot for Agent,
#       to keep things as I think are meant to be, you should create your own Whatever_Bot class which will inherit Bot class and extend it
#       a way you want your bot to be, this means that any other state information will be stored there and you will create additional
#       get_... methods to query these states ... see ut_module/01_explorer ... this will retain the structure clear
#       Agent (decision making, mind) <-> Behavior (how to do) <-> Bot (various states, body)
#       Although right now Bot is representing also a world itself, as usual from theory we should continue with ... <-> interfaces <-> World
class Behavior(Base):
    def __init__(self, agent, **kw):
        Base.__init__(self, agent, **kw) # Call the ancestor init
                                         # in this init agent instance is bind ... self.agent = agent
        
        bot = None       # here we've got link to instance of Bot (bot.py)
        behaviors = None # will be initialized after the behavior is added to Multiple_Behavior or Bot_Behavior
                         # this attribute holds reference to that instance which "owns" this
        
    # This method checks if everything is OK ... Returns 0 if everything is OK.
    # We can assign error codes or something similar.
    def check_error(self):	
        return 0 # everything is OK

    # Should shut down / close / erase everything the behavior created
    def exit_prepare(self):
        pass

    # This method has responsibility to add acts to self.agent
    def init_acts(self):
        # for instance:
        #     self.agent.add_act("do-nothing", self.do_nothing)    
        pass
    
    # This method has reponsibility to add senses to self.agent
    def init_senses(self):
        # for instance
        #     self.agent.add_sense("fail", lambda : 0)
        pass
    
    # this method binds Bot instance to self.bot, can be used to initialize something
    def bind_bot(self, bot):
        self.bot = bot
        
    #  == SENSES ==
    #  Here should follow declarations of any senses the behavior has

    #  NOTE: in Bot_Behavior as a default exist two senses ... 'succed' -> always reporting true and 'fail' -> always reporting false
    
            
    #  == ACTIONS ==
    #  Here should follow declarations of any acts the behavior has

    #  NOTE: in Bot_Behavior as a defualt exists one action ... 'do-nothing' -> bot doesn't do anything
    #  NOTE: remember that return value matters! if True ... ActionPattern can continue, if False ... AP is terminated
