# __init__.py
#
# Wrapper for importing behavior
#
__version__ = "0.1"

import os

import bot_base
import bot_executor
import bot_scheduler
import bot_expire_items
import bot

import multiple_behavior
import bot_behavior

import behavior

def get_module_list():
    global cwd
    cwd = os.getcwd()
    dirlist = os.listdir(cwd+"/ut_modules")
    def proc_dir(item):
        if os.path.isdir(cwd+"/ut_modules/"+item):
            return 1
        else:
            return 0
    dirlist = filter(proc_dir, dirlist)
    __all__ = dirlist
    return dirlist

def get_module_plans(modulename):
    try:
        cwd = os.getcwd()
        return os.listdir(cwd+"/ut_modules/"+modulename+"/plans")
    except:
        return []

def get_plan_path(modulename):
    try:
        cwd = os.getcwd()
        return str(cwd+"/ut_modules/"+modulename+"/plans/")
    except:
        return
