from __future__ import nested_scopes
from socket import *
from posh_bits import *

import re      #re is for Regular Expressions
import thread
import time

from ut_modules.bot import *

from utils.unreal_utils import *

# ***********
# EXPLORE_BOT
# ***********

class Explore_Bot(Bot):

    def __init__(self, ip, port, botname, agent, gamebot_debug_file = None, **kw): # we gives IP:Port of the GB server + name of the bot
                                                                                   # agent - instance of Agent from posh_agent.py
                                                                                   # gamebot_debug_file - if contains string ... considered as a filename where to log
                                                                                   #                      communication with GB server
        Bot.__init__(self, ip, port, botname, agent, gamebot_debug_file, **kw)

        self.unexplored_navpoints = {} # here will be stored navpoint, which should be explored, indexed by its Id

        self.navpoints_to_check = {} # here will be navpoints, which we're supposed to check
        self.checked_navpoints = []  # checked navpoints are written here so we can uncheck them easily        

        self.nearest_reachable_unexplored_navpoint = None # navpoint from see_reachable_unexplored_navpoint

        self.selected_navpoint = None # result of the select-...-navpoint act ... uses run_to_selected_navpoint

        self.path = None
        self.path_list = None

        self.last_location_tuple_when_checking = (-2,-2,-2) # to see if we're at different place ... checking == getpath

        self.last_explored_location_tuple = (-2,-2,-2)
        self.nearest_unexplored_navpoint_seen_during_exploring = None # during exploring (turning around) is a good time to write next nearest unexplored reachable navpoint

        self.know_item_types = {} # here we will add items we've seen along the exploring
        self.new_items_count = 0 # how many new type of items we've found
        self.add_reaction_to_msg("INV", self.subscribe_item) # we'll use the fact that we can add reaction to every message type

    def load_items(self, filename):
        try:
            my_file = open(filename, "r")
            items_list = my_file.readlines()
            for item in items_list:
                if item[len(item)-1] == "\n" or item[len(item)-1] == "\r":
                    item = item[0 : len(item)-1]
                if item[len(item)-1] == "\n" or item[len(item)-1] == "\r":
                    item = item[0 : len(item)-1]                                        
                self.know_item_types[item] = item
                print "Item loaded: ", item
            my_file.close()    
        except IOError, error:
            print "ioerror"
            return 0

    def save_items(self, filename):
        items = self.know_item_types.keys()
        for i in range(len(items)):
            items[i] = items[i] + "\n"
        try:
            my_file = open(filename, "w")
            my_file.writelines(items)
            my_file.close()    
        except IOError, error:
            print "ioerror"
            return 0
        pass

    def start(self):
        self.load_items("ut_items.txt")
        Bot.start(self)

    def end(self):
        self.save_items("ut_items.txt")
        print "New items count: ", self.new_items_count
        Bot.end(self) # close connection        

    def subscribe_item(self, values):
        if not self.know_item_types.has_key(values["Class"]):
            print "new item: ", values["Class"]
            self.know_item_types[values["Class"]] = values
            self.new_items_count += 1

    def process_nav(self, values): # we override this method to write additional information to self.known_nav_points
        values["TimeStamp"] = self.actual_ut_time

        self.see_navpoints.safe_insert(values["Id"],
                                       Expire_Dictionary_Item(self,                                # BOT
                                                              self.see_navpoints,                  # owner of the item
                                                              values["Id"],                        # key of the item
                                                              values,                              # value to store
                                                              self.see_navpoints_expire_time_type, # time_type for scheduling
                                                              self.see_navpoints_expire_time) )    # time before expiration       

        if not self.known_navpoints.has_key(values["Id"]):
            values["Checked"] = 0  # this will tell us if we've tested this node for a path
            self.known_navpoints[values["Id"]] = values
            self.unexplored_navpoints[values["Id"]] = values # in this dictionary we add navpoints to explore
    

    def is_navpoint_explored(self, navpoint_id):
        if self.known_navpoints.has_key(navpoint_id):
            return self.known_navpoints[navpoint_id]
        else:
            return None        
        
            
        

        
                                 


        
    

    

    

    

    

    
