from __future__ import nested_scopes

from posh_bits import *
from ut_modules.behavior import *
from utils.unreal_utils import *

import time
import random
import math


class Explore_Behavior(Behavior):
    def __init__(self, agent, **kw):
        Behavior.__init__(self, agent, **kw) # Call the ancestor init
        
    def exit_prepare(self):
        pass

    def init_senses(self):

        self.agent.add_sense("see-unexplored-reachable-navpoint", self.see_unexplored_reachable_navpoint)
        self.agent.add_sense("know-unexplored-unchecked-navpoint", self.know_unexplored_unchecked_navpoint)
        self.agent.add_sense("has-no-path", self.has_no_path)
        self.agent.add_sense("know-the-path", self.know_the_path)
        self.agent.add_sense("know-at-least-navpoints", self.know_at_least_navpoints)
        self.agent.add_sense("see-no-navpoints", self.see_no_navpoints)
        self.agent.add_sense("see-player", self.see_player)

    def init_acts(self):

        self.agent.add_act("stop", self.stop)
        self.agent.add_act("turn", self.turn)        
        self.agent.add_act("select-nearest-reachable-unexplored-navpoint", self.select_nearest_reachable_unexplored_navpoint)
        self.agent.add_act("run-to-selected-navpoint", self.run_to_selected_navpoint)
        self.agent.add_act("explore-selected-navpoint", self.explore_selected_navpoint)        
        self.agent.add_act("select-nearest-unchecked-unexplored-navpoint", self.select_nearest_unchecked_unexplored_navpoint)
        self.agent.add_act("get-path-to-selected-navpoint", self.get_path_to_selected_navpoint)
        self.agent.add_act("select-random-navpoint", self.select_random_navpoint)       
        self.agent.add_act("follow-the-path", self.follow_the_path)
        self.agent.add_act("do-nothing", self.do_nothing)
    
    #  == FUNCTIONS ==

    def run_to_location_tuple(self, location_tuple):
    
        self.bot.send_turn_to_location_tuple( (location_tuple[0], location_tuple[1], location_tuple[2] - 5) )
        time.sleep(0.3)

        if self.bot.have_requested_reachcheck("check"):
            del self.bot.requested_reachcheck["check"]
            
        self.bot.send_reachcheck_location("check", location_tuple, self.bot.get_bot_location_tuple())

        if not wait_check(self, lambda self: not self.bot.have_requested_reachcheck("check"), 3, 0.1):
            print "Reachcheck timed out."
            return 0
        else:
            reachcheck = self.bot.get_specific_reachcheck("check")
            print "Reachcheck -> " + str(reachcheck["Reachable"])

        self.bot.send_run_to_location_tuple(location_tuple)
        time.sleep(0.2) # gives a time for bot to start running (... self.bot.bot_is_moving() to be true)
        counter = 0
        limit = 5
        step = 0.1
        while distance_of_locations(self.bot.get_bot_location_tuple(), location_tuple) > self.bot.location_accuracy and \
              counter < limit and not self.bot.bot_collide() and self.bot.bot_is_moving():
            counter += step
            time.sleep(step)

        if distance_of_locations(self.bot.get_bot_location_tuple(), location_tuple) < self.bot.location_accuracy:
            return 1

        self.bot.send_jump()
        time.sleep(0.5)

        while distance_of_locations(self.bot.get_bot_location_tuple(), location_tuple) > self.bot.location_accuracy and \
            counter < limit and not self.bot.bot_collide() and self.bot.bot_is_moving():
            counter += step
            time.sleep(step)

        if distance_of_locations(self.bot.get_bot_location_tuple(), location_tuple) < self.bot.location_accuracy:
            return 1
        else:
            print "Collision"
            self.bot.send_stop()
            time.sleep(0.1)            
            self.bot.send_rotate_horizontal(30000)
            time.sleep(0.5)            


    def pick_nearest_unexplored_reachable_navpoint_from_see_navpoints(self, navpoints):
        actual_location = self.bot.get_bot_location_tuple()
        min_distance = 9999999
        nearest = None

        unexplored_navpoints = self.bot.unexplored_navpoints
        for navpoint_id in navpoints.keys():
            navpoint = navpoints.get(navpoint_id)
            if navpoint.value["Reachable"] == "True" and unexplored_navpoints.has_key(navpoint_id):
                distance = distance_of_locations(actual_location, navpoint.value["LocationTuple"])
                if distance > self.bot.location_accuracy and distance < min_distance:                
                    min_distance = distance
                    nearest = navpoint.value

        return (nearest, min_distance)

    #  == SENSES ==
    
    def see_player(self):
        if self.bot.see_any_friend() or self.bot.see_any_enemy():
          print "see"
          return 1
        else:
          print "don't see"
          return 0
        

    def see_unexplored_reachable_navpoint(self):

        if distance_of_locations(self.bot.get_bot_location_tuple(), self.bot.last_explored_location_tuple) < self.bot.location_accuracy and \
           self.bot.nearest_unexplored_navpoint_seen_during_exploring != None:
            self.bot.nearest_reachable_unexplored_navpoint = self.bot.nearest_unexplored_navpoint_seen_during_exploring
        else: # checks if we see any    
        
            see_navpoints = self.bot.get_see_navpoints()
            see_navpoints.lock()
            (self.bot.nearest_reachable_unexplored_navpoint, distance) = self.pick_nearest_unexplored_reachable_navpoint_from_see_navpoints(see_navpoints)
            see_navpoints.unlock()
            
        return self.bot.nearest_reachable_unexplored_navpoint != None
        

    def know_unexplored_unchecked_navpoint(self):
        actual_location_tuple = self.bot.get_bot_location_tuple()

        if float(math.fabs(distance_of_locations(actual_location_tuple, self.bot.last_location_tuple_when_checking))) > float(self.bot.location_accuracy):
            # we've moved! have to do checks again
            for navpoint in self.bot.checked_navpoints:
                navpoint["Checked"] = 0
            self.bot.checked_navpoints = []
            self.bot.navpoints_to_check = self.bot.unexplored_navpoints
            self.bot.last_location_tuple_when_checking = actual_location_tuple

        return len(self.bot.navpoints_to_check) > 0

    def has_no_path(self):
        return self.bot.path == None

    def know_the_path(self):
        return self.bot.path != None

    def know_at_least_navpoints(self):
        return len(self.bot.known_navpoints)

    def see_no_navpoints(self):
        return self.bot.get_see_navpoints().count() == 0
            
    #  == ACTIONS ==

    def do_nothing(self):
        print("do nothing!")
        return 1

    def stop(self):
        self.bot.send_stop()
        time.sleep(0.05)
        return 1

    def turn(self):
        self.bot.send_rotate_horizontal(10000)
        return 1 

    def select_nearest_reachable_unexplored_navpoint(self):
        self.bot.selected_navpoint = self.bot.nearest_reachable_unexplored_navpoint
        return 1        

    def run_to_selected_navpoint(self):
        if self.bot.selected_navpoint == None:
            print "No navpoint to run to."
            self.bot.debug(1, "No navpoint selected to runto.")
        elif self.run_to_location_tuple(self.bot.selected_navpoint["LocationTuple"]):
            return 1    
        else:
            self.bot.debug(1, "Bot couldn't reach specified location. (explore_behavior.run_to_selected_navpoint)")
            return 0    

    def explore_selected_navpoint(self):

        if self.bot.selected_navpoint != None:
            print "Exploring."

            see_navpoints = self.bot.get_see_navpoints()

            iterations = 5 
            sleep_time = 0.3

            angle = int((2*65600) / iterations) # HA it seems that ROTATE is dividing amount by two! ... we have to do 2*65535 rotation

            nearest_navpoint = None
            min_distance = 999999

            for i in range(iterations): 
                self.bot.send_rotate_horizontal(angle)
                time.sleep(sleep_time)

                see_navpoints.lock()
                (temp_navpoint, temp_distance) = self.pick_nearest_unexplored_reachable_navpoint_from_see_navpoints(see_navpoints)
                see_navpoints.unlock()

                if temp_navpoint != None:
                    if nearest_navpoint == None:
                        (nearest_navpoint, min_distance) = (temp_navpoint, temp_distance)
                    else:
                        if temp_distance < min_distance:
                            (nearest_navpoint, min_distance) = (temp_navpoint, temp_distance)

            if self.bot.unexplored_navpoints.has_key(self.bot.selected_navpoint["Id"]):
                print "Navpoint explored and deleted from list."
                del self.bot.unexplored_navpoints[self.bot.selected_navpoint["Id"]]
            else:
                print "Oops, we've already explored this Navpoint, what's wrong?"
                self.bot.debug(1, "We've just explored navpoint we'd already explored before.")

            self.nearest_unexplored_navpoint_seen_during_exploring = nearest_navpoint    
            
        return 1            

    def select_nearest_unchecked_unexplored_navpoint(self):

        actual_location_tuple = self.bot.get_bot_location_tuple()

        if float(math.fabs(distance_of_locations(actual_location_tuple, self.bot.last_location_tuple_when_checking))) > float(self.bot.location_accuracy):
            # we're at different position then before , so we have to do the checks again!
            for navpoint in self.bot.checked_navpoints:
                navpoint["Checked"] = 0
            self.bot.checked_navpoints = []
            self.bot.navpoints_to_check = self.bot.unexplored_navpoints
            self.bot.last_location_tuple_when_checking = actual_location_tuple

        nearest_navpoint_id = None
        min_distance = 9999999

        for navpoint_id in self.bot.navpoints_to_check.keys():
            distance = distance_of_locations(self.bot.navpoints_to_check[navpoint_id]["LocationTuple"], actual_location_tuple)
            if distance < self.bot.location_accuracy:
                self.bot.navpoints_to_check[navpoint_id]["Checked"] = 1
                self.bot.checked_navpoints.append(self.bot.navpoints_to_check[navpoint_id])
                del self.bot.navpoints_to_check[navpoint_id]  
            elif distance < min_distance:
                min_distance = distance
                nearest_navpoint_id = navpoint_id

        if nearest_navpoint_id != None:
            self.bot.selected_navpoint = self.bot.navpoints_to_check[nearest_navpoint_id]
        else:
            self.bot.selected_navpoint = None

        return 1            
            
    def get_path_to_selected_navpoint(self):

        self.bot.last_location_tuple_when_checking = self.bot.get_bot_location_tuple()

        navpoint = self.bot.selected_navpoint

        if navpoint == None:
            return 0

        if self.bot.requested_path.has_key("path"):
            del self.bot.requested_path["path"]

        self.bot.send_get_path_location_string("path", navpoint["Location"])

        if wait_check(self, lambda self: self.bot.get_specific_path("path") == None, 5, 0.4):
            self.bot.path = self.bot.get_specific_path("path")
        else:
            self.bot.debug(1, "Path wasn't returned. (explore_behavior.selecte_nearest_unchecked_navpoint)")
            self.bot.path = None

        if self.bot.navpoints_to_check.has_key(navpoint["Id"]):
            self.bot.navpoints_to_check[navpoint["Id"]]["Checked"] = 1
            self.bot.checked_navpoints.append(navpoint)
            del self.bot.navpoints_to_check[navpoint["Id"]]
        return 1            

    def select_random_navpoint(self):
        navpoints = self.bot.get_known_navpoints()
        if len(navpoints) > 0:
            self.bot.selected_navpoint = navpoints[random.choice(navpoints.keys())]
        else:
            self.bot.selected_navpoint = None
        return 1            

    def follow_the_path(self):
        if self.bot.path != None:
            if self.bot.path_list == None:
                self.bot.path_list = path_to_location_list(self.bot.path)

            if len(self.bot.path_list) == 0:
                self.bot.path = None
                self.bot.path_list = None

            else:
                print "Follow the path -> " + self.bot.path_list[0]
                location_tuple = location_string_to_tuple(self.bot.path_list[0])

                if self.run_to_location_tuple(location_tuple):
                    del self.bot.path_list[0]
                else:
                    self.bot.debug(1, "Can't get to one of the navpoint on the path. (explore_behavior.follow_the_path)")
                    self.bot.path = None
                    self.bot.path_list = None
        return 1                    
                    
        
            
            
            
        
        

    
