#!/usr/bin/python
#
# Agent class
#
# ||TODO|| OK if the plan file isn't too large. Implement a beter
# parser, probably using parse trees.

from __future__ import nested_scopes
import re
from types import *
#from posh_core import *
from posh_bits import *
#import posh_utils
import time
import thread

from utils.log_to_file import *



def dict(sequence):
     resultDict = {}
     for key, value in sequence:
         resultDict[key] = value
     return resultDict

# These constants control the amount of sleep() between runs. They work in a
# logarithmic fashion when approaching the processor limit.
# Default # of seconds to delay between each driver run. This is a hard limit
# of the number of runs that can happen in one second.
#                    1/DRIVER_DELAY * DELAY_MULTIPLIER = Hz
# Each agent can set own self.delay. Set to 0 to disable limit. Generally
# not accurate over approx. 100Hz with a multiplier of 1.
# DELAY_MULTIPLIER can not be 0. If 0, it will cause divide by 0 error.
# Time consumming bb checks may further lower the frequency of drive runs.
DRIVER_DELAY = 0.1
DELAY_MULTIPLIER = .5

# Debuglevel information
# 1 Critical Messages Only
# 5 Normal Messages
# 9 Iteration Messages
# 10 Which drive run (Jimmy)
# 11 Competence fires notice. (Jimmy)
# 12 Competence element fires (Jimmy) <- this doesn't matter as long as competence elements has always ce_label == "fix_me_cel" :-(
#                                        that attribute ce_label confuses me a little, because at first it seems to be set a then it's not ?
# 13 AP fires notice (Jimmy)
# 15 Acts debug (Jimmy) <- I suggest that from 15-19 there should be a place for a users (ones who is writing the agent) messages
# 20 Detail Operations

# Default Debuglevel ###############################
DEFAULT_DEBUG = 9

DEBUG_DETAIL_OPERATION = 20 # used in calling debug fn with detailed informations ... If we wish to change it again in a future

# Default Size of Debugboard ######################
DEFAULT_DBSIZE = 128 # (Jimmy) was 4096 ... now you have an option to write debug messages to a file, so I don't think it's necessary to have it so big


# Base (from posh_core)
#   \--Debugboard

class Debugboard(Base):
    def __init__(self, maxsize = DEFAULT_DBSIZE, debuglevel = DEFAULT_DEBUG, **kw):
        Base.__init__(self, **kw) # Call the ancestor init
        self.debuglevel = debuglevel # 1 most important, 20 least important (0 for ignore)
        self.debugboard = []
        self.maxsize = maxsize # Items to keep on board
        self.on_add = None
        
    # Adds an item to the debug board. This method may be overwritten
    def add(self, level = 1, item = None):
        if level <= self.debuglevel:
            #print item
            
            if type(self.on_add) in (MethodType, FunctionType):
                self.on_add(item)
            
            self.debugboard.append(item)
            if len(self.debugboard) > self.maxsize:
                del(self.debugboard[0])
                
    def copy_debugboard(self):
        return self.debugboard

# The agent instance keeps track of all the objects while the
# script is read in.
class Agent:
    def __init__(self,
                 schedule = None,
                 blackboard = None,
                 debugboard = None,
                 driver_delay = DRIVER_DELAY,
                 delay_multiplier = DELAY_MULTIPLIER):
        
        if schedule == None:
            schedule = Schedule(agent = self)
        if blackboard == None:
            blackboard = Blackboard(agent = self)   
        if debugboard == None:
            debugboard = Debugboard(agent = self)
        self.ap_dict = {}
        self.comp_dict = {}
        # This keeps the drive collection while parsing. self.create_tree()
        # links up all of the drive-roots in the drive elements and
        # stores the finished tree here
        self.drive_collection = None
        
        self.act_dict = {}
        self.sense_dict = {}
	
#        self.behaviors = {}
        
        self.schedule = schedule
        self.blackboard = blackboard
        self.drive_element_dict = {}
        self.competence_element_dict = {}
        self.behavior_instance = None
        self.debugboard = debugboard
        self.driver_delay = driver_delay
        self.delay_multiplier = delay_multiplier
        self.exec_thread_id = None
        self.exec_flag = 1

        # (Jimmy) ... this can pause main loop
        self.pause_flag = 0
	
        # (Jimmy) ... this enable / disable RT/BB/Sched status debug
        self.rt_bb_sched_debug = 0

        # (Jimmy) ... this enable / disable debug msg about new iteration of the ASE cycle
        self.rt_execute_debug = 0

        # (Jimmy) ... if it's not None ... contains Log_To_File instance, can be created / halted via methods ... start_debug_to_file( filename ), stop_debug_to_file()
        self.debug_to_file = None

    def start_debug_to_file(self, filename):
        if self.debug_to_file != None:
            self.stop_debug_to_file()
        self.debug_to_file = Log_To_File(filename, "Posh-Agent debug", 0, self.debug_board_only)
        self.debug_to_file.start()

    def stop_debug_to_file(self):
        if self.debug_to_file != None:
            self.debug_to_file.end()
        self.debug_to_file = None    
        
    def set_debug_level(self, level):
        self.debugboard.debuglevel = level
    # (Jimmy) created for instance Log_To_File to prevent infinit recursion
    def debug_board_only(self, level, message):
        self.debugboard.add(level, message)

    def debug(self, level, message):
        self.debugboard.add(level, message)
        if self.debug_to_file != None:
            self.debug_to_file.log_msg(message + "\n")

    def bind_behavior_instance(self, cmd, keydict): # cmd - funkce pro vytvoreni behavioru ... predpokladame, ze vrati SEZNAM / POLE jednotlivych behavioru
        self.debug(5, "Binding Behavior Instance")
        self.behavior_instance = cmd(agent = self, **keydict)

    def add_act(self, name, act):
        self.debug(5, "Adding Act - " + name)
        self.act_dict[name] = act

    def add_sense(self, name, sense):
        self.debug(5, "Adding Sense - " + name)
        self.sense_dict[name] = sense
        
    def add_action_pattern(self, name, action_pattern):
        self.debug(5, "Adding Action Pattern - " + name)
        self.ap_dict[name] = action_pattern

    def add_competence(self, name, competence):
        self.debug(5, "Adding Competence - " + name)
        self.comp_dict[name] = competence

    def add_competence_element(self, name, competence_element):
        self.debug(5, "Adding Competence Element - " + name)
        self.competence_element_dict[name] = competence_element

    def add_drive_element(self, name, drive_element):
        self.debug(5, "Adding Drive Element - " + name)
        self.drive_element_dict[name] = drive_element
        
    def get_act(self, name):
        self.debug(5, "Retrieving Act - " + name)
        if self.act_dict.has_key(name):
            return self.act_dict[name]
        else:
            return None
        
    def get_sense(self, name):
        self.debug(5, "Retrieving Sense - " + name)
        if self.sense_dict.has_key(name):
            return self.sense_dict[name]
        else:
            return None
        
    def get_action_pattern(self, name):
        if self.ap_dict.has_key(name):
            self.debug(5, "Done Retrieving Action Pattern - " + name)
            return self.ap_dict[name]
        else:
            self.debug(5, "Cannot Retrieve Action Pattern - " + name)
            return None
        
    def get_competence(self, name):
        if self.comp_dict.has_key(name):
            self.debug(5, "Done Retrieving Competence - " + name)
            return self.comp_dict[name]
        else:
            self.debug(5, "Cannot Retrieve Competence - " + name)
            return None
        
    def get_drive_collection(self):
        self.debug(5, "Returning Drive Collection")
        return self.drive_collection
        
    def get_drive_collection_name(self):
        self.debug(5, "Returning Drive Collection Name")
        if isinstance(self.drive_collection, Drive_Collection):
            return self.drive_collection.name
        else:
            return None
        
    def get_drive_element(self, name):
        if self.drive_element_dict.has_key(name):
            self.debug(5, "Done Retrieving Drive Element - " + name)
            return self.drive_element_dict[name]
        else:
            self.debug(5, "Cannot Retrieve Drive Element - " + name)
            return None

    def get_competence_element(self, name):
        if self.competence_element_dict.has_key(name):        
            self.debug(5, "Done Retrieving Competence Element - " + name)
            return self.competence_element_dict[name]
        else:
            self.debug(5, "Cannot Retrieve Competence Element - " + name)
            return None

    def find_action_element(self, name):
        self.debug(5, "Compound Retrieval find_action_element() - " + name)
        if self.get_act(name):
            return self.get_act(name)
        elif self.get_action_pattern(name):
            return self.get_action_pattern(name)
        elif self.get_competence(name):
            return self.get_competence(name)
        elif self.get_drive_collection_name() == name:
            return self.drive_collection
        else:
            # Found Nothing
            self.debug(5, "Failed find_action_element() - " + name)
            return None

    def find_element(self, name):
        self.debug(5, "Compound Retrieval find_element() - " + name)
        if self.get_act(name):
            return self.get_act(name)
        elif self.get_sense(name):
            return self.get_sense(name)
        elif self.get_action_pattern(name):
            return self.get_action_pattern(name)
        elif self.get_competence(name):
            return self.get_competence(name)
        elif self.get_competence_element(name):
            return self.get_competence_element(name)
        elif self.get_drive_collection_name() == name:
            return self.self.drive_collection
        elif self.get_drive_element(name):
            return self.get_drive_element(name)
        else:
            # Found Nothing
            self.debug(5, "Failed find_element() - " + name)
            return None
        
    def create_tree(self):
        def validate_action_pattern(ap):
            self.debug(5, "Validating Action Pattern - " + ap.name)
            # Call the elements validation routine immediately
            # It will also take care of the list depth (ie. sub-sub-lists)
            ap.elements = validate_ap_elements(ap.elements)
            return ap

        def validate_ap_elements(item, depth = 0):
            if type(item) is ListType:
                if len(item) > 0:
                    if type(item[0]) is ListType:
                        if depth >= 1:
                            self.debug(1,
                             "Action Pattern Elements exceed list depth (1)")
                            return None # This should report an error
                        rlist = []
                        for x in item:
                            rlist.append(validate_ap_elements(item, \
                                                       depth = depth + 1))
                        return rlist
                    else:
                        rlist = []
                        for x in item:
                            # If the first item is not a list, then that means
                            # that this list should contain Sense objects or
                            # action functions
                            if type(x) is InstanceType \
                                   and isinstance(x, Sense):
                                # x.trigger = validate_action_pattern(
                                #     x.trigger)
                                rlist.append(x)
                            else:
                                # If the object isn't a Sense, then it must be a
                                # placeholder for an action. Find it
                                obj = self.find_element(x)
                                if obj:
                                    rlist.append(obj)
                                else:
                                    self.debug(1,
                             "Cannot find action element - " + str(obj))
                        return rlist

            else:
                self.debug(1,
                    "Received single item when anticipating list")
                return None # Not supposed to get single values should raise error
            
        def validate_competence(comp):
            self.debug(5, "Validating Competence - " + comp.name)
            # First validate the trigger (which is an action pattern)
            comp.goal.trigger = validate_action_pattern(comp.goal.trigger)
            # Then validate all elements
            comp.elements = validate_comp_elements(comp.elements)
            return comp
            
        def validate_comp_elements(item, depth = 0):
            if type(item) is ListType:
                if len(item) > 0:
                    if type(item[0]) is ListType:
                        if depth >= 2:
                            self.debug(1,
                             "Competence Elements exceed list depth (2)")
                            return None # This should report an error
                        rlist = []
                        for x in item:
                            rlist.append(validate_comp_elements(x, depth = depth + 1))
                        return rlist
                    else:
                        rlist = []
                        # The list should be of Objects, process each one
                        for x in item:
                            if type(x) is InstanceType and isinstance(x, Competence_Element):
                                # This replaces the "action" attribute of the
                                # Generic() instance in the action attribute
                                # of the current comp. element. The string
                                # is replaced with the actual first-class
                                # function
                                x.action.action = self.find_action_element(x.action.action)
                                if x.action.action == None:
                                    rlist.append(None)
                                    # This means that error occured
                                    # fetching the action
                                    self.debug(1,
                         "Unable to fetch action for the action instance of-" + \
                                                        x.name)
                                else:
                                    rlist.append(x)
                            else:
                                rlist.append(None)
                                self.debug(1,
                                "Wrong type of object in competence elem list")
                        return rlist
                else:
                    return [] # If empty list, return a empty list
            else:
                self.debug(1,
                    "Received single item when anticipating list")
                return None # Not supposed to get single values should raise
                            # error
                            
        def validate_drive_collection(drivec):
            self.debug(5, "Validating Drive Collection")
            # First validate the trigger (which is an action pattern)
            drivec.goal.trigger = validate_action_pattern(drivec.goal.trigger)
            # Then validate all elements
            drivec.elements = validate_drive_elements(drivec.elements)
            return drivec

        def validate_drive_elements(item, depth = 0):
            if type(item) is ListType:
                if len(item) > 0:
                    if type(item[0]) is ListType:
                        if depth >= 2:
                            self.debug(1,
                             "Drive Elements exceed list depth (2)")
                            return None
                        rlist = []
                        for x in item:
                            rlist.append(validate_drive_elements(x, \
                                                            depth = depth + 1))
                        return rlist
                    else:
                        rlist = []
                        # The list should be of Objects, process each one
                        for x in item:
                            if type(x) is InstanceType \
                                   and isinstance(x, Drive_Element):
                                # This replaces the "action" attribute of the
                                # Generic() instance in the action attribute
                                # of the current comp. element. The string
                                # is replaced with the actual first-class
                                # function
                                x.trigger = validate_action_pattern(
                                    x.trigger)
                                x.drive_root.action = \
                                       self.find_action_element( \
                                    x.drive_root.action)
                                if x.drive_root.action == None:
                                    rlist.append(x)
                                    # This means that error occured
                                    # fetching the action
                                    self.debug(1, "Unable to fetch action for the drive root of -" + x.name )
                                else:
                                    rlist.append(x)
                            else:
                                rlist.append(None)
                                self.debug(1,
                                "Wrong type of object in drive elements list")
                        return rlist
                else:
                    return [] # If empty list, return a empty list
            else:
                self.debug(1,
                                "Received single item when anticipating list")
                return None

        #
        # Start doing the grunt work and link up the objects
        #

        self.ap_dict = dict([(key , validate_action_pattern(value)) \
                                    for key , value in self.ap_dict.items()])
        self.comp_dict = dict([(key , validate_competence(value)) \
                                for key , value in self.comp_dict.items()])
        self.drive_collection = validate_drive_collection( \
            self.drive_collection)

        return self.drive_collection


#   ###############################################################
#   # This is the master command - Returns a drive collection     #
#   # Reader.read_file                                            #
#   ###############################################################
    def read_file(self, filename):
        self.debug(5, "Reading in Plan - " + filename)
        planfile = open(filename)

        # Takes in a string and strips out all the comments from
        # or ; to newline. Then reformats the parentheses by
        # adding whitespaces around them
        def strip_comments(string):
            # Remove everything from the comment symbol to the newline
            r = re.compile('[\#\;].*(\n|\r\n)')
            string = r.sub('', string)
        
            # Remove the newlines
            r2 = re.compile('(\n|\r\n)')
            string = r2.sub('', string)
        
            # Format the parens
            r3 = re.compile('\(')
            string = r3.sub(' ( ', string)
            r4 = re.compile('\)')
            string = r4.sub(' ) ', string)

            # Returns the string as a list by spliting it at whitespace
            return string.split()

        # This function takes in a string and then for each expression
        # enclosed in brackets creates a python list. It calls itself
        # recursively in order to create lists within lists.
        def read_list(input_list):
            # Reverse the list ready for popping (python's pops from the end)
            input_list.reverse()
            return_list = []
            temp_list = []
            index = 0                                           

            # When the loop encounters a opening bracket, tell it to store
            # the items until it counters the bracket that closes it.
            # Then pass the list of stored items into itself recusively
            while input_list:
                item = input_list.pop()
                if item == '(':
                    index = index + 1
                    if index > 1:
                        temp_list.append(item)
                elif item == ')':
                    index = index - 1
                    if index == 0:
                        return_list.append(read_list(temp_list))
                        temp_list = []
                    else:
                        temp_list.append(item)
                else:
                    if index == 0:
                        return_list.append(item)
                    else:
                        temp_list.append(item)
            return return_list

        def read_objects(input_list):

        
#   #   #   ###########################################################
#   #   #   # Action Pattern Functions Reader.read_file.read_objects  #
#   #   #   ###########################################################

            def read_action_pattern(item):
                if len(item) != 4:
                    self.debug(1,
                      "Wrong Number of Arguments (AP name time elements) - " + str(item))
                self.add_action_pattern(name = item[1],
                                        action_pattern = return_action_pattern(
                    name = item[1],
                    timeout = self.fix_time(item[2]),
                    timeout_rep = item[2],
                    ap_guts = item[3]))

            # When the item is in a sublist, pass it on as a Sense(),
            # otherwise, it is just a act/comp/ap call
            def read_ap_element(elem):
                if type(elem) is ListType:
                    return read_ap_sense(elem)
                else:
                    return elem

            def read_ap_sense(item):
                # print item
                item.reverse()
                name = item.pop()
                # Returns a reference to a sense function
                sensor = self.get_sense(name)
                value = None
                predicate = None

                if not sensor:
                    self.debug(1,
                        "Sense Not Found - " + str(name))

                # print len(item)
                if len(item) > 0:
                    value = item.pop()
                    if len(item) > 0: # If there is a predicate
                        predicate = item.pop()
                        if predicate in ("eq", "="):
                            predicate = "=="
                        elif predicate in ("lt", "<"):
                            predicate = "<"
                        elif predicate in ("gt", ">"):
                            predicate = ">"
                        elif predicate in ("not", "!", "!="):
                            predicate = "!="
                        else:
                            self.debug(1, "Predicate " + str(predicate)+ " invalid for Sense " + name)
                    else:
                        predicate = "=="
                    # Assign the comparision as a lambda function
                return Sense(name = name,
                             sensor = sensor,
                             sense_value = value,
                             sense_predicate = predicate,
                             tag = name,
                             command = "sense",
                             action = "predicate",
                             value = "value",
                             agent = self)

            def return_action_pattern(ap_guts,
                                      name,
                                      timeout,
                                      timeout_rep):
                return Action_Pattern(name = name,
                                      ap_guts = ap_guts,
                                      timeout = timeout,
                                      timeout_rep = timeout_rep,
                                      command = "element",
                                      tag = name,
                                      action = "posh",
                                      elements = \
                                          map(read_ap_element, ap_guts),
                                      agent = self)

            
#   #   #   ###########################################################
#   #   #   # Competence Functions Reader.read_file.read_objects      #
#   #   #   ###########################################################
            def read_competence(item):
                name = item[1]
                self.debug(5, "Reading Competence - " + name)
                timeout = self.fix_time(item[2])
                timeout_rep = item[2]
                ap_guts = item[3][1][:] # Make a copy of AP list (for goals)
                elements = item [4][:]  # Make a copy of the elements
                del(elements[0]) # Delete the "elements" word
                self.add_competence(name = item[1],
                                    competence = Competence(
                    name = name,
                    command = "request",
                    tag = name,
                    action = "posh",
                    timeout_rep = timeout_rep,
                    timeout = timeout,
                    agent = self,
                    goal = Competence_Element(competence = "see-action-tag",
                                              action = Generic(name = str(name) + "_goal",
                                                               command = "request",
                                                               tag = str(name) +  "_goal",
                                                               action = None,
                                                               agent = self),
                                              trigger = return_action_pattern(ap_guts = ap_guts,
                                                                              name = str(name) + "_goal_trigger",
                                                                              timeout = timeout,
                                                                              timeout_rep = timeout_rep),
                                              agent = self),
                    elements = read_competence_elements(competence = name,
                                                        elements = elements,
                                                        timeout = timeout)))

            # Do a recursive, multi-level descent into the list. Descend
            # until a non-list is found and return it as an element
            # Limit the level of descent to 2
            def read_competence_elements(competence,
                                         elements,
                                         timeout,
                                         depth = 0):
                #print elements
                if type(elements) is ListType:
                    if type(elements[0]) is ListType:
                        # If the first item is a list, then all of the items
                        # are lists
                        if depth >= 2:
                            self.debug(1,
                               "Competence Elements exceed list depth (2)")
                            # We have a problem with sub-sub lists
                            return None
                        rlist =[]
                        for x in elements:
                            rlist.append(read_competence_elements(competence,
                                                                  x,
                                                                  timeout,
                                                                  depth =
                                                                  depth + 1))
                        #print rlist
                        return rlist
                    else:
                        # This list represents a competence element
                        label = elements[0]
                        trigger_ap = elements[1][1]
                        action = elements[2]
                        if len(elements) > 3:
                            retries = int(elements[3]) # int() is new, was just = elements[3] (Sam, 17/2/2005)
                        else:
                            retries = -1
                        robj = Competence_Element(competence = competence,
                                                  ce_label = label,
                                                  action = Generic(
                            name = action,
                            command = "request",
                            tag = label,
                            action = action,
                            agent = self),
                                                  retries = retries,
                                                  trigger =
                                                  return_action_pattern(
                            ap_guts = trigger_ap,
                            name = label + "_trigger",
                            timeout = timeout,
                            timeout_rep = trigger_ap),
                                                  agent = self)
                        self.add_competence_element(label, robj)
                        return robj
                else:
                    self.debug(1,
                               "Competence Element Incompatible (Expecting a list)")
                    # Error: Elements format incompatible
                 
            def read_drive_collection(item):
                if item[0] == "RDC":
                    realtime = 1
                else:
                    realtime = 0

                name = item[1]
                self.debug(5, "Reading Drive Collection - " + name)
                goal = item[2]
                elements = item[3]
                del(elements[0]) # Strip off the item with the string "drives"
                self.drive_collection = Drive_Collection(name = name,
                                                         command = "request",
                                                         realtime = realtime,
                                                         tag = name,
                                                         action = "posh",
                                                         goal =
                                                         Competence_Element(
                    competence = "see_action_tag",
                    action = Generic(name = str(name) + "goal",
                                     command = "request",
                                     tag = str(name) + "goal",
                                     action = None,
                                     agent = self),
                    trigger = \
                            return_action_pattern(ap_guts = goal[1],
                                                  name = str(name) + \
                                                  "_goal_trigger",
                                                  timeout = 0,
                                                  timeout_rep = None),
                    agent = self),
                                                         elements = \
                            read_drive_elements(elements, name),
                                                         agent = self)
                                                           
            def read_drive_elements(elements, drive_collection, depth = 0):
                if type(elements) is ListType:
                    if type(elements[0]) is ListType:
                        # If the first item is a list, then all of the items
                        # are lists
                        if depth >= 2:
                            self.debug(1,
                               "Drive Elements exceed list depth (2)")
                            # We have a problem with sub-sub lists
                            return None
                        rlist =[]
                        for x in elements:
                            rlist.append(read_drive_elements(x,
                                                             drive_collection,
                                                             depth = depth+1))
                        return rlist    
                    else:
                        # This list represents a drive element
                        drive_name = elements[0]
                        trigger_ap = elements[1][1]
                        drive_root = elements[2]
                        if len(elements) > 3:
                            frequency_rep = elements[3]
                            frequency = self.fix_time(frequency_rep)
                        else:
                            frequency_rep = None
                            frequency = -1
                        robj = Drive_Element(drive_collection \
                                             = drive_collection,
                                             drive_root_rep = drive_root,
                                             drive_root =
                                             Generic(
                            name = drive_root,
                            drive_name = drive_name,
                            command = "request",
                            tag = drive_name,
                            action = drive_root,
                            agent = self),
                                             frequency = frequency,
                                             frequency_rep = frequency_rep,
                                             drive_name = drive_name,
                                             trigger =
                                             return_action_pattern(
                            ap_guts = trigger_ap,
                            name = drive_name + "_trigger",
                            timeout = -1,
                            timeout_rep = trigger_ap),
                                             agent = self)
                        self.add_drive_element(drive_name, robj)
                        return robj
                else:
                    self.debug(1,
                        "Drive Element Incompatible (Expecting a list)")
                    # Error: Elements format incompatible                

            # Parses the type of each element and calls the corresponding
            # function to add the object to the cache
            for item in input_list:
                if type(item) is ListType:
                    if item[0] == "C":
                        read_competence(item)
                    elif item[0] in ("DC", "RDC"):
                        read_drive_collection(item)
                    elif item[0] == "AP":
                        read_action_pattern(item)
                    elif type(item[0]) is ListType:
                        read_objects(item)
                    else:
                        self.debug(1, "Token invalid (Expecting C, DC, RDC, AP) - " + str(item[0]))
                        # Return Error
                else:
                    self.debug(1, "Invalid top-level item (Expecting a list) " + str(item))
                    # Return Error

            return 1

    
        # Read in the file into a string, strip all the comments and
        # format the string into a flat list of objects. This flat
        # list is then passed to make_list which creates the list recursively
        return read_objects(read_list(strip_comments(planfile.read())))

    # Unifies the time representation into seconds
    def fix_time(self, time_list):
        if type(time_list) is ListType:
            valuestr = time_list.pop()
            value = float(valuestr)
            unit = time_list.pop()
            if value:
                if unit in ("none", "absolute", "not_real_time"):
                    return value
                elif unit in ("minute", "minutes", "min"):
                    return value * 60
                elif unit in ("second", "seconds", "sec"):
                    return value
                elif unit in ("hertz", "hz"):
                    return 1 / value
                elif unit in ("per-minute", "pm"):
                    return 60 / value
                else:
                    self.debug(1, "Invalid time unit - " + str(unit))
            else:
                # The time value is not a numeric
                self.debug(1, "Invalid time value - Not a int or float - " + str(valuestr))
        else:
            # We didn't get a list pass in.
            self.debug(1, "Invalid time list format - Not a list" + str(time_list))

    # Start up execute_core in this thread
    def execute(self):
        if not self.exec_thread_id:
            return self.execute_core()
        else:
            self.debug(1, "Execure thread running. Cannot run execute_core()")
            return 0

    # Start up execute_core in new thread
    def execute_thread(self):
        if not self.exec_thread_id:
            self.exec_thread_id = thread.start_new_thread(self.execute_thread_wrapper, ())
#	    self.exec_thread_id = thread.start_new(self.execute_thread_wrapper, ())
        else:
            self.debug(1, "Execure thread running. Cannot start new thread.")
            return 0
        
    def execute_thread_wrapper(self):
        self.execute_core()
        self.exec_thread_id = None

    def execute_core(self):
        if not self.behavior_instance: 
            self.debug(1, "No behavior bound to this agent - Cannot Execute.")
            return 0
        if not self.start_prepare():
            self.debug(1, "Agent behavior is not ready and timed out. Stop execute.")
            return 0
        self.exec_flag = 1
        ### For profiling
        # counter2 = 0
        ### For Hertz Counter ###
        counter = 0
        last_sec = int(posh_utils.current_time())
        if self.drive_collection.realtime:
            # Real-Time timestamps
            result = None
            
            bi_check = not self.behavior_instance.check_error()
            if bi_check:
                self.debug(5, "Behavior check OK.")
            else:
                self.debug(1, "Behavior reported an ERROR!")
            
            while (result != "drive_lost") and (result != "drive_won") and \
                  self.exec_flag and bi_check:

                timestamp = posh_utils.current_time()
                ################################
                #counter2 += 1
                #if counter2 > 10000:  # For Profiling
                #    self.exit()
                ################################
                # For Hz Counter
                counter += 1
                if (self.rt_bb_sched_debug) and (int(timestamp) != last_sec):
                    last_sec = int(timestamp)
                    hertz = counter
                    counter = 0
                    self.debug(7, "RT Hertz (Approximately)- " + repr(hertz))
                    self.debug(7, "BB Length - " + str(len(self.blackboard._Blackboard__bb)))
                    self.debug(7, "Sched Length - " + str(len(self.schedule._Schedule__schedule)))
                ################################
                if (self.rt_execute_debug):
                    self.debug(9, "New RT Execute Run at - " + repr(timestamp))
                self.blackboard.check_bb()
                result = self.driver(drive_collection = self.drive_collection, timestamp = timestamp)
                ### To limit Hz
                if self.driver_delay and self.delay_multiplier:
                    if not (counter % self.delay_multiplier):
                        time.sleep(self.driver_delay)

		if self.behavior_instance.check_error():
                    bi_check = 0 # error occured
                    self.debug(1, "Behavior reported an ERROR!")

                # (Jimmy) ... this can be used to pause the main loop, for whatever reason
                while self.pause_flag:
                    if not self.exec_flag: break # exit this waiting while and then exits main loop
                    time.sleep(1)    
                    
        else:
            # Incremented Timestamps
            timestamp = 0
            result = None
            bi_check = not self.behavior_instance.check_error()
            if bi_check:
                self.debug(5, "Behavior check OK.")
            else:
                self.debug(1, "Behavior reported an ERROR!")

            while (result != "drive_lost") and (result != "drive_won") and \
                  self.exec_flag and bi_check:
                
                timestamp = timestamp + 1
                ################################
                #counter2 += 1
                #if counter2 > 10000:  # For Profiling
                #    self.exit()
                ################################
                # For Hz Counter
                now = posh_utils.current_time()
                counter += 1
                if (self.rt_bb_sched_debug) and (int(now) != last_sec):
                    last_sec = int(now)
                    hertz = counter
                    counter = 0
                    self.debug(7, "Iter. Hertz (Approx.)- " + repr(hertz))
                    self.debug(7, "BB Length - " + str(len(self.blackboard._Blackboard__bb)))
                    self.debug(7, "Sched Length - " + str(len(self.schedule._Schedule__schedule)))
                ################################
                if (self.rt_execute_debug):                    
                    self.debug(9, "New Iterative Execute Run at - " + repr(timestamp))
                self.blackboard.check_bb()
                result = self.driver(drive_collection = self.drive_collection,
                            timestamp = timestamp)
                ### To limit Hz
                if self.driver_delay and self.delay_multiplier:
                    if not (counter % self.delay_multiplier):
                        time.sleep(self.driver_delay)
			
                if self.behvior_instance.check_error():
                    bi_check = 0 # error occured
                    self.debug(1, "Behavior reported an ERROR!")
                
        self.debug(5, "Life Ended: Result - " + str(result))
        return result


    def mason_init(self):
	if not self.behavior_instance:
            self.debug(1, "No behavior bound to this agent - Cannot Execute")
            return 0
        if not self.start_prepare():
            self.debug(1, "Agent behavior is not ready and timed out. Stop execute.")
            return 0
        self.exec_flag = 1
	self.timestamp = 0
	self.counter = 0
	self.last_sec = 0
	self.result = None


    def mason_loop(self):
	
            # Incremented Timestamps
        
     
            
        if (self.result != "drive_lost") and (self.result != "drive_won") and \
              self.exec_flag: # and self.behavior_instance.check_error() == 0:
#            self.timestamp = self.timestamp + 1
            self.timestamp = posh_utils.current_time()
#            ################################
#            #counter2 += 1
#            #if counter2 > 10000:  # For Profiling
#            #    self.exit()
#            ################################
            # For Hz Counter
#            now = posh_utils.current_time()
#            self.counter += 1
#            if int(now) != self.last_sec:
#                self.last_sec = int(now)
#                hertz = self.counter
#                self.counter = 0
#                self.debug(7, \
#                  "Iter. Hertz (Approx.)- " + repr(hertz))
#                self.debug(7, "BB Length - " + \
#                  str(len(self.blackboard._Blackboard__bb)))
#                self.debug(7, "Sched Length - " + \
#                  str(len(self.schedule._Schedule__schedule)))
#            ################################
#            self.debug(9, \
#            "New Iterative Execute Run at - " + repr(self.timestamp))
#	  

            self.blackboard.check_bb()
            self.result = self.driver(drive_collection = self.drive_collection,
                        timestamp = self.timestamp)
#
#                    ### To limit Hz
#            if self.driver_delay and self.delay_multiplier:
#                if not (self.counter % self.delay_multiplier):
#                    time.sleep(self.driver_delay)
                    
        else:
            print "eep"
                        
                        
    
    
    def driver(self,
               drive_collection = None,
               timestamp = posh_utils.current_time()):
        # The main loop that runs the agent
        if drive_collection == None:
            drive_collection = self.drive_collection

        if drive_collection.goal.ready():
            return "drive_won"

        # Simple routine to test frequency
        def time_test(element, timestamp):
        
            if (element.frequency <= 0) or (element.frequency < (timestamp - element.last_fired)):
                
                ##########################################################
                # timestamp was just time, but this crashed (Sam, 14/2/5)
                # after the change it didn't crash but the things which
                # used it never fired!  So changed > to <
                ##########################################################
                self.debug(DEBUG_DETAIL_OPERATION, "Timetest 1")
                return 1
            else:
                self.debug(DEBUG_DETAIL_OPERATION, "Timetest 0")
                return 0

        for element_list in drive_collection.elements:
            for element in element_list:
                # (Jimmy) change to 14 in respect to Drive / Competence / AP messages
                self.debug(14, "Processing Drive Element - " + str(element.drive_name))

                # I think it's good to know wether element is ready or timeout (Jimmy)
                if time_test(element, timestamp):
                    if element.ready():

                        # (Jimmy) changed to level 10 ... if we wish only to know which drive was currently selected (not timed out + trigger fires)
                        self.debug(10, "Drive - " + str(element.drive_name + " - is ready to run."))
                        
                        if self.schedule.run_drive(element.drive_name):
                            self.debug(DEBUG_DETAIL_OPERATION, "Drive - " + str(element.drive_name) + " has 1+ items on the sched." )
                            element.last_fired = timestamp
                        else:
                            self.debug(DEBUG_DETAIL_OPERATION, "Drive - " + str(element.drive_name) + " has no items on the sched." )
                            self.debug(DEBUG_DETAIL_OPERATION, "Adding drive_root of - " + str(element.drive_name) + " to the sched.")
                            element.drive_root.send( content = element.drive_root.make_content(), timestamp = timestamp)
                            # print element.drive_root.make_content()
                            # print vars(element.drive_root.make_content())
                        return 1
                    else:
                        self.debug(DEBUG_DETAIL_OPERATION, "Drive - " + str(element.drive_name) + " not ready (trigger didn't fire)." )
                else:
                    # We should put some debug stuff here
                    self.debug(DEBUG_DETAIL_OPERATION, "Drive - " + str(element.drive_name) + " inhibited (timeout)." )
                    
        # If nothing happened, we have a problem
        self.debug(1, "All drives lost focus - ended or will not run.")
        return "drive_lost"

    # Flag the variable to make the loop stop
    def stop_execute(self):
        self.debug(5, "Stop Execute Command Received.")
        self.exec_flag = 0

    # Flag the variable to pause the loop
    def pause_execute(self):
        self.debug(5, "Pause Execute Command Received.")
        self.pause_flag = 1

    # Flag the variable to resume the loop
    def resume_execute(self):
        self.debug(5, "Resume Execute Command Received.")
        self.pause_flag = 0

    # Tell everybody that we are exiting and close connections
    def exit(self):
        self.debug(5, "Exit Command Received - Prepare to exit.")
        self.stop_execute()
        try:
            self.behavior_instance.exit_prepare()
        except:            
            pass
        

    # Sometimes the agent has to wait for the behavior to finish
    # startup tasks. This allows the agent to sync up with the
    # behavior first. Mainly called from 
    def start_prepare(self, limit = 30):
        self.debug(5, "Waiting for behavior ready.")
        counter = 0
	
	# Cycles till timeout
        while self.behavior_instance.check_error() and counter < limit:
            counter += 1
            time.sleep(1)
	               
        if counter >= limit:
            self.debug(1, "Behavior check_error() Timed Out.")
            return 0
        else:
            self.debug(5, "Behavior ready.") 
            return 1
	

	 
